package org.apache.jetspeed.portlet;

import java.util.Enumeration;
import java.util.Locale;

/**
 * The <CODE>PortletConfig</CODE> interface provides the portlet with
 * its configuration. The configuration holds information about the
 * portlet that is valid for all users, and is maintained by the
 * developer. The portlet can therefore only read the configuration.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see Portlet
 */
public interface PortletConfig extends javax.servlet.ServletConfig
{
    /**
     ** Returns the name of the portlet. The portlet container needs the
     ** portlet name for administration purposes.
     **
     ** @return   the portlet name
     **/

    public String getName ();

    /**
     ** Returns whether the portlet window supports the given state
     **
     ** @param   state
     **          the portlet window state to be supported
     **
     ** @return   <CODE>true</CODE> if the portlet window provides support, <BR>
     **           <CODE>false</CODE> otherwise
     **/

    public boolean supports (PortletWindow.State state);

    /**
     ** Returns whether the portlet supports the given mode for
     ** the given client.
     **
     ** @param   mode
     **          the portlet mode to be supported
     ** @param   client
     **          the client to be supported
     **
     ** @return   <CODE>true</CODE> if the portlet provides support, <BR>
     **           <CODE>false</CODE> otherwise
     **/

    public boolean supports (Portlet.Mode mode, Client client);

    /**
     ** Returns the portlet context.
     **
     ** @return   the portlet context
     **/

    public PortletContext getContext ();

}
