package org.apache.jetspeed.portlet;

/**
 ** The <CODE>PortletException</CODE> class defines a general exception
 ** that a portlet can throw when it encounters difficulty.
 **
 ** @author   <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public class PortletException extends javax.servlet.ServletException
{
    /**
     ** Constructs a new portlet exception.
     **/

    public PortletException ()
    {
        super();
    }

    /**
     ** Constructs a new portlet exception with the given text. The
     ** portlet container may use the text write it to a log.
     **
     ** @param   text
     **          the exception text
     **/

    public PortletException (String text)
    {
        super (text);
    }

    /**
     ** Constructs a new portlet exception when the portlet needs to throw an
     ** exception and include a message about the "root case" that interfered
     ** with its normal operation, including a description message.
     **
     ** @param   text
     **          the exception text
     ** @param   cause
     **          the root cause
     **/

    public PortletException (String text, Throwable cause)
    {
        super (text, cause);
    }

    /**
     ** Constructs a new portlet exception when the portlet needs to throw an
     ** exception. The exception's message is based on the localized message
     ** of the underlying exception.
     **
     ** @param   cause
     **          the root cause
     **/

    public PortletException (Throwable cause)
    {
        super (cause);
    }

    /**
     * Prints the stack trace of this exception to the standard error stream.
     */
    public void printStackTrace()
    {
        this.printStackTrace(System.err);
    }

    /**
     * Prints the stack trace of this exception to the specified print stream.
     *
     * @param out the <code>PrintStream</code> to use for output
     */
    public void printStackTrace(java.io.PrintStream out) 
    {
        this.printStackTrace(new java.io.PrintWriter(out, true));
    }

    /**
     * Prints the stack trace of this exception to the specified print writer.
     * 
     * @param out the <code>PrintWriter</code> to use for output.
     */
    public void printStackTrace(java.io.PrintWriter out)
    {
        super.printStackTrace(out);

        if( getRootCause () != null )
        {
            out.println();
            out.print("Nested Exception is ");
            getRootCause ().printStackTrace(out);
        }
    }

}
