package org.apache.jetspeed.portlet;

import java.io.IOException;

/**
 * The <CODE>PortletTitleListener</CODE> interface has to be implemented if
 * a portlet wants to support client, device, and/or user dependent
 * titles.<BR>
 * The interface has to be implemented additionally to the <CODE>Portlet</CODE>
 * interface, otherwise the portlet container will pick the title from the
 * portlet configuration.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see PortletWindow
 */
public interface PortletTitleListener
{
    /**
     ** Called by the portlet container to render the portlet title.
     ** THe information in the portlet request (like locale, client,
     ** and session information) can but doesn't have to be
     ** considered to render dynamic titles.. Examples are
     **
     ** <UL>
     ** <LI>language-dependant titles for multi-lingual portals
     ** <LI>shorter titles for WAP phones
     ** <LI>the number of messages in a mailbox portlet
     ** </UL>
     **
     ** The session may be <CODE>null</CODE>, if the user is not logged
     ** in.
     **
     ** @param   request
     **          the portlet request
     ** @param   response
     **          the portlet response
     **
     ** @exception   PortletException
     **              if the portlet title has trouble fulfilling the
     **              rendering request
     ** @exception   IOException
     **              if the streaming causes an I/O problem
     **/

    public void doTitle (PortletRequest request,
                         PortletResponse response) throws PortletException,
                                                          IOException;

}
