package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.*;

/**
 ** An <CODE>ActionEvent</CODE> is sent by the portlet container when
 ** an HTTP request is received that is associated with an action.
 **
 ** @see   PortletAction
 ** @see   ActionListener
 **
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public interface ActionEvent extends Event
{
    /**
     ** Event identifier indicating that portlet request has been
     ** received that one or more actions associated with it. Each
     ** action will result in a separate event being fired.
     **
     ** <P>
     ** An event with this id is fired when an action has to be
     ** performed.
     **/

    public final static int ACTION_PERFORMED = 1001;

    /**
     ** Returns the action that this action event carries.
     **
     ** @return   the portlet action
     **/

    public PortletAction getAction ();
}