package org.apache.jetspeed.portlet.event;

import java.lang.Object;
import java.lang.String;

import org.apache.jetspeed.portlet.*;

/**
 * This is the event class for notifications about changes to the attributes
 * of the portlet settings of a concrete portlet.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see PortletSettingsAttributesListener
 * @since Version 1.1
 */
public interface PortletSettingsAttributeEvent extends Event
{

    /**
     * Return the PortletSettings that changed.
     * 
     * @return The PortletSettings that sent the event.
     */
    public PortletSettings getPortletSettings();

    /**
     * Return the name of the attribute that changed on the PortletSettings.
     * 
     * @return the name of the attribute
     */
    public String getName();

    /**
     * Returns the value of the attribute being added removed or replaced. If the
     * attribute was added, this is the value of the attribute. If the attrubute was
     * removed, this is the value of the removed attribute. If the attribute
     * was replaced, this is the old value of the attribute.
     * 
     * @return The value of the attribute
     */
    public String getValue();

}