package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.filter.*;

// turbine
import org.apache.turbine.util.Log;
import org.apache.turbine.services.resources.TurbineResources;

// java
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Map;
import java.util.Locale;
import java.io.IOException;
import javax.servlet.*;

import com.ibm.wps.util.ObjectID;

public class PortletSettingsImpl implements PortletSettings
{
    private int                         cpidInt = 0;
    private PortletApplicationSettings  applicationSettings = null;
    private ConcretePortletEntry        concretePortletEntry = null;
    private PortletEntry                rootPortlet = null;
    private PortalInformationProvider   provider = null;
    private boolean                     isDirty = false;
    private HashMap                     attributes = null;
    
    public PortletSettingsImpl(ConcretePortletEntry concretePortletEntry,
                               PortalInformationProvider provider)
    {
        this.concretePortletEntry = concretePortletEntry;
        cpidInt = concretePortletEntry.getPid().intValue();

        if (provider==null) { // can happen when portlet is logged out
            provider = new com.ibm.wps.portletcontainer.PortalInformationProviderImpl();
        }
        this.provider = provider;
        
        rootPortlet = concretePortletEntry.getRootPortlet();

        applicationSettings = new PortletApplicationSettingsImpl(
            this.concretePortletEntry,
            this.provider);
    }
    
    public Locale getDefaultLocale()
    {
        return concretePortletEntry.getDefaultLocale();
    }

    public String getTitle (Locale locale,
                            Client client)
    {
        return concretePortletEntry.getTitle(locale,((ClientImpl)client).getClientEntry());
    }

    public boolean supports (Locale locale)
    {
        Enumeration supportedLanguages = concretePortletEntry.getSupportedLanguages( );
        while (supportedLanguages.hasMoreElements()) {
            Locale language = (Locale)supportedLanguages.nextElement();
            if (language.equals(locale)) return true;
        }
        if (!locale.getVariant().equals("")) { 
            // Variant is in locale, but no supported Language is found so far
            // thus, check just for Language and Country
            locale = new Locale(locale.getLanguage(),locale.getCountry(), "");
            return supports(locale);
        }
        if (!locale.getCountry().equals("")) { 
            // Country is in locale, but no supported Language is found so far
            // thus, check just for Language
            locale = new Locale(locale.getLanguage(), "", "");
            return supports(locale);
        }
        // as last fallback, search just for language
        supportedLanguages = concretePortletEntry.getSupportedLanguages( );
        while (supportedLanguages.hasMoreElements()) {
            Locale language = (Locale)supportedLanguages.nextElement();
            if (language.getLanguage().equalsIgnoreCase(locale.getLanguage())) return true;
        }
        return false;
    }

    public void setAttribute (String name, String value) throws AccessDeniedException
    {
        if (!isAllowed())
            throw new AccessDeniedException();

        if (!isInitialized())
            init();

        attributes.put( name, value );
        setDirty(true);
    }

    public String getAttribute (String name)
    {
        if (!isInitialized())
            init();

        return (String)attributes.get( name );
    }

    public Enumeration getAttributeNames ()
    {
        if (!isInitialized())
            init();

        return new Hashtable(attributes).keys();
    }

    public void removeAttribute (String name) throws AccessDeniedException
    {
        if (!isAllowed())
            throw new AccessDeniedException();

        if (!isInitialized())
            init();

        attributes.remove( name );        
        setDirty(true);
    }

    public void store () throws AccessDeniedException, IOException
    {
        if (!isAllowed())
            throw new AccessDeniedException();

        if (!isInitialized())
            init();

        if (isDirty()) {
            if (concretePortletEntry!=null) {
                try {
                    concretePortletEntry.setParameters(attributes);
                    provider.setConcretePortletEntry(concretePortletEntry);
                }
                catch (IOException e) {
                    org.apache.turbine.util.Log.error("PortletSettingsImpl.store: Unable to store portlet settings for PID="+cpidInt,e);
                    throw e;
                }
                setDirty(false);
            }
        }
    }

    public PortletApplicationSettings getApplicationSettings()
    {
        return applicationSettings;
    }

    // additional methods

    public boolean isDirty()
    {
        return isDirty;
    }

    private void addAllFrom (Map parameters)
    {
        attributes.putAll(parameters);
        setDirty(false);
    }

    private void setDirty(boolean dirty)
    {
        isDirty = dirty;
    }

    public String getStaticPortletTitle(Locale locale,
                                        Client client)
    {
        return concretePortletEntry.getTitle(locale, ((ClientImpl)client).getClientEntry());
    }

    private boolean isInitialized()
    {
        return attributes!=null;
    }

    private boolean isAllowed()
    {
        if (org.apache.turbine.services.resources.TurbineResources.getBoolean(
            Constants.RESTRICT_ACCESS,true))
        {
            if (!com.ibm.wps.util.ListenerConverter.isIgnoreModeToStoreData(
                ((com.ibm.wps.portletcontainer.PortletEntryImpl)rootPortlet).getListeners()) )
            {
                Portlet.Mode portletMode = 
                    (Portlet.Mode)ThreadAttributesManager.getAttribute(Constants.PORTLET_MODE);
                if (portletMode==null)
                    return false;
                if (portletMode!=Portlet.Mode.CONFIGURE)
                    return false;
            }
        }
        return true;
    }

    private void init()
    {
        // allow late initialization of attributes
        if (!isInitialized())
        {
            attributes = new HashMap();
            if (this.concretePortletEntry!=null)
            {
                addAllFrom(this.concretePortletEntry.getParameters());
            }
        }
    }

    // needs to be overwritten, because the Portlet API depends on equal Settings objects for
    // one Concrete Portlet

    public boolean equals( Object obj ) {
        if ( this == obj) {
            return true;
        }
        
        if (obj instanceof PortletSettingsImpl) {
            PortletSettingsImpl comp = (PortletSettingsImpl)obj;
            return this.hashCode()==comp.hashCode();
        } else {
            return false;
        }
    }

    public int hashCode()
    {
        return cpidInt;
    }
}
