package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.ConcretePortletEntry;
import org.apache.jetspeed.portletcontainer.invoker.PortletInvokerException;
import org.apache.jetspeed.portletcontainer.information.PortalInformationProvider;

// turbine
import org.apache.turbine.util.Log;

public class PortletSettingsAttributeEventImpl
extends EventImpl implements PortletSettingsAttributeEvent
{
    public static final int SETTING_ADDED = 1;
    public static final int SETTING_REPLACED = 2;
    public static final int SETTING_REMOVED = 3;

    private int type = -1;
    private ConcretePortletEntry concretePortlet = null;
    private PortalInformationProvider provider = null;
    private PortletSettings portletSettings = null;
    private String attributeName = null;
    private String attributeValue = null;

    public PortletSettingsAttributeEventImpl( int type,
                                              ConcretePortletEntry concretePortlet,
                                              PortalInformationProvider provider,
                                              String attributeName,
                                              String attributeValue )
    {
        super( null );

        this.type = type;
        this.concretePortlet = concretePortlet;
        this.provider = provider;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }


    public PortletSettings getPortletSettings()
    {
        if (this.portletSettings!=null)
        {
            this.portletSettings = new PortletSettingsImpl( concretePortlet,
                                                            provider );
        }
        return this.portletSettings;
    }

    public String getName()
    {
        return attributeName;
    }

    public String getValue()
    {
        return attributeValue;
    }

    // additonal methods

    public int getType()
    {
        return type;
    }

    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        // do nothing
    }

}