/*
 *
 * Copyright (c) 1998 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. Every modification must be notified to the Java Apache Project
 *    and redistribution of the modified code without prior notification
 *    is not permitted in any form.
 *
 * 4. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Java Apache Project
 *    (http://java.apache.org/)."
 *
 * 5. The names "Jetspeed", "Apache Jetspeed" and "Apache Jetspeed
 *    Project" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Java Apache Project
 *    (http://java.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * License version 1.0
 *
 */

package org.apache.jetspeed.portletcontainer.invoker;

//jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

//turbine stuff
import org.apache.turbine.util.*;
import org.apache.turbine.services.TurbineServices;

// java stuff
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.*;
import java.util.*;

/**
 * The <CODE>PortletInvoker</CODE> interface represents the portlet api
 * implementation. All other parts have to access the portlet api implementation
 * via this interface.
 * 
 * @author <A HREF="mailto:shesmer@raleigh.ibm.com">Stephan Hesmer</A>
 */
public class PortletInvokerAccess {

    /**
     * Method for getting a reference to the service singleton
     * 
     * @return the reference to this singleton
     */
    public static PortletInvokerService getService() {
        return(PortletInvokerService)TurbineServices
        .getInstance()
        .getService(PortletInvokerService.SERVICE_NAME);
    }

    /**
     * Indicates that a new portal page is being rendered. The portlets
     * included inside of the page has to be passed as piid/pid pair of the type string.<BR>
     * At this point the response must not be committed, so that portlets are able
     * to set Headers or add cookies. This function guarantees, that nothing is written
     * on the output stream.
     * 
     * @param portlets collection containing all portlets of this page as PortletInstanceEntry
     * @param request  the servlet request
     * @param response the servlet response
     * @param provider the portal information provider
     * @exception PortletException
     * @exception PortletInvokerException
     */
    public static void initPage( Collection portlets,
                                 HttpServletRequest request,
                                 HttpServletResponse response,
                                 PortalInformationProvider provider ) 
    throws PortletException, PortletInvokerException
    {
        getService().initPage( portlets, request, response, provider );
    }

    /**
     * This function has to be called before the first portletService method. Portlets
     * will output here javascript,...
     * 
     * @param request  the servlet request
     * @param response the servlet response
     * @param provider the portal information provider
     * @exception PortletException
     * @exception PortletInvokerException
     */
    public static void beginPage( HttpServletRequest request,
                                  HttpServletResponse response,
                                  PortalInformationProvider provider )
    throws PortletException, PortletInvokerException
    {
        getService().beginPage( request, response, provider );
    }

    /**
     * Indicates that the page has rendered completely.
     */
    public static void endPage( HttpServletRequest request,
                                HttpServletResponse response,
                                PortalInformationProvider provider)
    throws PortletException, PortletInvokerException
    {
        getService().endPage(request, response, provider);
    }

    /**
     * Calls the service method of the given portlet.
     * 
     * @param entry    the concrete portlet instance
     * @param request  the servlet request
     * @param response the servlet response
     * @param provider the portal information provider
     * @exception PortletException
     * @exception IOException
     */
    public static void portletService (PortletInstanceEntry entry,
                                       HttpServletRequest request,
                                       HttpServletResponse response,
                                       PortalInformationProvider provider) throws PortletException,
    IOException,
    PortletInvokerException
    {
        getService().portletService( entry, request, response, provider );
    }

    /**
     * Returns an <CODE>PortletLayoutWindow</CODE> of the related portlet
     * to get information about its portlet window.
     * 
     * @param entry    the concrete portlet instance
     * @param request the servlet request
     * @param response the servlet response
     * @return a reference to the PortletLayoutWindow
     * @exception PortletException
     */
    public static void
    includePortletTitle(PortletInstanceEntry entry,
                        HttpServletRequest request,
                        HttpServletResponse response,
                        PortalInformationProvider provider) throws PortletException,
    PortletInvokerException
    {
        getService().includePortletTitle( entry, request, response, provider );
    }

    /**
     * Notifies the portlet container that the given event occured and
     * that the event has to be performed.
     * 
     * @param event      the event to be performed
     * @param parameters parameters of the event
     */
    public static void perform(PortletInvokerService.Event event, 
                               HttpServletRequest request,
                               HttpServletResponse response,
                               Map parameters) throws PortletException,
    PortletInvokerException
    {
        getService().perform( event, request, response, parameters );
    }

}
