/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portletcontainer.om.portletinstanceregistry;

import org.apache.jetspeed.portletcontainer.om.applicationinstanceregistry.ApplicationInstanceEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.ConcretePortletEntry;
import com.ibm.wps.util.ObjectID;
import java.util.Map;

/**
 * <P>
 * The <CODE>PortletInstanceEntry</CODE> interface represents the portlet instance
 * date of one portlet. It is accessed by the portlet container
 * to get portlet instance information about a specific portlet.
 * </P>
 * <P>
 * The interfaces defined in this package represent an abstract object
 * model (OM) that is applicable for different implementations.
 * The abstract OM defines only how the data is stored and accessed
 * in the memory. Each implementation can store the data in different ways.
 * </P>
 * <P>
 * This abstraction layer helps to generalize the portlet container from
 * special implementations like data storage and moreover it is not bound
 * to a special Application Server.
 * </P>
 * 
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public interface PortletInstanceEntry
{

    /**
     * Returns the portlet instance identifier of this
     * portlet instance data entry
     * 
     * @return the portlet instance identifier
     */
    public ObjectID getPiid();

    /**
     * Returns the portlet application instance that the portlet
     * runs in as a string.
     * 
     * @return the portlet application instance
     */
    public ApplicationInstanceEntry getApplicationInstance ();

    /**
     * Returns the concrete portlet of this
     * portlet instance data entry
     * 
     * @return the portlet entry
     */
    public ConcretePortletEntry getConcretePortlet();

    /**
     * Returns a hashtable containing name[string]/value[object] pairs of all parameters
     * of this portlet.
     * 
     * @return a hashtable containing name[string]/value[object] pairs
     */
    public Map getParameters ();

    /**
     * Returns whether the value of the given parameter name is already loaded.
     * 
     * @param name   the parameter name
     * @return true, when the value of the given parameter name is already loaded.
     */
    public boolean isParameterValueAvailable(String name);

    /**
     * Returns the value of the given parameter name.
     * 
     * @param name   the parameter name
     * @return the value of the given parameter name.
     */
    public Object loadParameterValue(String name);

    /**
     * Sets a hashtable containing name[string]/value[object] pairs of all parameters
     * of this portlet.
     * 
     * @param parameters    a hashtable containing name[string]/value[object] pairs
     */
    public void setParameters (Map parameters);

}
