/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package org.apache.jetspeed.portletcontainer.tags;

import java.lang.reflect.*;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.Constants;
import org.apache.regexp.*;

/**
 ** Supporting class for the <CODE>createURI</CODE> tag.
 ** Creates a URI that points at the current portlet with the given parameters.
 ** Returns the URI at the end tag. Tag parameter:
 ** <UL>
 ** <LI><CODE>state</CODE> (optional) - the portlet window state
 ** </UL>
 ** @see   org.apache.jetspeed.portlet.PortletWindow.State
 ** @see   URIActionTag
 ** @see   URIParameterTag
 **
 ** @author   <a href="mailto:h.schwarz@de.ibm.com">Hagen Schwarz</a>
 **/
public class CreateURITag extends BodyTagSupport {   

    private static Hashtable states = new Hashtable();

    static {
        Field[] fields;

        //Create hashtables with fieldnames
        try
        {
            //For parameter iCapability
            fields = PortletWindow.State.class.getFields();
            for (int i = 0; i < fields.length; i++)
            {
                PortletWindow.State state = 
                    (PortletWindow.State)fields[i].get(null);
                states.put(state.toString(),state);
            }
        }
        catch (IllegalAccessException exc)
        {
            System.err.println("CreateURITag: CreateURITag(): Error with Field.get(null): " + exc.toString());
        }
    }

    /**
     * Processes the <CODE>createURI</CODE> start tag. Creates the variable <CODE>portletURI</CODE>.
     * @return <CODE>EVAL_BODY_TAG</CODE>
     */
    public int doStartTag ()
    {
        PortletResponse portletResponse = (PortletResponse)pageContext.getRequest().getAttribute(Constants.PORTLET_RESPONSE);
        try
        {
            PortletURI portletURI;
            
            if (iState == null)
               portletURI = portletResponse.createURI();
            else
            {
                PortletWindow.State state = (PortletWindow.State)states.get(iState);
                if (state == null)
                    portletURI = portletResponse.createURI();
                else
                    portletURI = portletResponse.createURI(state);
            }
            
            pageContext.setAttribute ("portletURI", portletURI);
        }
        catch(Throwable t)
        {
            PortletConfig portletConfig = (PortletConfig)pageContext.getRequest().getAttribute(Constants.PORTLET_CONFIG);
            PortletContext portletContext = portletConfig.getContext();
    
            PortletLog portletLog = portletContext.getLog();
            portletLog.error("CreateURITag: doStartTag() Error with state parameter: ", t);
        }

        iState = null;
        
        return EVAL_BODY_TAG;   //To add attributes using URIParameterTag or URIActionTag
    }

    /**
     * Processes the <CODE>createURI</CODE> end tag. Writes the just created URI to the JSP.
     * Removes the variable <CODE>portletURI</CODE>.
     * @return <CODE>EVAL_PAGE</CODE>
     */
    public int doEndTag ()
    {
        try
        {
            PortletURI portletURI = (PortletURI)pageContext.getAttribute("portletURI");

            if (portletURI != null)   //If no error creating the attribute in doStartTag()
                pageContext.getOut().print( portletURI.toString() );

            pageContext.removeAttribute ("portletURI");
        }
        catch (IOException exc)
        {
            PortletConfig portletConfig = (PortletConfig)pageContext.getRequest().getAttribute(Constants.PORTLET_CONFIG);
            PortletContext portletContext = portletConfig.getContext();

            PortletLog portletLog = portletContext.getLog();
            portletLog.error("CreateURITag: doStartTag() Error writing to output stream: ", exc);
        }

        return EVAL_PAGE;
    }


    private String iState = null;
    /**
    * The setter for the <CODE>state</CODE> parameter.
    * @param aState java.lang.String
    */
    public void setState(String aState)
    {
        iState = aState;
    }

}