package org.apache.jetspeed.portletcontainer.util;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portlet.spi.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.event.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

// turbine
import org.apache.turbine.util.Log;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.InputStream;
import java.io.IOException;
import java.util.*;
import java.lang.Math;

import com.ibm.wps.portletcontainer.*;

public class PortletActionManager
{
    public static final String ACTION_REFERENCE = "org.apache.jetspeed.portletcontainer.util.PortletActionManager.ActionReference";
    public static final String ACTION_REFERENCE_PARAM_CAIID = "org.apache.jetspeed.portletcontainer.util.PortletActionManager.ActionReference.caiid";
    public static final String ACTION_REFERENCE_PARAM_CPIID = "org.apache.jetspeed.portletcontainer.util.PortletActionManager.ActionReference.cpiid";

    public static String storePortletAction(PortletAction action,
                                            PortletInstanceEntry portletInstance,
                                            PortalInformationProvider provider,
                                            PortletSessionImpl session)
    {
        int hashcode = action.hashCode();
        
        String uniqueName = null;
        String actionReference = null;
        Object object = null;
        // generate unqiue Name in session
        do {
            uniqueName = Integer.toString(hashcode);
            actionReference = PortletNamespaceMapper.encode( "ACTION", 
                                                             portletInstance.getPiid().toString(), 
                                                             uniqueName );
            if (object!=null) {
                hashcode += Math.random()*1000;
            }

        } while ( object!=null );

        session.setPrivateAttribute(actionReference, action);

        return uniqueName;
    }

    public static PortletAction getPortletAction(PortletRequest portletRequest)
    {
        String actionReference = (String)portletRequest.getAttribute(ACTION_REFERENCE);
        String caiid = (String)portletRequest.getAttribute(ACTION_REFERENCE_PARAM_CAIID);
        String cpiid = (String)portletRequest.getAttribute(ACTION_REFERENCE_PARAM_CPIID);

        HttpSession httpSession = portletRequest.getSession();

        PortletAction action = null;

        // check for concurrent PortletActions
        synchronized (httpSession)
        {

            PortletSessionImpl portletSession = 
                (PortletSessionImpl)PortletSessionManager.getPortletSession(caiid,
                                                                            httpSession);
            actionReference = PortletNamespaceMapper.encode( "ACTION", 
                                                             cpiid, 
                                                             actionReference );

            action = (PortletAction)portletSession.getPrivateAttribute(actionReference);

            PortletActionManager.clearPortletActions( cpiid, portletSession);
        }

        return action;
    }

    public static void clearPortletActions(PortletInstanceEntry portletInstance, 
                                           PortletSession portletSession)
    {
        clearPortletActions(portletInstance.getPiid().toString(),
                            portletSession);
    }

    public static void clearPortletActions(String cpiid, 
                                           PortletSession portletSession)
    {
        if (portletSession!=null)
        {
            Enumeration attributes = ((PortletSessionImpl)portletSession).getPrivateAttributeNames();
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                if (PortletNamespaceMapper.isInNamespace("ACTION", cpiid, name))
                {
                    // remove the action from session
                    ((PortletSessionImpl)portletSession).removePrivateAttribute(name);
                }
            }
        }
    }

    public static ActionEventImpl getActionEventWithoutPortletAction(
        String actionReference,
        PortletInstanceEntry portletInstance,
        PortletRequest request,
        PortalInformationProvider provider ) throws PortletException
    {
        PortletRequestImpl portletRequest = (PortletRequestImpl)request;
        HttpServletRequest servletRequest = portletRequest.getProxiedHttpServletRequest();
        servletRequest.setAttribute(ACTION_REFERENCE, actionReference);
        servletRequest.setAttribute(ACTION_REFERENCE_PARAM_CAIID,
                                    portletInstance.getApplicationInstance().getAiid().toString());
        servletRequest.setAttribute(ACTION_REFERENCE_PARAM_CPIID,
                                    portletInstance.getPiid().toString());

        // get servlet request attributes and make them available in portlet namespace
        transformServletRequestParameter(portletRequest);

        // create action event
        ActionEventImpl event = new ActionEventImpl( portletInstance,
                                                     request );
        return event;
    }

    private static void transformServletRequestParameter(PortletRequestImpl portletRequest)
    {
        String cpiid = portletRequest.getPortletInstanceEntry().getPiid().toString();
        Map servletParameterMap = portletRequest.getProvider().getParameterMap();
        HashMap newParameters = new HashMap(servletParameterMap);
        Iterator servletParameters = servletParameterMap.keySet().iterator();
        while (servletParameters.hasNext())
        {
            String parameterName = (String)servletParameters.next();
            if (parameterName!=null) {
               if (!PortletNamespaceMapper.isInNamespace(cpiid, parameterName)) {
                    String[] values = (String[])servletParameterMap.get(parameterName);
                    newParameters.put(PortletNamespaceMapper.encode(cpiid,parameterName),values);
               }
            }
        }
        portletRequest.setParameterMap(newParameters);
    }

}
