/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;

/**
 * ContentPageBean
 * 
 * @version $Id: ContentPageBean.java 888487 2009-12-08 17:10:54Z woonsan $
 */
@XmlRootElement(name="page")
public class ContentPageBean implements Serializable
{

    private static final long serialVersionUID = 1L;
    
    private String id;
    private String name;
    private String path;
    private String title;
    private String shortTitle;
    private String url;
    private String skin;
    private ContentFragmentBean rootFragmentBean;
    
    public ContentPageBean()
    {
        
    }
    
    public ContentPageBean(final ContentPage contentPage)
    {
        id = contentPage.getId();
        name = contentPage.getName();
        path = contentPage.getPath();
        title = contentPage.getTitle();
        shortTitle = contentPage.getShortTitle();
        url = contentPage.getUrl();
        skin = contentPage.getSkin();
        
        ContentFragment rootFragment = contentPage.getRootFragment();
        
        if (rootFragment != null)
        {
            rootFragmentBean = new ContentFragmentBean(rootFragment);
        }
    }

    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getPath()
    {
        return path;
    }

    public void setPath(String path)
    {
        this.path = path;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getShortTitle()
    {
        return shortTitle;
    }

    public void setShortTitle(String shortTitle)
    {
        this.shortTitle = shortTitle;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getSkin()
    {
        return skin;
    }

    public void setSkin(String skin)
    {
        this.skin = skin;
    }

    @XmlElement(name="fragment")
    public ContentFragmentBean getContentFragmentBean()
    {
        return rootFragmentBean;
    }

    public void setContentFragmentBean(ContentFragmentBean rootFragmentBean)
    {
        this.rootFragmentBean = rootFragmentBean;
    }
    
}
