/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.XASession;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionDelegate;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.BrokerDetails;
import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.HeartbeatListener;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.failover.FailoverRetrySupport;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateWaiter;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConfirmSelectBody;
import org.apache.qpid.framing.ConfirmSelectOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.jms.ChannelLimitReachedException;
import org.apache.qpid.jms.Session;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.io.IoNetworkTransport;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.SecurityLayerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQConnectionDelegate_8_0
implements AMQConnectionDelegate {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_8_0.class);
    private static final String AMQJ_DEFAULT_SYNCWRITE_TIMEOUT = "amqj.default_syncwrite_timeout";
    private final AMQConnection _conn;
    private final long _timeout = Long.getLong("qpid.sync_op_timeout", Long.getLong("amqj.default_syncwrite_timeout", 60000L));
    private boolean _messageCompressionSupported;
    private boolean _addrSyntaxSupported;
    private boolean _confirmedPublishSupported;
    private boolean _confirmedPublishNonTransactionalSupported;
    private boolean _virtualhostPropertiesSupported;
    private boolean _queueLifetimeSupported;

    @Override
    public void closeConnection(long timeout) throws JMSException, QpidException {
        this._conn.getProtocolHandler().closeConnection(timeout);
    }

    public AMQConnectionDelegate_8_0(AMQConnection conn) {
        this._conn = conn;
        this._addrSyntaxSupported = Boolean.parseBoolean(System.getProperty("qpid.addr_syntax_supported", String.valueOf(true)));
    }

    protected boolean checkException(Throwable thrown) {
        Throwable cause = thrown.getCause();
        if (cause == null) {
            cause = thrown;
        }
        return cause instanceof ConnectException || cause instanceof UnresolvedAddressException;
    }

    public boolean isConfirmedPublishSupported() {
        return this._confirmedPublishSupported;
    }

    @Override
    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws QpidException {
        boolean brokerlistUseSsl;
        boolean connUseSsl;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Connecting to broker:" + brokerDetail);
        }
        EnumSet<AMQState> openOrClosedStates = EnumSet.of(AMQState.CONNECTION_OPEN, AMQState.CONNECTION_CLOSED);
        ConnectionSettings settings = brokerDetail.buildConnectionSettings();
        String connectionSslOption = this._conn.getConnectionURL().getOption("ssl");
        if (connectionSslOption != null && (connUseSsl = Boolean.parseBoolean(connectionSslOption)) != (brokerlistUseSsl = settings.isUseSSL())) {
            settings.setUseSSL(connUseSsl);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Applied connection ssl option override, setting UseSsl to: " + connUseSsl);
            }
        }
        SecurityLayer securityLayer = SecurityLayerFactory.newInstance(settings);
        IoNetworkTransport transport = new IoNetworkTransport();
        ReceiverClosedWaiter monitoringReceiver = new ReceiverClosedWaiter(securityLayer.receiver(this._conn.getProtocolHandler()));
        NetworkConnection network = transport.connect(settings, monitoringReceiver, this._conn.getProtocolHandler());
        try {
            this._conn.getProtocolHandler().setNetworkConnection(network, securityLayer.sender(network.getSender()));
            StateWaiter waiter = this._conn.getProtocolHandler().createWaiter(openOrClosedStates);
            this._conn.getProtocolHandler().init(settings);
            AMQState state = waiter.await();
            if (state == AMQState.CONNECTION_OPEN) {
                this._conn.getFailoverPolicy().attainedConnection();
                this._conn.setConnected(true);
                this._conn.logConnected(network.getLocalAddress(), network.getRemoteAddress());
                this._messageCompressionSupported = this.checkBooleanConnectionStartProperty("qpid.message_compression_supported");
                this._virtualhostPropertiesSupported = this.checkBooleanConnectionStartProperty("qpid.virtualhost_properties_supported");
                this._queueLifetimeSupported = this.checkBooleanConnectionStartProperty("qpid.queue_lifetime_supported");
                this._confirmedPublishSupported = this.checkBooleanConnectionStartProperty("qpid.confirmed_publish_supported");
                this._confirmedPublishNonTransactionalSupported = this.checkConfirmedPublishNonTransactionalSupported();
                this._conn.setConnectionSettings(settings);
                ProtocolVersion protocolVersion = null;
                return protocolVersion;
            }
            ProtocolVersion protocolVersion = this._conn.getProtocolHandler().getSuggestedProtocolVersion();
            return protocolVersion;
        }
        catch (RuntimeException | QpidException e) {
            network.close();
            throw e;
        }
        finally {
            boolean closedWithinTimeout;
            if (!this._conn.isConnected() && !(closedWithinTimeout = monitoringReceiver.awaitClose(this._timeout))) {
                _logger.warn("Timed-out waiting for receiver for connection to " + brokerDetail + " to be closed.");
            }
        }
    }

    private boolean checkConfirmedPublishNonTransactionalSupported() {
        FieldTable serverProperties = this._conn.getProtocolHandler().getProtocolSession().getConnectionStartServerProperties();
        if (serverProperties != null && serverProperties.containsKey("capabilities") && serverProperties.get("capabilities") instanceof FieldTable) {
            FieldTable capabilities = serverProperties.getFieldTable("capabilities");
            return capabilities.containsKey("publisher_confirms") && capabilities.get("publisher_confirms") instanceof Boolean && capabilities.getBoolean("publisher_confirms") != false;
        }
        return false;
    }

    public Session createSession(boolean transacted, int acknowledgeMode, int prefetch) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetch, prefetch);
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        throw new UnsupportedOperationException("0_8 version does not provide XA support");
    }

    @Override
    public XASession createXASession(int ackMode) throws JMSException {
        throw new UnsupportedOperationException("0_8 version does not provide XA support");
    }

    @Override
    public Session createSession(final boolean transacted, final int acknowledgeMode, final int prefetchHigh, final int prefetchLow) throws JMSException {
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        return new FailoverRetrySupport<Session, JMSException>(new FailoverProtectedOperation<Session, JMSException>(){

            @Override
            public Session execute() throws JMSException, FailoverException {
                int channelId = AMQConnectionDelegate_8_0.this._conn.getNextChannelID();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Write channel open frame for channel id " + channelId);
                }
                AMQSession_0_8 session = new AMQSession_0_8(AMQConnectionDelegate_8_0.this._conn, channelId, transacted, acknowledgeMode, prefetchHigh, prefetchLow);
                AMQConnectionDelegate_8_0.this._conn.registerSession(channelId, session);
                boolean success = false;
                try {
                    AMQConnectionDelegate_8_0.this.createChannelOverWire(channelId, transacted);
                    session.setPrefetchLimits(prefetchHigh, 0L);
                    success = true;
                }
                catch (QpidException e) {
                    throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating session: " + e), e);
                }
                finally {
                    if (!success) {
                        AMQConnectionDelegate_8_0.this._conn.deregisterSession(channelId);
                    }
                }
                if (AMQConnectionDelegate_8_0.this._conn.started()) {
                    try {
                        session.start();
                    }
                    catch (QpidException e) {
                        throw JMSExceptionHelper.chainJMSException(new JMSException("Session.start failed"), e);
                    }
                }
                return session;
            }
        }, this._conn).execute();
    }

    @Override
    public XASession createXASession() throws JMSException {
        return this.createXASession((int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
    }

    private void createChannelOverWire(int channelId, boolean transacted) throws QpidException, FailoverException {
        boolean useConfirms;
        ChannelOpenBody channelOpenBody = this._conn.getProtocolHandler().getMethodRegistry().createChannelOpenBody(null);
        this._conn.getProtocolHandler().syncWrite(channelOpenBody.generateFrame(channelId), ChannelOpenOkBody.class);
        if (transacted) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Issuing TxSelect for " + channelId);
            }
            TxSelectBody body = this._conn.getProtocolHandler().getMethodRegistry().createTxSelectBody();
            this._conn.getProtocolHandler().syncWrite(body.generateFrame(channelId), TxSelectOkBody.class);
        }
        boolean bl = useConfirms = (this._confirmedPublishSupported || !transacted && this._confirmedPublishNonTransactionalSupported) && "all".equals(this._conn.getSyncPublish());
        if (useConfirms) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Issuing ConfirmSelect for " + channelId);
            }
            ConfirmSelectBody body = new ConfirmSelectBody(false);
            this._conn.getProtocolHandler().syncWrite(body.generateFrame(channelId), ConfirmSelectOkBody.class);
        }
    }

    @Override
    public void resubscribeSessions() throws JMSException, QpidException, FailoverException {
        List<AMQSession> sessions = this._conn.getSessions().values();
        _logger.debug("Resubscribing sessions = {} sessions.size = {}", sessions, (Object)sessions.size());
        for (AMQSession_0_8 aMQSession_0_8 : sessions) {
            aMQSession_0_8.setFlowControl(true);
            this.reopenChannel(aMQSession_0_8.getChannelId(), aMQSession_0_8.getDefaultPrefetchHigh(), aMQSession_0_8.getDefaultPrefetchLow(), aMQSession_0_8.isTransacted());
            aMQSession_0_8.setPrefetchLimits(aMQSession_0_8.getDefaultPrefetchHigh(), 0L);
            aMQSession_0_8.resubscribe();
        }
    }

    private void reopenChannel(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws QpidException, FailoverException {
        try {
            this.createChannelOverWire(channelId, transacted);
        }
        catch (QpidException e) {
            this._conn.deregisterSession(channelId);
            throw new QpidException("Error reopening channel " + channelId + " after failover: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        while (true) {
            try {
                this._conn.blockUntilNotFailingOver();
            }
            catch (InterruptedException e) {
                _logger.debug("Interrupted: " + e, (Throwable)e);
                Thread.currentThread().interrupt();
                return null;
            }
            Object object = this._conn.getFailoverMutex();
            synchronized (object) {
                block9: {
                    try {
                        return operation.execute();
                    }
                    catch (FailoverException e) {
                        _logger.debug("Failover exception caught during operation: " + e, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (e.getMessage().startsWith("Fail-over interrupted no-op failover support")) break block9;
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public int getMaxChannelID() {
        ConnectionTuneParameters params = this._conn.getProtocolHandler().getProtocolSession().getConnectionTuneParameters();
        return params == null ? 65535 : params.getChannelMax();
    }

    @Override
    public int getMinChannelID() {
        return 1;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v0_8;
    }

    @Override
    public boolean verifyClientID() throws JMSException {
        return true;
    }

    @Override
    public boolean isSupportedServerFeature(String featureName) {
        return "qpid.jms-selector".equals(featureName);
    }

    @Override
    public void setHeartbeatListener(HeartbeatListener listener) {
        this._conn.getProtocolHandler().setHeartbeatListener(listener);
    }

    @Override
    public boolean supportsIsBound() {
        boolean connectedToQpid = true;
        FieldTable serverProperties = this._conn.getProtocolHandler().getProtocolSession().getConnectionStartServerProperties();
        if (serverProperties != null && serverProperties.containsKey("product")) {
            String product = String.valueOf(serverProperties.getString("product")).toLowerCase();
            boolean bl = connectedToQpid = product.contains("qpid") || product.equals("unknown");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("supportsIsBound: " + connectedToQpid);
        }
        return connectedToQpid;
    }

    private boolean checkBooleanConnectionStartProperty(String property) {
        FieldTable serverProperties = this._conn.getProtocolHandler().getProtocolSession().getConnectionStartServerProperties();
        return serverProperties != null && Boolean.parseBoolean(serverProperties.getString(property));
    }

    @Override
    public boolean isMessageCompressionSupported() {
        return this._messageCompressionSupported;
    }

    @Override
    public boolean isVirtualHostPropertiesSupported() {
        return this._virtualhostPropertiesSupported;
    }

    @Override
    public boolean isQueueLifetimePolicySupported() {
        return this._queueLifetimeSupported;
    }

    public boolean isAddrSyntaxSupported() {
        return this._addrSyntaxSupported;
    }

    public boolean isConfirmedPublishNonTransactionalSupported() {
        return this._confirmedPublishNonTransactionalSupported;
    }

    private static class ReceiverClosedWaiter
    implements ExceptionHandlingByteBufferReceiver {
        private final CountDownLatch _closedWatcher;
        private final ExceptionHandlingByteBufferReceiver _receiver;

        public ReceiverClosedWaiter(ExceptionHandlingByteBufferReceiver receiver) {
            this._receiver = receiver;
            this._closedWatcher = new CountDownLatch(1);
        }

        @Override
        public void received(ByteBuffer msg) {
            this._receiver.received(msg);
        }

        @Override
        public void exception(Throwable t) {
            this._receiver.exception(t);
        }

        @Override
        public void closed() {
            try {
                this._receiver.closed();
            }
            finally {
                this._closedWatcher.countDown();
            }
        }

        public boolean awaitClose(long timeout) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Waiting " + timeout + "ms for receiver to be closed");
                }
                return this._closedWatcher.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this._closedWatcher.getCount() == 0L;
            }
        }
    }
}

