/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.message.AMQPEncodedListMessageFactory;
import org.apache.qpid.client.message.AMQPEncodedMapMessageFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.AbstractJMSMessageFactory;
import org.apache.qpid.client.message.Encrypted010MessageFactory;
import org.apache.qpid.client.message.Encrypted091MessageFactory;
import org.apache.qpid.client.message.JMSBytesMessageFactory;
import org.apache.qpid.client.message.JMSMapMessageFactory;
import org.apache.qpid.client.message.JMSObjectMessageFactory;
import org.apache.qpid.client.message.JMSStreamMessageFactory;
import org.apache.qpid.client.message.JMSTextMessageFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactoryRegistry {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AbstractJMSMessageFactory> _mimeStringToFactoryMap = new HashMap<String, AbstractJMSMessageFactory>();
    private final AbstractJMSMessageFactory _default = new JMSBytesMessageFactory();
    private final AMQSession<?, ?> _session;

    public MessageFactoryRegistry(AMQSession<?, ?> session) {
        this._session = session;
    }

    public static MessageFactoryRegistry newDefaultRegistry(AMQSession<?, ?> session) {
        MessageFactoryRegistry mf = new MessageFactoryRegistry(session);
        mf.registerFactory("jms/map-message", new JMSMapMessageFactory());
        mf.registerFactory("text/plain", new JMSTextMessageFactory());
        mf.registerFactory("text/xml", new JMSTextMessageFactory());
        mf.registerFactory("application/octet-stream", new JMSBytesMessageFactory());
        mf.registerFactory("application/java-object-stream", new JMSObjectMessageFactory(session.getAMQConnection()));
        mf.registerFactory("jms/stream-message", new JMSStreamMessageFactory());
        mf.registerFactory("amqp/map", new AMQPEncodedMapMessageFactory());
        mf.registerFactory("amqp/list", new AMQPEncodedListMessageFactory());
        mf.registerFactory("application/qpid-0-9-1-encrypted", new Encrypted091MessageFactory(mf));
        mf.registerFactory("application/qpid-0-10-encrypted", new Encrypted010MessageFactory(mf));
        mf.registerFactory(null, mf._default);
        return mf;
    }

    public void registerFactory(String mimeType, AbstractJMSMessageFactory mf) {
        this._mimeStringToFactoryMap.put(mimeType, mf);
    }

    public AbstractJMSMessage createMessage(long deliveryTag, boolean redelivered, String exchange, String routingKey, ContentHeaderBody contentHeader, List bodies, AMQSession_0_8.DestinationCache<AMQQueue> queueDestinationCache, AMQSession_0_8.DestinationCache<AMQTopic> topicDestinationCache, int addressType) throws QpidException, JMSException {
        BasicContentHeaderProperties properties = contentHeader.getProperties();
        AMQShortString contentTypeShortString = properties.getContentType();
        contentTypeShortString = contentTypeShortString == null ? new AMQShortString("application/octet-stream") : contentTypeShortString;
        AbstractJMSMessageFactory mf = this.getMessageFactory(AMQShortString.toString(contentTypeShortString));
        return mf.createMessage(deliveryTag, redelivered, contentHeader, exchange, routingKey, bodies, queueDestinationCache, topicDestinationCache, addressType);
    }

    AbstractJMSMessageFactory getMessageFactory(String contentTypeShortString) {
        AbstractJMSMessageFactory mf = this._mimeStringToFactoryMap.get(contentTypeShortString);
        if (mf == null) {
            mf = this._default;
        }
        return mf;
    }

    public AbstractJMSMessage createMessage(MessageTransfer transfer) throws QpidException, JMSException {
        MessageProperties mprop = transfer.getHeader().getMessageProperties();
        String messageType = "";
        if (mprop == null || mprop.getContentType() == null) {
            this._logger.debug("no message type specified, building a byte message");
            messageType = "application/octet-stream";
        } else {
            messageType = mprop.getContentType();
        }
        AbstractJMSMessageFactory mf = this.getMessageFactory(messageType);
        boolean redelivered = false;
        DeliveryProperties deliverProps = transfer.getHeader().getDeliveryProperties();
        if (deliverProps != null) {
            redelivered = deliverProps.getRedelivered();
        }
        return mf.createMessage(transfer.getId(), redelivered, mprop == null ? new MessageProperties() : mprop, deliverProps == null ? new DeliveryProperties() : deliverProps, transfer.getBody());
    }

    public AMQSession<?, ?> getSession() {
        return this._session;
    }

    AbstractJMSMessageFactory getDefaultFactory() {
        return this._default;
    }
}

