/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerMethodProcessor;
import org.apache.qpid.util.ByteBufferUtils;

public class ConnectionTuneOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 31;
    private final int _channelMax;
    private final long _frameMax;
    private final int _heartbeat;

    public ConnectionTuneOkBody(int channelMax, long frameMax, int heartbeat) {
        this._channelMax = channelMax;
        this._frameMax = frameMax;
        this._heartbeat = heartbeat;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 31;
    }

    public final int getChannelMax() {
        return this._channelMax;
    }

    public final long getFrameMax() {
        return this._frameMax;
    }

    public final int getHeartbeat() {
        return this._heartbeat;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._channelMax);
        this.writeUnsignedInteger(buffer, this._frameMax);
        this.writeUnsignedShort(buffer, this._heartbeat);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionTuneOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionTuneOkBodyImpl: ");
        buf.append("channelMax=");
        buf.append(this.getChannelMax());
        buf.append(", ");
        buf.append("frameMax=");
        buf.append(this.getFrameMax());
        buf.append(", ");
        buf.append("heartbeat=");
        buf.append(this.getHeartbeat());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ServerMethodProcessor dispatcher) {
        int channelMax = ByteBufferUtils.getUnsignedShort(buffer);
        long frameMax = ByteBufferUtils.getUnsignedInt(buffer);
        int heartbeat = ByteBufferUtils.getUnsignedShort(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionTuneOk(channelMax, frameMax, heartbeat);
        }
    }
}

