/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.client.AMQSession;

public final class ChannelToSessionMap {
    private final Map<Integer, AMQSession> _sessionMap = Collections.synchronizedMap(new LinkedHashMap());
    private AtomicInteger _idFactory = new AtomicInteger(0);
    private int _maxChannelID;
    private int _minChannelID;

    public AMQSession get(int channelId) {
        return this._sessionMap.get(channelId);
    }

    public void put(int channelId, AMQSession session) {
        this._sessionMap.put(channelId, session);
    }

    public void remove(int channelId) {
        this._sessionMap.remove(channelId);
    }

    public List<AMQSession> values() {
        return new ArrayList<AMQSession>(this._sessionMap.values());
    }

    public int size() {
        return this._sessionMap.size();
    }

    public void clear() {
        this._sessionMap.clear();
    }

    public synchronized int getNextChannelId() {
        int id = this._minChannelID;
        boolean done = false;
        while (!done) {
            id = this._idFactory.getAndIncrement();
            if (id == this._maxChannelID) {
                this._idFactory.set(this._minChannelID);
            }
            done = !this._sessionMap.keySet().contains(id);
        }
        return id;
    }

    public void setMaxChannelID(int maxChannelID) {
        this._maxChannelID = maxChannelID;
    }

    public void setMinChannelID(int minChannelID) {
        this._minChannelID = minChannelID;
        this._idFactory.set(this._minChannelID);
    }
}

