/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.message.UnprocessedMessage_0_8;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicDeliverBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDeliverMethodHandler
implements StateAwareMethodListener<BasicDeliverBody> {
    private static final Logger _logger = LoggerFactory.getLogger(BasicDeliverMethodHandler.class);
    private static final ConcurrentMap<AMQShortString, String> CONSUMER_TAG_MAP = new ConcurrentHashMap<AMQShortString, String>();
    private static final BasicDeliverMethodHandler _instance = new BasicDeliverMethodHandler();

    public static BasicDeliverMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQProtocolSession session, BasicDeliverBody body, int channelId) throws QpidException {
        UnprocessedMessage_0_8 msg = new UnprocessedMessage_0_8(body.getDeliveryTag(), BasicDeliverMethodHandler.getTagAsStringTag(body), body.getExchange(), body.getRoutingKey(), body.getRedelivered());
        if (_logger.isDebugEnabled()) {
            _logger.debug("New JmsDeliver method received:" + session);
        }
        session.unprocessedMessageReceived(channelId, msg);
    }

    private static String getTagAsStringTag(BasicDeliverBody body) {
        AMQShortString consumerTag = body.getConsumerTag();
        String tag = (String)CONSUMER_TAG_MAP.get(consumerTag);
        if (tag == null) {
            tag = consumerTag.toString();
            CONSUMER_TAG_MAP.putIfAbsent(consumerTag, tag);
        }
        return tag;
    }
}

