/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty5;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.buffer.Buffer;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpClientCodec;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketVersion;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.SslOptions;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.apache.qpid.protonj2.client.transport.netty5.TcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends TcpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketTransport.class);
    private static final String AMQP_SUB_PROTOCOL = "amqp";
    private Future<Void> handshakeTimeoutFuture;

    public WebSocketTransport(Bootstrap bootstrap, TransportOptions options, SslOptions sslOptions) {
        super(bootstrap, options, sslOptions);
    }

    @Override
    public URI getRemoteURI() {
        if (this.host != null) {
            try {
                return new URI(this.getScheme(), null, this.host, this.port, this.options.webSocketPath(), null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected ChannelHandler createChannelHandler() {
        return new NettyWebSocketTransportHandler();
    }

    @Override
    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
    }

    @Override
    protected void handleConnected(Channel channel) throws Exception {
        LOG.trace("Channel has become active, awaiting WebSocket handshake! Channel is {}", (Object)channel);
    }

    @Override
    protected String getScheme() {
        return this.isSecure() ? "wss" : "ws";
    }

    private class NettyWebSocketTransportHandler
    extends TcpTransport.NettyDefaultHandler<Object>
    implements ChannelHandler {
        private final WebSocketClientHandshaker handshaker;

        public NettyWebSocketTransportHandler() {
            HttpHeaders headers = HttpHeaders.newHeaders();
            WebSocketTransport.this.options.webSocketHeaders().forEach((key, value) -> headers.set((CharSequence)key, (CharSequence)value));
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)WebSocketTransport.this.getRemoteURI(), (WebSocketVersion)WebSocketVersion.V13, (String)WebSocketTransport.AMQP_SUB_PROTOCOL, (boolean)true, (HttpHeaders)headers, (int)WebSocketTransport.this.options.webSocketMaxFrameSize());
        }

        @Override
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            if (WebSocketTransport.this.handshakeTimeoutFuture != null) {
                WebSocketTransport.this.handshakeTimeoutFuture.cancel();
            }
            super.channelInactive(context);
        }

        @Override
        public void channelActive(final ChannelHandlerContext context) throws Exception {
            this.handshaker.handshake(context.channel()).addListener((FutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<? extends Void> future) throws Exception {
                    if (future.isSuccess()) {
                        context.pipeline().addLast(new ChannelHandler[]{new OutputBufferToBinaryFrameHandler()});
                    }
                }
            });
            WebSocketTransport.this.handshakeTimeoutFuture = context.executor().schedule(() -> {
                LOG.trace("WebSocket handshake timed out! Channel is {}", (Object)context.channel());
                if (!this.handshaker.isHandshakeComplete()) {
                    WebSocketTransport.super.handleTransportFailure(WebSocketTransport.this.channel, new IOException("WebSocket handshake timed out"));
                }
            }, (long)WebSocketTransport.this.getTransportOptions().connectTimeout(), TimeUnit.MILLISECONDS);
            super.channelActive(context);
        }

        protected void messageReceived(ChannelHandlerContext ctx, Object message) throws Exception {
            LOG.trace("New data read: incoming: {}", message);
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)message);
                LOG.trace("WebSocket Client connected! {}", (Object)ctx.channel());
                if (WebSocketTransport.this.handshakeTimeoutFuture.cancel()) {
                    WebSocketTransport.super.handleConnected(ch);
                }
                return;
            }
            if (message instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)message;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.payload().toString(StandardCharsets.UTF_8) + ")");
            }
            WebSocketFrame frame = (WebSocketFrame)message;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                LOG.warn("WebSocket Client received message: {}", (Object)textFrame.text());
                ctx.fireChannelExceptionCaught((Throwable)new IOException("Received invalid frame over WebSocket."));
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
                LOG.trace("WebSocket Client received data: {} bytes", (Object)binaryFrame.binaryData().readableBytes());
                this.dispatchReadBuffer(binaryFrame.binaryData());
            } else if (frame instanceof ContinuationWebSocketFrame) {
                ContinuationWebSocketFrame continuationFrame = (ContinuationWebSocketFrame)frame;
                LOG.trace("WebSocket Client received data continuation: {} bytes", (Object)continuationFrame.binaryData().readableBytes());
                this.dispatchReadBuffer(continuationFrame.binaryData());
            } else if (frame instanceof PingWebSocketFrame) {
                LOG.trace("WebSocket Client received ping, response with pong");
                ch.write((Object)new PongWebSocketFrame(frame.binaryData()));
            } else if (frame instanceof CloseWebSocketFrame) {
                LOG.trace("WebSocket Client received closing");
                ch.close();
            }
        }
    }

    private class OutputBufferToBinaryFrameHandler
    extends ChannelHandlerAdapter {
        private OutputBufferToBinaryFrameHandler() {
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            return ctx.write((Object)new BinaryWebSocketFrame((Buffer)msg));
        }
    }
}

