/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.PoolCreateHeaders;
import com.microsoft.azure.management.batch.PoolDeleteHeaders;
import com.microsoft.azure.management.batch.PoolDisableAutoScaleHeaders;
import com.microsoft.azure.management.batch.PoolGetHeaders;
import com.microsoft.azure.management.batch.PoolStopResizeHeaders;
import com.microsoft.azure.management.batch.PoolUpdateHeaders;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.azure.management.batch.implementation.PoolInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PoolsInner {
    private PoolsService service;
    private BatchManagementClientImpl client;

    public PoolsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (PoolsService)retrofit.create(PoolsService.class);
        this.client = client;
    }

    public PagedList<PoolInner> listByBatchAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PoolInner>((Page)response.body()){

            public Page<PoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PoolInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                return PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PoolInner>> listByBatchAccountAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>(){

            public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String select = null;
        String filter = null;
        return this.service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PoolsInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PoolInner> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).toBlocking().single();
        return new PagedList<PoolInner>((Page)response.body()){

            public Page<PoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PoolInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter, ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                return PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PoolInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults, select, filter).map((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>(){

            public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).concatMap((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PoolsInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PoolInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PoolInner create(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters), serviceCallback);
    }

    public Observable<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        String ifNoneMatch = null;
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PoolInner>(){}.getType(), PoolCreateHeaders.class);
    }

    public PoolInner create(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).toBlocking().last()).body());
    }

    public ServiceFuture<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    public Observable<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PoolInner>(){}.getType(), PoolCreateHeaders.class);
    }

    public PoolInner beginCreate(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters), serviceCallback);
    }

    public Observable<PoolInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.service.beginCreate(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PoolInner beginCreate(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    public Observable<PoolInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreate(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PoolInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolCreateHeaders.class);
    }

    public PoolInner update(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters), serviceCallback);
    }

    public Observable<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        return this.service.update(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PoolInner update(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch), serviceCallback);
    }

    public Observable<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.update(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PoolInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolUpdateHeaders.class);
    }

    public void delete(String resourceGroupName, String accountName, String poolName) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String poolName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new TypeToken<Void>(){}.getType(), PoolDeleteHeaders.class);
    }

    public void beginDelete(String resourceGroupName, String accountName, String poolName) {
        ((ServiceResponseWithHeaders)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolDeleteHeaders> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolDeleteHeaders.class);
    }

    public PoolInner get(String resourceGroupName, String accountName, String poolName) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> getAsync(String resourceGroupName, String accountName, String poolName, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    public Observable<PoolInner> getAsync(String resourceGroupName, String accountName, String poolName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, poolName).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolGetHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolGetHeaders> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PoolInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolGetHeaders.class);
    }

    public PoolInner disableAutoScale(String resourceGroupName, String accountName, String poolName) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> disableAutoScaleAsync(String resourceGroupName, String accountName, String poolName, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    public Observable<PoolInner> disableAutoScaleAsync(String resourceGroupName, String accountName, String poolName) {
        return this.disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>> disableAutoScaleWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableAutoScale(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.disableAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders> disableAutoScaleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PoolInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolDisableAutoScaleHeaders.class);
    }

    public PoolInner stopResize(String resourceGroupName, String accountName, String poolName) {
        return (PoolInner)((Object)((ServiceResponseWithHeaders)this.stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single()).body());
    }

    public ServiceFuture<PoolInner> stopResizeAsync(String resourceGroupName, String accountName, String poolName, ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    public Observable<PoolInner> stopResizeAsync(String resourceGroupName, String accountName, String poolName) {
        return this.stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName).map((Func1)new Func1<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>, PoolInner>(){

            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders> response) {
                return (PoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>> stopResizeWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.stopResize(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsInner.this.stopResizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders> stopResizeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PoolInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PoolStopResizeHeaders.class);
    }

    public PagedList<PoolInner> listByBatchAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PoolInner>((Page)response.body()){

            public Page<PoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PoolInner>> listByBatchAccountNextAsync(String nextPageLink, ServiceFuture<List<PoolInner>> serviceFuture, ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                return PoolsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PoolInner>> listByBatchAccountNextAsync(String nextPageLink) {
        return this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>(){

            public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByBatchAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>(){

            public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PoolsInner.this.listByBatchAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PoolInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PoolsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools listByBatchAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools")
        public Observable<Response<ResponseBody>> listByBatchAccount(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="maxresults") Integer var4, @Query(value="$select") String var5, @Query(value="$filter") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Body PoolInner var5, @Header(value="If-Match") String var6, @Header(value="If-None-Match") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Body PoolInner var5, @Header(value="If-Match") String var6, @Header(value="If-None-Match") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Body PoolInner var5, @Header(value="If-Match") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools disableAutoScale"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/disableAutoScale")
        public Observable<Response<ResponseBody>> disableAutoScale(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools stopResize"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/stopResize")
        public Observable<Response<ResponseBody>> stopResize(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="poolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools listByBatchAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

