/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Node<DataT, NodeT extends Node<DataT, NodeT>> {
    private Graph<DataT, NodeT> ownerGraph;
    private final String key;
    private final DataT data;
    private List<String> children;

    public Node(String key, DataT data) {
        this.key = key;
        this.data = data;
        this.children = new ArrayList<String>();
    }

    public String key() {
        return this.key;
    }

    public DataT data() {
        return this.data;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<String> children() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(String childKey) {
        this.children.add(childKey);
    }

    public void removeChild(String childKey) {
        this.children.remove(childKey);
    }

    public void setOwner(Graph<DataT, NodeT> ownerGraph) {
        if (this.ownerGraph != null) {
            throw new RuntimeException("Changing owner graph is not allowed");
        }
        this.ownerGraph = ownerGraph;
    }

    public Graph<DataT, NodeT> owner() {
        if (this.ownerGraph == null) {
            throw new RuntimeException("Required owner graph is not set");
        }
        return this.ownerGraph;
    }
}

