/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.SecurityRuleAccess;
import com.microsoft.azure.management.network.SecurityRuleDirection;
import com.microsoft.azure.management.network.SecurityRuleProtocol;
import com.microsoft.azure.management.network.implementation.SecurityRuleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import java.util.List;
import java.util.Set;

@Fluent
public interface NetworkSecurityRule
extends HasInner<SecurityRuleInner>,
ChildResource<NetworkSecurityGroup> {
    public SecurityRuleDirection direction();

    public SecurityRuleProtocol protocol();

    public String description();

    public SecurityRuleAccess access();

    public String sourceAddressPrefix();

    public List<String> sourceAddressPrefixes();

    public String sourcePortRange();

    public List<String> sourcePortRanges();

    public String destinationAddressPrefix();

    public List<String> destinationAddressPrefixes();

    public String destinationPortRange();

    public List<String> destinationPortRanges();

    public int priority();

    public Set<String> sourceApplicationSecurityGroupIds();

    public Set<String> destinationApplicationSecurityGroupIds();

    public static interface UpdateStages {

        public static interface WithProtocol {
            public Update withProtocol(SecurityRuleProtocol var1);

            public Update withAnyProtocol();
        }

        public static interface WithDestinationPort {
            public Update toPort(int var1);

            @Method
            public Update toAnyPort();

            public Update toPortRange(int var1, int var2);

            public Update toPortRanges(String ... var1);
        }

        public static interface WithDestinationAddressOrSecurityGroup {
            public Update toAddress(String var1);

            @Method
            public Update toAnyAddress();

            @Method
            public Update toAddresses(String ... var1);

            public Update withDestinationApplicationSecurityGroup(String var1);
        }

        public static interface WithSourcePort {
            public Update fromPort(int var1);

            @Method
            public Update fromAnyPort();

            public Update fromPortRange(int var1, int var2);

            public Update fromPortRanges(String ... var1);
        }

        public static interface WithSourceAddressOrSecurityGroup {
            @Method
            public Update fromAddress(String var1);

            public Update fromAddresses(String ... var1);

            @Method
            public Update fromAnyAddress();

            public Update withSourceApplicationSecurityGroup(String var1);
        }

        public static interface WithDirectionAccess {
            @Method
            public Update allowInbound();

            @Method
            public Update allowOutbound();

            @Method
            public Update denyInbound();

            @Method
            public Update denyOutbound();
        }
    }

    public static interface Update
    extends UpdateStages.WithDirectionAccess,
    UpdateStages.WithSourceAddressOrSecurityGroup,
    UpdateStages.WithSourcePort,
    UpdateStages.WithDestinationAddressOrSecurityGroup,
    UpdateStages.WithDestinationPort,
    UpdateStages.WithProtocol,
    Settable<NetworkSecurityGroup.Update> {
        public Update withPriority(int var1);

        public Update withDescription(String var1);
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InUpdate<ParentT> {
            public WithAttach<ParentT> withPriority(int var1);

            public WithAttach<ParentT> withDescription(String var1);
        }

        public static interface WithProtocol<ParentT> {
            public WithAttach<ParentT> withProtocol(SecurityRuleProtocol var1);

            public WithAttach<ParentT> withAnyProtocol();
        }

        public static interface WithDestinationPort<ParentT> {
            public WithProtocol<ParentT> toPort(int var1);

            @Method
            public WithProtocol<ParentT> toAnyPort();

            public WithProtocol<ParentT> toPortRange(int var1, int var2);

            public WithProtocol<ParentT> toPortRanges(String ... var1);
        }

        public static interface WithDestinationAddressOrSecurityGroup<ParentT> {
            public WithDestinationPort<ParentT> toAddress(String var1);

            @Method
            public WithDestinationPort<ParentT> toAddresses(String ... var1);

            @Method
            public WithDestinationPort<ParentT> toAnyAddress();

            public WithDestinationPort<ParentT> withDestinationApplicationSecurityGroup(String var1);
        }

        public static interface WithSourcePort<ParentT> {
            public WithDestinationAddressOrSecurityGroup<ParentT> fromPort(int var1);

            @Method
            public WithDestinationAddressOrSecurityGroup<ParentT> fromAnyPort();

            public WithDestinationAddressOrSecurityGroup<ParentT> fromPortRange(int var1, int var2);

            public WithDestinationAddressOrSecurityGroup<ParentT> fromPortRanges(String ... var1);
        }

        public static interface WithSourceAddressOrSecurityGroup<ParentT> {
            @Method
            public WithSourcePort<ParentT> fromAddress(String var1);

            public WithSourcePort<ParentT> fromAddresses(String ... var1);

            @Method
            public WithSourcePort<ParentT> fromAnyAddress();

            public WithSourcePort<ParentT> withSourceApplicationSecurityGroup(String var1);
        }

        public static interface WithDirectionAccess<ParentT> {
            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> allowInbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> allowOutbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> denyInbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> denyOutbound();
        }

        public static interface Blank<ParentT>
        extends WithDirectionAccess<ParentT> {
        }
    }

    public static interface UpdateDefinition<ParentT>
    extends UpdateDefinitionStages.Blank<ParentT>,
    UpdateDefinitionStages.WithDirectionAccess<ParentT>,
    UpdateDefinitionStages.WithSourceAddressOrSecurityGroup<ParentT>,
    UpdateDefinitionStages.WithSourcePort<ParentT>,
    UpdateDefinitionStages.WithDestinationAddressOrSecurityGroup<ParentT>,
    UpdateDefinitionStages.WithDestinationPort<ParentT>,
    UpdateDefinitionStages.WithProtocol<ParentT>,
    UpdateDefinitionStages.WithAttach<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InDefinition<ParentT>,
        WithPriority<ParentT>,
        WithDescription<ParentT> {
        }

        public static interface WithDescription<ParentT> {
            public WithAttach<ParentT> withDescription(String var1);
        }

        public static interface WithPriority<ParentT> {
            public WithAttach<ParentT> withPriority(int var1);
        }

        public static interface WithDirectionAccess<ParentT> {
            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> allowInbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> allowOutbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> denyInbound();

            @Method
            public WithSourceAddressOrSecurityGroup<ParentT> denyOutbound();
        }

        public static interface WithSourceAddressOrSecurityGroup<ParentT> {
            @Method
            public WithSourcePort<ParentT> fromAddress(String var1);

            @Method
            public WithSourcePort<ParentT> fromAnyAddress();

            @Method
            public WithSourcePort<ParentT> fromAddresses(String ... var1);

            public WithSourcePort<ParentT> withSourceApplicationSecurityGroup(String var1);
        }

        public static interface WithSourcePort<ParentT> {
            public WithDestinationAddressOrSecurityGroup<ParentT> fromPort(int var1);

            @Method
            public WithDestinationAddressOrSecurityGroup<ParentT> fromAnyPort();

            public WithDestinationAddressOrSecurityGroup<ParentT> fromPortRange(int var1, int var2);

            public WithDestinationAddressOrSecurityGroup<ParentT> fromPortRanges(String ... var1);
        }

        public static interface WithDestinationAddressOrSecurityGroup<ParentT> {
            public WithDestinationPort<ParentT> toAddress(String var1);

            public WithDestinationPort<ParentT> toAddresses(String ... var1);

            @Method
            public WithDestinationPort<ParentT> toAnyAddress();

            public WithDestinationPort<ParentT> withDestinationApplicationSecurityGroup(String var1);
        }

        public static interface WithDestinationPort<ParentT> {
            public WithProtocol<ParentT> toPort(int var1);

            @Method
            public WithProtocol<ParentT> toAnyPort();

            public WithProtocol<ParentT> toPortRange(int var1, int var2);

            public WithProtocol<ParentT> toPortRanges(String ... var1);
        }

        public static interface WithProtocol<ParentT> {
            public WithAttach<ParentT> withProtocol(SecurityRuleProtocol var1);

            public WithAttach<ParentT> withAnyProtocol();
        }

        public static interface Blank<ParentT>
        extends WithDirectionAccess<ParentT> {
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithAttach<ParentT>,
    DefinitionStages.WithDirectionAccess<ParentT>,
    DefinitionStages.WithSourceAddressOrSecurityGroup<ParentT>,
    DefinitionStages.WithSourcePort<ParentT>,
    DefinitionStages.WithDestinationAddressOrSecurityGroup<ParentT>,
    DefinitionStages.WithDestinationPort<ParentT>,
    DefinitionStages.WithProtocol<ParentT> {
    }
}

