/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.implementation.AuthorizationManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RoleDefinitionsInner
implements InnerSupportsDelete<RoleDefinitionInner> {
    private RoleDefinitionsService service;
    private AuthorizationManagementClientImpl client;

    public RoleDefinitionsInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = (RoleDefinitionsService)retrofit.create(RoleDefinitionsService.class);
        this.client = client;
    }

    public RoleDefinitionInner delete(String scope, String roleDefinitionId) {
        return (RoleDefinitionInner)((ServiceResponse)this.deleteWithServiceResponseAsync(scope, roleDefinitionId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleDefinitionInner> deleteAsync(String scope, String roleDefinitionId, ServiceCallback<RoleDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(scope, roleDefinitionId), serviceCallback);
    }

    public Observable<RoleDefinitionInner> deleteAsync(String scope, String roleDefinitionId) {
        return this.deleteWithServiceResponseAsync(scope, roleDefinitionId).map((Func1)new Func1<ServiceResponse<RoleDefinitionInner>, RoleDefinitionInner>(){

            public RoleDefinitionInner call(ServiceResponse<RoleDefinitionInner> response) {
                return (RoleDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleDefinitionInner>> deleteWithServiceResponseAsync(String scope, String roleDefinitionId) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleDefinitionId == null) {
            throw new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null.");
        }
        String apiVersion = "2018-01-01-preview";
        return this.service.delete(scope, roleDefinitionId, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleDefinitionInner>>>(){

            public Observable<ServiceResponse<RoleDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleDefinitionsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleDefinitionInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleDefinitionInner get(String scope, String roleDefinitionId) {
        return (RoleDefinitionInner)((ServiceResponse)this.getWithServiceResponseAsync(scope, roleDefinitionId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleDefinitionInner> getAsync(String scope, String roleDefinitionId, ServiceCallback<RoleDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(scope, roleDefinitionId), serviceCallback);
    }

    public Observable<RoleDefinitionInner> getAsync(String scope, String roleDefinitionId) {
        return this.getWithServiceResponseAsync(scope, roleDefinitionId).map((Func1)new Func1<ServiceResponse<RoleDefinitionInner>, RoleDefinitionInner>(){

            public RoleDefinitionInner call(ServiceResponse<RoleDefinitionInner> response) {
                return (RoleDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleDefinitionInner>> getWithServiceResponseAsync(String scope, String roleDefinitionId) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleDefinitionId == null) {
            throw new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null.");
        }
        String apiVersion = "2018-01-01-preview";
        return this.service.get(scope, roleDefinitionId, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleDefinitionInner>>>(){

            public Observable<ServiceResponse<RoleDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleDefinitionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleDefinitionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleDefinitionInner createOrUpdate(String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        return (RoleDefinitionInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(scope, roleDefinitionId, roleDefinition).toBlocking().single()).body();
    }

    public ServiceFuture<RoleDefinitionInner> createOrUpdateAsync(String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition, ServiceCallback<RoleDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(scope, roleDefinitionId, roleDefinition), serviceCallback);
    }

    public Observable<RoleDefinitionInner> createOrUpdateAsync(String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        return this.createOrUpdateWithServiceResponseAsync(scope, roleDefinitionId, roleDefinition).map((Func1)new Func1<ServiceResponse<RoleDefinitionInner>, RoleDefinitionInner>(){

            public RoleDefinitionInner call(ServiceResponse<RoleDefinitionInner> response) {
                return (RoleDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleDefinitionInner>> createOrUpdateWithServiceResponseAsync(String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleDefinitionId == null) {
            throw new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null.");
        }
        if (roleDefinition == null) {
            throw new IllegalArgumentException("Parameter roleDefinition is required and cannot be null.");
        }
        Validator.validate((Object)roleDefinition);
        String apiVersion = "2018-01-01-preview";
        return this.service.createOrUpdate(scope, roleDefinitionId, roleDefinition, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleDefinitionInner>>>(){

            public Observable<ServiceResponse<RoleDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleDefinitionsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleDefinitionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RoleDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleDefinitionInner> list(String scope) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(scope).toBlocking().single();
        return new PagedList<RoleDefinitionInner>((Page)response.body()){

            public Page<RoleDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleDefinitionInner>> listAsync(String scope, ListOperationCallback<RoleDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(scope), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(String nextPageLink) {
                return RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleDefinitionInner>> listAsync(String scope) {
        return this.listWithServiceResponseAsync(scope).map((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Page<RoleDefinitionInner>>(){

            public Page<RoleDefinitionInner> call(ServiceResponse<Page<RoleDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listWithServiceResponseAsync(String scope) {
        return this.listSinglePageAsync(scope).concatMap((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(ServiceResponse<Page<RoleDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listSinglePageAsync(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        String apiVersion = "2018-01-01-preview";
        String filter = null;
        return this.service.list(scope, filter, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RoleDefinitionInner> list(String scope, String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(scope, filter).toBlocking().single();
        return new PagedList<RoleDefinitionInner>((Page)response.body()){

            public Page<RoleDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleDefinitionInner>> listAsync(String scope, String filter, ListOperationCallback<RoleDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(scope, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(String nextPageLink) {
                return RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleDefinitionInner>> listAsync(String scope, String filter) {
        return this.listWithServiceResponseAsync(scope, filter).map((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Page<RoleDefinitionInner>>(){

            public Page<RoleDefinitionInner> call(ServiceResponse<Page<RoleDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listWithServiceResponseAsync(String scope, String filter) {
        return this.listSinglePageAsync(scope, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(ServiceResponse<Page<RoleDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listSinglePageAsync(String scope, String filter) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        String apiVersion = "2018-01-01-preview";
        return this.service.list(scope, filter, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleDefinitionInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleDefinitionInner getById(String roleId) {
        return (RoleDefinitionInner)((ServiceResponse)this.getByIdWithServiceResponseAsync(roleId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleDefinitionInner> getByIdAsync(String roleId, ServiceCallback<RoleDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByIdWithServiceResponseAsync(roleId), serviceCallback);
    }

    public Observable<RoleDefinitionInner> getByIdAsync(String roleId) {
        return this.getByIdWithServiceResponseAsync(roleId).map((Func1)new Func1<ServiceResponse<RoleDefinitionInner>, RoleDefinitionInner>(){

            public RoleDefinitionInner call(ServiceResponse<RoleDefinitionInner> response) {
                return (RoleDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleDefinitionInner>> getByIdWithServiceResponseAsync(String roleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("Parameter roleId is required and cannot be null.");
        }
        String apiVersion = "2018-01-01-preview";
        return this.service.getById(roleId, "2018-01-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleDefinitionInner>>>(){

            public Observable<ServiceResponse<RoleDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleDefinitionsInner.this.getByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleDefinitionInner> getByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleDefinitionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleDefinitionInner>((Page)response.body()){

            public Page<RoleDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleDefinitionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RoleDefinitionInner>> serviceFuture, ListOperationCallback<RoleDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(String nextPageLink) {
                return RoleDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleDefinitionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Page<RoleDefinitionInner>>(){

            public Page<RoleDefinitionInner> call(ServiceResponse<Page<RoleDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RoleDefinitionInner>>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(ServiceResponse<Page<RoleDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleDefinitionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<RoleDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleDefinitionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleDefinitionInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RoleDefinitionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions delete"})
        @HTTP(path="{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="scope", encoded=true) String var1, @Path(value="roleDefinitionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions get"})
        @GET(value="{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}")
        public Observable<Response<ResponseBody>> get(@Path(value="scope", encoded=true) String var1, @Path(value="roleDefinitionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions createOrUpdate"})
        @PUT(value="{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="scope", encoded=true) String var1, @Path(value="roleDefinitionId") String var2, @Body RoleDefinitionInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions list"})
        @GET(value="{scope}/providers/Microsoft.Authorization/roleDefinitions")
        public Observable<Response<ResponseBody>> list(@Path(value="scope", encoded=true) String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions getById"})
        @GET(value="{roleId}")
        public Observable<Response<ResponseBody>> getById(@Path(value="roleId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleDefinitions listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

