/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByNameAsync;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsDeletingByName;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsListing;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

abstract class ServiceBusChildResourcesImpl<T extends IndependentChildResource<ManagerT, InnerT>, ImplT extends T, InnerT, InnerCollectionT, ManagerT extends ManagerBase, ParentT extends Resource & HasResourceGroup>
extends IndependentChildResourcesImpl<T, ImplT, InnerT, InnerCollectionT, ManagerT, ParentT>
implements SupportsGettingByNameAsync<T>,
SupportsListing<T>,
SupportsDeletingByName {
    protected ServiceBusChildResourcesImpl(InnerCollectionT innerCollection, ManagerT manager) {
        super(innerCollection, manager);
    }

    public Observable<T> getByNameAsync(String name) {
        return this.getInnerByNameAsync(name).map(new Func1<InnerT, T>(){

            public T call(InnerT inner) {
                return (IndependentChildResource)ServiceBusChildResourcesImpl.this.wrapModel(inner);
            }
        });
    }

    public T getByName(String name) {
        return (T)((IndependentChildResource)this.getByNameAsync(name).toBlocking().last());
    }

    public Observable<T> listAsync() {
        return this.listInnerAsync().flatMap(new Func1<ServiceResponse<Page<InnerT>>, Observable<T>>(){

            public Observable<T> call(ServiceResponse<Page<InnerT>> r) {
                return Observable.from((Iterable)((Page)r.body()).items()).map(new Func1<InnerT, T>(){

                    public T call(InnerT inner) {
                        return (IndependentChildResource)ServiceBusChildResourcesImpl.this.wrapModel(inner);
                    }
                });
            }
        });
    }

    public PagedList<T> list() {
        return this.wrapList(this.listInner());
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public Observable<String> deleteByNameAsync(List<String> names) {
        ArrayList<Observable> items = new ArrayList<Observable>();
        for (final String name : names) {
            items.add(this.deleteByNameAsync(name).toObservable().map((Func1)new Func1<String, String>(){

                public String call(String s) {
                    return name;
                }
            }));
        }
        return Observable.mergeDelayError(items);
    }

    protected abstract Observable<InnerT> getInnerByNameAsync(String var1);

    protected abstract Observable<ServiceResponse<Page<InnerT>>> listInnerAsync();

    protected abstract PagedList<InnerT> listInner();
}

