/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import retrofit2.Response;

public final class AzureResponseBuilder<T, E extends RestException>
implements ResponseBuilder<T, E> {
    private ServiceResponseBuilder<T, E> baseBuilder;

    private AzureResponseBuilder(SerializerAdapter<?> serializer) {
        this.baseBuilder = new ServiceResponseBuilder.Factory().newInstance(serializer);
    }

    public ResponseBuilder<T, E> register(int statusCode, Type type) {
        this.baseBuilder.register(statusCode, type);
        return this;
    }

    public ResponseBuilder<T, E> registerError(Class<? extends RestException> type) {
        this.baseBuilder.registerError(type);
        return this;
    }

    public ServiceResponse<T> build(Response<ResponseBody> response) throws IOException {
        return this.baseBuilder.build(response);
    }

    public ServiceResponse<T> buildEmpty(Response<Void> response) throws E, IOException {
        int statusCode = response.code();
        if (this.baseBuilder.isSuccessful(statusCode)) {
            if (new TypeToken<T>(this.getClass()){}.getRawType().isAssignableFrom(Boolean.class)) {
                return new ServiceResponse(response).withBody((Object)(statusCode / 100 == 2 ? 1 : 0));
            }
            return new ServiceResponse(response);
        }
        try {
            throw (RestException)this.baseBuilder.exceptionType().getConstructor(String.class, Response.class).newInstance("Status code " + statusCode, response);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Invalid status code " + statusCode + ", but an instance of " + this.baseBuilder.exceptionType().getCanonicalName() + " cannot be created.", e);
        }
    }

    public <THeader> ServiceResponseWithHeaders<T, THeader> buildWithHeaders(Response<ResponseBody> response, Class<THeader> headerType) throws IOException {
        return this.baseBuilder.buildWithHeaders(response, headerType);
    }

    public <THeader> ServiceResponseWithHeaders<T, THeader> buildEmptyWithHeaders(Response<Void> response, Class<THeader> headerType) throws IOException {
        ServiceResponse<T> bodyResponse = this.buildEmpty(response);
        ServiceResponseWithHeaders baseResponse = this.baseBuilder.buildEmptyWithHeaders(response, headerType);
        ServiceResponseWithHeaders serviceResponse = new ServiceResponseWithHeaders(baseResponse.headers(), bodyResponse.headResponse());
        serviceResponse.withBody(bodyResponse.body());
        return serviceResponse;
    }

    public AzureResponseBuilder<T, E> withThrowOnGet404(boolean throwOnGet404) {
        this.baseBuilder.withThrowOnGet404(throwOnGet404);
        return this;
    }

    public static final class Factory
    implements ResponseBuilder.Factory {
        public <T, E extends RestException> AzureResponseBuilder<T, E> newInstance(SerializerAdapter<?> serializerAdapter) {
            return new AzureResponseBuilder(serializerAdapter);
        }
    }
}

