/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptConditionEvaluator;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerRequestScriptEvaluator;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDefUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDefUtil.class);
    public static final String IMPLICIT_CONDITION_EXPRESSION_EVALUATOR = RangerScriptConditionEvaluator.class.getCanonicalName();
    public static final String IMPLICIT_CONDITION_EXPRESSION_NAME = "_expression";
    public static final String IMPLICIT_CONDITION_EXPRESSION_LABEL = "Enter boolean expression";
    public static final String IMPLICIT_CONDITION_EXPRESSION_DESC = "Boolean expression";
    private static final String USER_STORE_ENRICHER = RangerUserStoreEnricher.class.getCanonicalName();
    public static final String ACCESS_TYPE_MARKER_CREATE = "_CREATE";
    public static final String ACCESS_TYPE_MARKER_READ = "_READ";
    public static final String ACCESS_TYPE_MARKER_UPDATE = "_UPDATE";
    public static final String ACCESS_TYPE_MARKER_DELETE = "_DELETE";
    public static final String ACCESS_TYPE_MARKER_MANAGE = "_MANAGE";
    public static final String ACCESS_TYPE_MARKER_ALL = "_ALL";
    public static final Set<String> ACCESS_TYPE_MARKERS;

    public static boolean getOption_enableDenyAndExceptionsInPolicies(RangerServiceDef serviceDef, RangerPluginContext pluginContext) {
        boolean ret = false;
        if (serviceDef != null) {
            RangerPluginConfig config = pluginContext != null ? pluginContext.getConfig() : null;
            boolean enableDenyAndExceptionsInPoliciesHiddenOption = config == null || config.getBoolean("ranger.servicedef.enableDenyAndExceptionsInPolicies", true);
            boolean defaultValue = enableDenyAndExceptionsInPoliciesHiddenOption || StringUtils.equalsIgnoreCase((String)serviceDef.getName(), (String)"tag");
            ret = ServiceDefUtil.getBooleanValue(serviceDef.getOptions(), "enableDenyAndExceptionsInPolicies", defaultValue);
        }
        return ret;
    }

    public static boolean getOption_enableTagBasedPolicies(RangerServiceDef serviceDef, Configuration config) {
        boolean ret = false;
        if (serviceDef != null) {
            boolean defaultValue = config == null || config.getBoolean("ranger.servicedef.enableTagBasedPolicies", true);
            ret = ServiceDefUtil.getBooleanValue(serviceDef.getOptions(), "enableTagBasedPolicies", defaultValue);
        }
        return ret;
    }

    public static RangerServiceDef.RangerDataMaskTypeDef getDataMaskType(RangerServiceDef serviceDef, String typeName) {
        List<RangerServiceDef.RangerDataMaskTypeDef> maskTypes;
        RangerServiceDef.RangerDataMaskTypeDef ret = null;
        if (serviceDef != null && serviceDef.getDataMaskDef() != null && CollectionUtils.isNotEmpty(maskTypes = serviceDef.getDataMaskDef().getMaskTypes())) {
            for (RangerServiceDef.RangerDataMaskTypeDef maskType : maskTypes) {
                if (!StringUtils.equals((String)maskType.getName(), (String)typeName)) continue;
                ret = maskType;
                break;
            }
        }
        return ret;
    }

    public static RangerServiceDef normalize(RangerServiceDef serviceDef) {
        ServiceDefUtil.normalizeDataMaskDef(serviceDef);
        ServiceDefUtil.normalizeRowFilterDef(serviceDef);
        return serviceDef;
    }

    public static RangerServiceDef.RangerPolicyConditionDef getConditionDef(RangerServiceDef serviceDef, String conditionName) {
        RangerServiceDef.RangerPolicyConditionDef ret = null;
        if (serviceDef != null && serviceDef.getPolicyConditions() != null) {
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : serviceDef.getPolicyConditions()) {
                if (!StringUtils.equals((String)conditionDef.getName(), (String)conditionName)) continue;
                ret = conditionDef;
                break;
            }
        }
        return ret;
    }

    public static RangerServiceDef.RangerResourceDef getResourceDef(RangerServiceDef serviceDef, String resource) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && resource != null && CollectionUtils.isNotEmpty(serviceDef.getResources())) {
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                if (!StringUtils.equalsIgnoreCase((String)resourceDef.getName(), (String)resource)) continue;
                ret = resourceDef;
                break;
            }
        }
        return ret;
    }

    public static Integer getLeafResourceLevel(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        Integer ret = null;
        RangerServiceDef.RangerResourceDef resourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, policyResource);
        if (resourceDef != null) {
            ret = resourceDef.getLevel();
        }
        return ret;
    }

    public static RangerServiceDef.RangerResourceDef getLeafResourceDef(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        return ServiceDefUtil.getLeafResourceDef(serviceDef, policyResource, false);
    }

    public static RangerServiceDef.RangerResourceDef getLeafResourceDef(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource, boolean excludeWildcardLeaves) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && policyResource != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResource.entrySet()) {
                String resource;
                RangerServiceDef.RangerResourceDef resourceDef;
                if (ServiceDefUtil.isEmpty(entry.getValue()) || (resourceDef = ServiceDefUtil.getResourceDef(serviceDef, resource = entry.getKey())) == null || resourceDef.getLevel() == null || ret != null && ret.getLevel() >= resourceDef.getLevel()) continue;
                if (StringUtils.isEmpty((String)resourceDef.getParent())) {
                    ret = resourceDef;
                    continue;
                }
                if (excludeWildcardLeaves && ServiceDefUtil.hasWildcardValue(entry.getValue().getValues())) continue;
                ret = resourceDef;
            }
        }
        return ret;
    }

    private static boolean hasWildcardValue(List<String> values) {
        String strValue;
        boolean ret = false;
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext() && !(ret = StringUtils.equals((String)(strValue = iterator.next()), (String)"*"))) {
        }
        return ret;
    }

    public static boolean isAncestorOf(RangerServiceDef serviceDef, RangerServiceDef.RangerResourceDef ancestor, RangerServiceDef.RangerResourceDef descendant) {
        boolean ret = false;
        if (ancestor != null && descendant != null) {
            String ancestorName = ancestor.getName();
            RangerServiceDef.RangerResourceDef node = descendant;
            while (node != null) {
                if (StringUtils.equalsIgnoreCase((String)ancestorName, (String)node.getParent())) {
                    ret = true;
                    break;
                }
                node = ServiceDefUtil.getResourceDef(serviceDef, node.getParent());
            }
        }
        return ret;
    }

    public static boolean isEmpty(RangerPolicy.RangerPolicyResource policyResource) {
        List<String> resourceValues;
        boolean ret = true;
        if (policyResource != null && CollectionUtils.isNotEmpty(resourceValues = policyResource.getValues())) {
            for (String resourceValue : resourceValues) {
                if (!StringUtils.isNotBlank((String)resourceValue)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static String getOption(Map<String, String> options, String name, String defaultValue) {
        String ret;
        String string = ret = options != null && name != null ? options.get(name) : null;
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanOption(Map<String, String> options, String name, boolean defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return val == null ? defaultValue : Boolean.parseBoolean(val);
    }

    public static char getCharOption(Map<String, String> options, String name, char defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return StringUtils.isEmpty((String)val) ? defaultValue : val.charAt(0);
    }

    public static RangerServiceDef normalizeAccessTypeDefs(RangerServiceDef serviceDef, String componentType) {
        if (serviceDef != null && StringUtils.isNotBlank((String)componentType)) {
            ServiceDefUtil.normalizeAccessTypeDefs(serviceDef.getAccessTypes(), componentType);
            ServiceDefUtil.normalizeAccessTypeDefs(serviceDef.getMarkerAccessTypes(), componentType);
            if (serviceDef.getDataMaskDef() != null) {
                ServiceDefUtil.normalizeAccessTypeDefs(serviceDef.getDataMaskDef().getAccessTypes(), componentType);
            }
            if (serviceDef.getRowFilterDef() != null) {
                ServiceDefUtil.normalizeAccessTypeDefs(serviceDef.getRowFilterDef().getAccessTypes(), componentType);
            }
        }
        return serviceDef;
    }

    private static void normalizeAccessTypeDefs(List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs, String componentType) {
        if (CollectionUtils.isNotEmpty(accessTypeDefs)) {
            String prefix = componentType + ":";
            ArrayList<RangerServiceDef.RangerAccessTypeDef> unneededAccessTypeDefs = null;
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
                Collection<String> impliedGrants;
                String accessType = accessTypeDef.getName();
                if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                    String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                    accessTypeDef.setName(newAccessType);
                } else if (StringUtils.contains((String)accessType, (String)":")) {
                    if (unneededAccessTypeDefs == null) {
                        unneededAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
                    }
                    unneededAccessTypeDefs.add(accessTypeDef);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(impliedGrants = accessTypeDef.getImpliedGrants())) continue;
                HashSet<String> newImpliedGrants = new HashSet<String>();
                for (String impliedGrant : impliedGrants) {
                    if (StringUtils.startsWith((String)impliedGrant, (String)prefix)) {
                        String newImpliedGrant = StringUtils.removeStart((String)impliedGrant, (String)prefix);
                        newImpliedGrants.add(newImpliedGrant);
                        continue;
                    }
                    if (StringUtils.contains((String)impliedGrant, (String)":")) continue;
                    newImpliedGrants.add(impliedGrant);
                }
                accessTypeDef.setImpliedGrants(newImpliedGrants);
            }
            if (unneededAccessTypeDefs != null) {
                accessTypeDefs.removeAll(unneededAccessTypeDefs);
            }
        }
    }

    private static void normalizeDataMaskDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getDataMaskDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> dataMaskResources = serviceDef.getDataMaskDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> dataMaskAccessTypes = serviceDef.getDataMaskDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(dataMaskResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(dataMaskResources.size());
                Iterator<Serializable> iterator = dataMaskResources.iterator();
                while (iterator.hasNext()) {
                    RangerServiceDef.RangerResourceDef dataMaskResource;
                    processedDef = dataMaskResource = (RangerServiceDef.RangerResourceDef)iterator.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals((String)resourceDef.getName(), (String)dataMaskResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, dataMaskResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(dataMaskAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef dataMaskAccessType : dataMaskAccessTypes) {
                    processedDef = dataMaskAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals((String)accessType.getName(), (String)dataMaskAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, dataMaskAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static void normalizeRowFilterDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getRowFilterDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> rowFilterResources = serviceDef.getRowFilterDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> rowFilterAccessTypes = serviceDef.getRowFilterDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(rowFilterResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(rowFilterResources.size());
                Iterator<Serializable> iterator = rowFilterResources.iterator();
                while (iterator.hasNext()) {
                    RangerServiceDef.RangerResourceDef rowFilterResource;
                    processedDef = rowFilterResource = (RangerServiceDef.RangerResourceDef)iterator.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals((String)resourceDef.getName(), (String)rowFilterResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, rowFilterResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(rowFilterAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef rowFilterAccessType : rowFilterAccessTypes) {
                    processedDef = rowFilterAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals((String)accessType.getName(), (String)rowFilterAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, rowFilterAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static RangerServiceDef.RangerResourceDef mergeResourceDef(RangerServiceDef.RangerResourceDef base, RangerServiceDef.RangerResourceDef delta) {
        RangerServiceDef.RangerResourceDef ret = new RangerServiceDef.RangerResourceDef(base);
        if (Boolean.TRUE.equals(delta.getMandatory())) {
            ret.setMandatory(delta.getMandatory());
        }
        if (delta.getRecursiveSupported() != null) {
            ret.setRecursiveSupported(delta.getRecursiveSupported());
        }
        if (delta.getExcludesSupported() != null) {
            ret.setExcludesSupported(delta.getExcludesSupported());
        }
        if (StringUtils.isNotEmpty((String)delta.getMatcher())) {
            ret.setMatcher(delta.getMatcher());
        }
        if (MapUtils.isNotEmpty(delta.getMatcherOptions())) {
            if (ret.getMatcherOptions() == null) {
                ret.setMatcherOptions(new HashMap<String, String>());
            }
            for (Map.Entry<String, String> e : delta.getMatcherOptions().entrySet()) {
                ret.getMatcherOptions().put(e.getKey(), e.getValue());
            }
        }
        if (StringUtils.isNotEmpty((String)delta.getValidationRegEx())) {
            ret.setValidationRegEx(delta.getValidationRegEx());
        }
        if (StringUtils.isNotEmpty((String)delta.getValidationMessage())) {
            ret.setValidationMessage(delta.getValidationMessage());
        }
        ret.setUiHint(delta.getUiHint());
        if (StringUtils.isNotEmpty((String)delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getDescription())) {
            ret.setDescription(delta.getDescription());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyDescription())) {
            ret.setRbKeyDescription(delta.getRbKeyDescription());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyValidationMessage())) {
            ret.setRbKeyValidationMessage(delta.getRbKeyValidationMessage());
        }
        if (CollectionUtils.isNotEmpty(delta.getAccessTypeRestrictions())) {
            ret.setAccessTypeRestrictions(delta.getAccessTypeRestrictions());
        }
        boolean copyLeafValue = false;
        if (ret.getIsValidLeaf() != null) {
            if (!ret.getIsValidLeaf().equals(delta.getIsValidLeaf())) {
                copyLeafValue = true;
            }
        } else if (delta.getIsValidLeaf() != null) {
            copyLeafValue = true;
        }
        if (copyLeafValue) {
            ret.setIsValidLeaf(delta.getIsValidLeaf());
        }
        return ret;
    }

    private static RangerServiceDef.RangerAccessTypeDef mergeAccessTypeDef(RangerServiceDef.RangerAccessTypeDef base, RangerServiceDef.RangerAccessTypeDef delta) {
        RangerServiceDef.RangerAccessTypeDef ret = new RangerServiceDef.RangerAccessTypeDef(base);
        if (StringUtils.isNotEmpty((String)delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        return ret;
    }

    public static boolean getBooleanValue(Map<String, String> map, String elementName, boolean defaultValue) {
        String elementValue;
        boolean ret = defaultValue;
        if (MapUtils.isNotEmpty(map) && map.containsKey(elementName) && StringUtils.isNotEmpty((String)(elementValue = map.get(elementName)))) {
            ret = Boolean.valueOf(elementValue.toString());
        }
        return ret;
    }

    public static Map<String, Collection<String>> getExpandedImpliedGrants(RangerServiceDef serviceDef) {
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        if (serviceDef != null && !CollectionUtils.isEmpty(serviceDef.getAccessTypes())) {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                if (!CollectionUtils.isEmpty(accessTypeDef.getImpliedGrants())) {
                    HashSet<String> impliedAccessGrants = (HashSet<String>)ret.get(accessTypeDef.getName());
                    if (impliedAccessGrants == null) {
                        impliedAccessGrants = new HashSet<String>();
                        ret.put(accessTypeDef.getName(), impliedAccessGrants);
                    }
                    impliedAccessGrants.addAll(accessTypeDef.getImpliedGrants());
                    impliedAccessGrants.add(accessTypeDef.getName());
                    continue;
                }
                ret.put(accessTypeDef.getName(), new HashSet<String>(Collections.singleton(accessTypeDef.getName())));
            }
        }
        return ret;
    }

    public static boolean isUserStoreEnricherPresent(ServicePolicies policies) {
        List<RangerServiceDef.RangerContextEnricherDef> enricherDefs;
        boolean ret = false;
        RangerServiceDef serviceDef = policies != null ? policies.getServiceDef() : null;
        List<RangerServiceDef.RangerContextEnricherDef> list = enricherDefs = serviceDef != null ? serviceDef.getContextEnrichers() : null;
        if (enricherDefs != null) {
            for (RangerServiceDef.RangerContextEnricherDef enricherDef : enricherDefs) {
                if (!StringUtils.equals((String)enricherDef.getEnricher(), (String)USER_STORE_ENRICHER)) continue;
                ret = true;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUserStoreEnricherPresent(service={}): ret={}", (Object)policies.getServiceName(), (Object)ret);
        }
        return ret;
    }

    public static boolean addUserStoreEnricher(ServicePolicies policies, String retrieverClassName, String retrieverPollIntMs) {
        RangerServiceDef serviceDef;
        boolean ret = false;
        RangerServiceDef rangerServiceDef = serviceDef = policies != null ? policies.getServiceDef() : null;
        if (serviceDef != null && !ServiceDefUtil.isUserStoreEnricherPresent(policies)) {
            List<RangerServiceDef.RangerContextEnricherDef> enricherDefs = serviceDef.getContextEnrichers();
            if (enricherDefs == null) {
                enricherDefs = new ArrayList<RangerServiceDef.RangerContextEnricherDef>();
            }
            long enricherItemId = enricherDefs.size() + 1;
            for (RangerServiceDef.RangerContextEnricherDef enricherDef : enricherDefs) {
                if (enricherDef.getItemId() < enricherItemId) continue;
                enricherItemId = enricherDef.getItemId() + 1L;
            }
            HashMap<String, String> enricherOptions = new HashMap<String, String>();
            enricherOptions.put("userStoreRetrieverClassName", retrieverClassName);
            enricherOptions.put("userStoreRefresherPollingInterval", retrieverPollIntMs);
            RangerServiceDef.RangerContextEnricherDef userStoreEnricher = new RangerServiceDef.RangerContextEnricherDef(enricherItemId, "userStoreEnricher", USER_STORE_ENRICHER, enricherOptions);
            enricherDefs.add(userStoreEnricher);
            serviceDef.setContextEnrichers(enricherDefs);
            ret = true;
            LOG.info("addUserStoreEnricher(serviceName={}): added userStoreEnricher {}", (Object)policies.getServiceName(), (Object)userStoreEnricher);
        }
        return ret;
    }

    public static boolean addUserStoreEnricherIfNeeded(ServicePolicies policies, String retrieverClassName, String retrieverPollIntMs) {
        RangerServiceDef serviceDef;
        boolean ret = false;
        RangerServiceDef rangerServiceDef = serviceDef = policies != null ? policies.getServiceDef() : null;
        if (serviceDef != null && !ServiceDefUtil.isUserStoreEnricherPresent(policies)) {
            Map<String, ServicePolicies.SecurityZoneInfo> zoneInfos;
            boolean addEnricher = ServiceDefUtil.anyPolicyHasUserGroupAttributeExpression(policies.getPolicies());
            if (!addEnricher) {
                List<RangerPolicy> tagPolicies = policies.getTagPolicies() != null ? policies.getTagPolicies().getPolicies() : null;
                addEnricher = ServiceDefUtil.anyPolicyHasUserGroupAttributeExpression(tagPolicies);
            }
            if (!addEnricher) {
                addEnricher = ServiceDefUtil.anyPolicyDeltaHasUserGroupAttributeExpression(policies.getPolicyDeltas());
            }
            if (!addEnricher && (zoneInfos = policies.getSecurityZones()) != null) {
                for (ServicePolicies.SecurityZoneInfo zoneInfo : zoneInfos.values()) {
                    addEnricher = ServiceDefUtil.anyPolicyHasUserGroupAttributeExpression(zoneInfo.getPolicies());
                    if (!addEnricher) {
                        addEnricher = ServiceDefUtil.anyPolicyDeltaHasUserGroupAttributeExpression(zoneInfo.getPolicyDeltas());
                    }
                    if (!addEnricher) continue;
                    break;
                }
            }
            if (addEnricher) {
                ServiceDefUtil.addUserStoreEnricher(policies, retrieverClassName, retrieverPollIntMs);
                ret = true;
            }
        }
        return ret;
    }

    public static List<RangerServiceDef.RangerAccessTypeDef> getMarkerAccessTypes(List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs) {
        ArrayList<RangerServiceDef.RangerAccessTypeDef> ret = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        Map<String, Set<String>> markerTypeGrants = ServiceDefUtil.getMarkerAccessTypeGrants(accessTypeDefs);
        long maxItemId = ServiceDefUtil.getMaxItemId(accessTypeDefs);
        for (String accessTypeMarker : ACCESS_TYPE_MARKERS) {
            RangerServiceDef.RangerAccessTypeDef accessTypeDef = new RangerServiceDef.RangerAccessTypeDef(++maxItemId, accessTypeMarker, accessTypeMarker, null, (Collection<String>)markerTypeGrants.get(accessTypeMarker));
            ret.add(accessTypeDef);
        }
        return ret;
    }

    public static RangerServiceDef.RangerPolicyConditionDef createImplicitExpressionConditionDef(Long itemId) {
        RangerServiceDef.RangerPolicyConditionDef ret = new RangerServiceDef.RangerPolicyConditionDef(itemId, IMPLICIT_CONDITION_EXPRESSION_NAME, IMPLICIT_CONDITION_EXPRESSION_EVALUATOR, new HashMap<String, String>());
        ret.getEvaluatorOptions().put("engineName", "JavaScript");
        ret.getEvaluatorOptions().put("ui.isMultiline", "true");
        ret.setLabel(IMPLICIT_CONDITION_EXPRESSION_LABEL);
        ret.setDescription(IMPLICIT_CONDITION_EXPRESSION_DESC);
        ret.setUiHint("{ \"isMultiline\":true }");
        return ret;
    }

    private static Map<String, Set<String>> getMarkerAccessTypeGrants(List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs) {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (String accessTypeMarker : ACCESS_TYPE_MARKERS) {
            ret.put(accessTypeMarker, new HashSet());
        }
        if (CollectionUtils.isNotEmpty(accessTypeDefs)) {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
                if (accessTypeDef == null || StringUtils.isBlank((String)accessTypeDef.getName()) || ACCESS_TYPE_MARKERS.contains(accessTypeDef.getName())) continue;
                ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_ALL));
                if (accessTypeDef.getCategory() == null) continue;
                if (accessTypeDef.getCategory() == RangerServiceDef.RangerAccessTypeDef.AccessTypeCategory.CREATE) {
                    ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_CREATE));
                    continue;
                }
                if (accessTypeDef.getCategory() == RangerServiceDef.RangerAccessTypeDef.AccessTypeCategory.READ) {
                    ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_READ));
                    continue;
                }
                if (accessTypeDef.getCategory() == RangerServiceDef.RangerAccessTypeDef.AccessTypeCategory.UPDATE) {
                    ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_UPDATE));
                    continue;
                }
                if (accessTypeDef.getCategory() == RangerServiceDef.RangerAccessTypeDef.AccessTypeCategory.DELETE) {
                    ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_DELETE));
                    continue;
                }
                if (accessTypeDef.getCategory() != RangerServiceDef.RangerAccessTypeDef.AccessTypeCategory.MANAGE) continue;
                ServiceDefUtil.addToMarkerGrants(accessTypeDef, (Set)ret.get(ACCESS_TYPE_MARKER_MANAGE));
            }
        }
        return ret;
    }

    private static void addToMarkerGrants(RangerServiceDef.RangerAccessTypeDef accessTypeDef, Set<String> markerGrants) {
        markerGrants.add(accessTypeDef.getName());
        if (CollectionUtils.isNotEmpty(accessTypeDef.getImpliedGrants())) {
            markerGrants.addAll(accessTypeDef.getImpliedGrants());
        }
    }

    private static long getMaxItemId(List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs) {
        long ret = -1L;
        if (CollectionUtils.isNotEmpty(accessTypeDefs)) {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
                if (accessTypeDef.getItemId() == null || ret >= accessTypeDef.getItemId()) continue;
                ret = accessTypeDef.getItemId();
            }
        }
        return ret;
    }

    public static long getConditionsMaxItemId(List<RangerServiceDef.RangerPolicyConditionDef> conditions) {
        long ret = 0L;
        if (conditions != null) {
            for (RangerServiceDef.RangerPolicyConditionDef condition : conditions) {
                if (condition == null || condition.getItemId() == null || ret >= condition.getItemId()) continue;
                ret = condition.getItemId();
            }
        }
        return ret;
    }

    private static boolean anyPolicyHasUserGroupAttributeExpression(List<RangerPolicy> policies) {
        boolean ret = false;
        if (policies != null) {
            for (RangerPolicy policy : policies) {
                if (!ServiceDefUtil.policyHasUserGroupAttributeExpression(policy)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("addUserStoreEnricherIfNeeded(service={}): policy(id={}, name={}) has reference to user/group attribute. Adding enricher", new Object[]{policy.getService(), policy.getId(), policy.getName()});
                }
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean anyPolicyDeltaHasUserGroupAttributeExpression(List<RangerPolicyDelta> policyDeltas) {
        boolean ret = false;
        if (policyDeltas != null) {
            for (RangerPolicyDelta policyDelta : policyDeltas) {
                RangerPolicy policy = policyDelta.getPolicy();
                if (!ServiceDefUtil.policyHasUserGroupAttributeExpression(policy)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("addUserStoreEnricherIfNeeded(service={}): policy(id={}, name={}) has reference to user/group attribute. Adding enricher", new Object[]{policy.getService(), policy.getId(), policy.getName()});
                }
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean policyHasUserGroupAttributeExpression(RangerPolicy policy) {
        boolean ret = false;
        if (policy != null) {
            if (MapUtils.isNotEmpty(policy.getResources())) {
                RangerPolicy.RangerPolicyResource resource;
                Iterator<RangerPolicy.RangerPolicyResource> iterator = policy.getResources().values().iterator();
                while (iterator.hasNext() && !(ret = RangerRequestExprResolver.hasUserGroupAttributeInExpression((resource = iterator.next()).getValues()))) {
                }
            }
            if (!ret) {
                ret = ServiceDefUtil.anyPolicyConditionHasUserGroupAttributeReference(policy.getConditions());
            }
            if (!ret) {
                ret = ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getPolicyItems()) || ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getDenyPolicyItems()) || ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getAllowExceptions()) || ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getDenyExceptions()) || ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getDataMaskPolicyItems()) || ServiceDefUtil.anyPolicyItemHasUserGroupAttributeExpression(policy.getRowFilterPolicyItems());
            }
        }
        return ret;
    }

    private static boolean anyPolicyItemHasUserGroupAttributeExpression(List<? extends RangerPolicy.RangerPolicyItem> policyItems) {
        boolean ret = false;
        if (policyItems != null) {
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                if (!ServiceDefUtil.policyItemHasUserGroupAttributeExpression(rangerPolicyItem)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean policyItemHasUserGroupAttributeExpression(RangerPolicy.RangerPolicyItem policyItem) {
        boolean ret = false;
        if (policyItem != null) {
            RangerPolicy.RangerDataMaskPolicyItem dataMaskPolicyItem;
            RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo;
            String maskedValue;
            ret = ServiceDefUtil.anyPolicyConditionHasUserGroupAttributeReference(policyItem.getConditions());
            if (!ret && policyItem instanceof RangerPolicy.RangerRowFilterPolicyItem) {
                RangerPolicy.RangerRowFilterPolicyItem rowFilterPolicyItem = (RangerPolicy.RangerRowFilterPolicyItem)policyItem;
                RangerPolicy.RangerPolicyItemRowFilterInfo rowFilterInfo = rowFilterPolicyItem.getRowFilterInfo();
                String filterExpr = rowFilterInfo != null ? rowFilterInfo.getFilterExpr() : "";
                ret = RangerRequestExprResolver.hasUserGroupAttributeInExpression(filterExpr);
            }
            if (!ret && policyItem instanceof RangerPolicy.RangerDataMaskPolicyItem && !(ret = RangerRequestExprResolver.hasUserGroupAttributeInExpression(maskedValue = (dataMaskInfo = (dataMaskPolicyItem = (RangerPolicy.RangerDataMaskPolicyItem)policyItem).getDataMaskInfo()) != null ? dataMaskInfo.getValueExpr() : null))) {
                String maskCondition = dataMaskInfo != null ? dataMaskInfo.getConditionExpr() : null;
                ret = RangerRequestExprResolver.hasUserGroupAttributeInExpression(maskCondition);
            }
        }
        return ret;
    }

    private static boolean anyPolicyConditionHasUserGroupAttributeReference(List<RangerPolicy.RangerPolicyItemCondition> conditions) {
        boolean ret = false;
        if (conditions != null) {
            for (RangerPolicy.RangerPolicyItemCondition condition : conditions) {
                if (!RangerRequestScriptEvaluator.hasUserGroupAttributeReference(condition.getValues())) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    static {
        LinkedHashSet<String> typeMarkers = new LinkedHashSet<String>();
        typeMarkers.add(ACCESS_TYPE_MARKER_CREATE);
        typeMarkers.add(ACCESS_TYPE_MARKER_READ);
        typeMarkers.add(ACCESS_TYPE_MARKER_UPDATE);
        typeMarkers.add(ACCESS_TYPE_MARKER_DELETE);
        typeMarkers.add(ACCESS_TYPE_MARKER_MANAGE);
        typeMarkers.add(ACCESS_TYPE_MARKER_ALL);
        ACCESS_TYPE_MARKERS = Collections.unmodifiableSet(typeMarkers);
    }
}

