/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.ranger.ha.annotation.HAService;
import org.apache.ranger.ha.service.HARangerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HAService
public class ServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceManager.class);
    private final List<HARangerService> services;

    public ServiceManager(List<HARangerService> services) {
        this.services = services;
        this.start();
        LOG.info("ServiceManager started with {} services", (Object)(services != null ? services.size() : 0));
    }

    @PostConstruct
    public void start() {
        LOG.info("ServiceManager.start() Starting services with service size :{} ", (Object)this.services.size());
        try {
            for (HARangerService svc : this.services) {
                LOG.info("Starting service {}", (Object)svc.getClass().getName());
                svc.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void stop() {
        for (int idx = this.services.size() - 1; idx >= 0; --idx) {
            HARangerService svc = this.services.get(idx);
            try {
                LOG.info("Stopping service {}", (Object)svc.getClass().getName());
                svc.stop();
                continue;
            }
            catch (Throwable e) {
                LOG.warn("Error stopping service {}", (Object)svc.getClass().getName(), (Object)e);
            }
        }
    }
}

