/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionManager {
    static final Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    private final String name;
    private final ConcurrentMap<TermIndex, MemoizedSupplier<TransactionContext>> contexts = new ConcurrentHashMap<TermIndex, MemoizedSupplier<TransactionContext>>();

    TransactionManager(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    @VisibleForTesting
    Map<TermIndex, MemoizedSupplier<TransactionContext>> getMap() {
        LOG.debug("{}", (Object)this);
        return Collections.unmodifiableMap(this.contexts);
    }

    TransactionContext get(TermIndex termIndex) {
        return Optional.ofNullable(this.contexts.get(termIndex)).map(MemoizedSupplier::get).orElse(null);
    }

    TransactionContext computeIfAbsent(TermIndex termIndex, MemoizedSupplier<TransactionContext> constructor) {
        MemoizedSupplier m4 = this.contexts.computeIfAbsent(termIndex, (? super K i) -> constructor);
        if (!m4.isInitialized()) {
            LOG.debug("{}: {}", (Object)termIndex, (Object)this);
        }
        return (TransactionContext)m4.get();
    }

    void remove(TermIndex termIndex) {
        MemoizedSupplier removed = (MemoizedSupplier)this.contexts.remove(termIndex);
        if (removed != null) {
            LOG.debug("{}: {}", (Object)termIndex, (Object)this);
        }
    }

    public String toString() {
        if (this.contexts.isEmpty()) {
            return this.name + " <empty>";
        }
        StringBuilder b = new StringBuilder(this.name);
        this.contexts.forEach((k, v) -> b.append("\n  ").append(k).append(": initialized? ").append(v.isInitialized()));
        return b.toString();
    }
}

