/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FollowerState
extends Daemon {
    static final Logger LOG = LoggerFactory.getLogger(FollowerState.class);
    private final Object reason;
    private final RaftServerImpl server;
    private final Timestamp creationTime;
    private volatile Timestamp lastRpcTime;
    private volatile boolean isRunning;
    private final CompletableFuture<Void> stopped;
    private final AtomicInteger outstandingOp;

    FollowerState(RaftServerImpl server, Object reason) {
        super(FollowerState.newBuilder().setName(server.getMemberId() + "-" + JavaUtils.getClassSimpleName(FollowerState.class)).setThreadGroup(server.getThreadGroup()));
        this.lastRpcTime = this.creationTime = Timestamp.currentTime();
        this.isRunning = true;
        this.stopped = new CompletableFuture();
        this.outstandingOp = new AtomicInteger();
        this.server = server;
        this.reason = reason;
    }

    void updateLastRpcTime(UpdateType type) {
        this.lastRpcTime = Timestamp.currentTime();
        int n = type.update(this.outstandingOp);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: update lastRpcTime to {} for {}, outstandingOp={}", new Object[]{this, this.lastRpcTime, type, n});
        }
    }

    Timestamp getLastRpcTime() {
        return this.lastRpcTime;
    }

    int getOutstandingOp() {
        return this.outstandingOp.get();
    }

    boolean isCurrentLeaderValid() {
        return this.lastRpcTime.elapsedTime().compareTo(this.server.properties().minRpcTimeout()) < 0;
    }

    CompletableFuture<Void> stopRunning() {
        this.isRunning = false;
        this.interrupt();
        return this.stopped;
    }

    boolean lostMajorityHeartbeatsRecently() {
        TimeDuration waitTime;
        if (this.reason != LeaderState.StepDownReason.LOST_MAJORITY_HEARTBEATS) {
            return false;
        }
        TimeDuration elapsed = this.creationTime.elapsedTime();
        if (elapsed.compareTo(waitTime = this.server.getLeaderStepDownWaitTime()) >= 0) {
            return false;
        }
        LOG.info("{}: Skipping leader election since it stepped down recently (elapsed = {} < waitTime = {})", this, elapsed.to(TimeUnit.MILLISECONDS), waitTime);
        return true;
    }

    private boolean shouldRun() {
        boolean run;
        DivisionInfo info = this.server.getInfo();
        boolean bl = run = this.isRunning && (info.isFollower() || info.isListener());
        if (!run) {
            LOG.info("{}: Stopping now (isRunning? {}, role = {})", this, this.isRunning, info.getCurrentRole());
        }
        return run;
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        finally {
            this.stopped.complete(null);
        }
    }

    private boolean roleChangeChecking(TimeDuration electionTimeout) {
        return this.outstandingOp.get() == 0 && this.isRunning && this.server.getInfo().isFollower() && this.lastRpcTime.elapsedTime().compareTo(electionTimeout) >= 0 && !this.lostMajorityHeartbeatsRecently() && this.server.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() {
        TimeDuration sleepDeviationThreshold = this.server.getSleepDeviationThreshold();
        while (this.shouldRun()) {
            TimeDuration electionTimeout = this.server.getRandomElectionTimeout();
            try {
                TimeDuration extraSleep = electionTimeout.sleep();
                if (extraSleep.compareTo(sleepDeviationThreshold) > 0) {
                    LOG.warn("Unexpected long sleep: sleep {} but took extra {} (> threshold = {})", electionTimeout, extraSleep, sleepDeviationThreshold);
                    continue;
                }
                if (!this.shouldRun()) break;
                RaftServerImpl raftServerImpl = this.server;
                synchronized (raftServerImpl) {
                    if (this.roleChangeChecking(electionTimeout)) {
                        LOG.info("{}: change to CANDIDATE, lastRpcElapsedTime:{}, electionTimeout:{}", this, this.lastRpcTime.elapsedTime(), electionTimeout);
                        this.server.getLeaderElectionMetrics().onLeaderElectionTimeout();
                        this.server.changeToCandidate(false);
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.info("{} was interrupted", (Object)this);
                LOG.trace("TRACE", e);
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                LOG.warn("{} caught an exception", (Object)this, (Object)e);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    static enum UpdateType {
        APPEND_START(AtomicInteger::incrementAndGet),
        APPEND_COMPLETE(AtomicInteger::decrementAndGet),
        INSTALL_SNAPSHOT_START(AtomicInteger::incrementAndGet),
        INSTALL_SNAPSHOT_COMPLETE(AtomicInteger::decrementAndGet),
        INSTALL_SNAPSHOT_NOTIFICATION(AtomicInteger::get),
        REQUEST_VOTE(AtomicInteger::get);

        private final ToIntFunction<AtomicInteger> updateFunction;

        private UpdateType(ToIntFunction<AtomicInteger> updateFunction) {
            this.updateFunction = updateFunction;
        }

        int update(AtomicInteger outstanding) {
            return this.updateFunction.applyAsInt(outstanding);
        }
    }
}

