/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.routeinfo;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.routeinfo.BrokerLiveInfo;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class RouteInfoManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");
    private static final long BROKER_CHANNEL_EXPIRED_TIME = 120000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final HashMap<String, Map<String, QueueData>> topicQueueTable = new HashMap(1024);
    private final HashMap<String, BrokerData> brokerAddrTable = new HashMap(128);
    private final HashMap<String, Set<String>> clusterAddrTable = new HashMap(32);
    private final HashMap<String, BrokerLiveInfo> brokerLiveTable = new HashMap(256);
    private final HashMap<String, List<String>> filterServerTable = new HashMap(256);

    public ClusterInfo getAllClusterInfo() {
        ClusterInfo clusterInfoSerializeWrapper = new ClusterInfo();
        clusterInfoSerializeWrapper.setBrokerAddrTable(this.brokerAddrTable);
        clusterInfoSerializeWrapper.setClusterAddrTable(this.clusterAddrTable);
        return clusterInfoSerializeWrapper;
    }

    public void deleteTopic(String topic) {
        try {
            try {
                this.lock.writeLock().lockInterruptibly();
                this.topicQueueTable.remove(topic);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("deleteTopic Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTopic(String topic, String clusterName) {
        try {
            try {
                Map<String, QueueData> queueDataMap;
                this.lock.writeLock().lockInterruptibly();
                Set<String> brokerNames = this.clusterAddrTable.get(clusterName);
                if (brokerNames != null && !brokerNames.isEmpty() && (queueDataMap = this.topicQueueTable.get(topic)) != null) {
                    for (String brokerName : brokerNames) {
                        QueueData removedQD = queueDataMap.remove(brokerName);
                        if (removedQD == null) continue;
                        log.info("deleteTopic, remove one broker's topic {} {} {}", new Object[]{brokerName, topic, removedQD});
                    }
                    if (queueDataMap.isEmpty()) {
                        log.info("deleteTopic, remove the topic all queue {} {}", (Object)clusterName, (Object)topic);
                        this.topicQueueTable.remove(topic);
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("deleteTopic Exception", (Throwable)e);
        }
    }

    public TopicList getAllTopicList() {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                topicList.getTopicList().addAll(this.topicQueueTable.keySet());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterBrokerResult registerBroker(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, Channel channel) {
        RegisterBrokerResult result = new RegisterBrokerResult();
        try {
            try {
                BrokerLiveInfo brokerLiveInfo;
                String masterAddr;
                BrokerLiveInfo prevBrokerLiveInfo;
                ConcurrentMap tcTable;
                this.lock.writeLock().lockInterruptibly();
                Set brokerNames = this.clusterAddrTable.computeIfAbsent(clusterName, k -> new HashSet());
                brokerNames.add(brokerName);
                boolean registerFirst = false;
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null == brokerData) {
                    registerFirst = true;
                    brokerData = new BrokerData(clusterName, brokerName, new HashMap());
                    this.brokerAddrTable.put(brokerName, brokerData);
                }
                HashMap brokerAddrsMap = brokerData.getBrokerAddrs();
                Iterator it = brokerAddrsMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry item = it.next();
                    if (null == brokerAddr || !brokerAddr.equals(item.getValue()) || brokerId == (Long)item.getKey()) continue;
                    log.debug("remove entry {} from brokerData", item);
                    it.remove();
                }
                String oldAddr = brokerData.getBrokerAddrs().put(brokerId, brokerAddr);
                if (0L == brokerId) {
                    log.info("cluster [{}] brokerName [{}] master address change from {} to {}", new Object[]{brokerData.getCluster(), brokerData.getBrokerName(), oldAddr, brokerAddr});
                }
                boolean bl = registerFirst = registerFirst || null == oldAddr;
                if (null != topicConfigWrapper && 0L == brokerId && (this.isBrokerTopicConfigChanged(brokerAddr, topicConfigWrapper.getDataVersion()) || registerFirst) && (tcTable = topicConfigWrapper.getTopicConfigTable()) != null) {
                    for (Map.Entry entry : tcTable.entrySet()) {
                        this.createAndUpdateQueueData(brokerName, (TopicConfig)entry.getValue());
                    }
                }
                if (null == (prevBrokerLiveInfo = this.brokerLiveTable.put(brokerAddr, new BrokerLiveInfo(System.currentTimeMillis(), topicConfigWrapper.getDataVersion(), channel, haServerAddr)))) {
                    log.info("new broker registered, {} HAServer: {}", (Object)brokerAddr, (Object)haServerAddr);
                }
                if (filterServerList != null) {
                    if (filterServerList.isEmpty()) {
                        this.filterServerTable.remove(brokerAddr);
                    } else {
                        this.filterServerTable.put(brokerAddr, filterServerList);
                    }
                }
                if (0L != brokerId && (masterAddr = (String)brokerData.getBrokerAddrs().get(0L)) != null && (brokerLiveInfo = this.brokerLiveTable.get(masterAddr)) != null) {
                    result.setHaServerAddr(brokerLiveInfo.getHaServerAddr());
                    result.setMasterAddr(masterAddr);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("registerBroker Exception", (Throwable)e);
        }
        return result;
    }

    public boolean isBrokerTopicConfigChanged(String brokerAddr, DataVersion dataVersion) {
        DataVersion prev = this.queryBrokerTopicConfig(brokerAddr);
        return null == prev || !prev.equals((Object)dataVersion);
    }

    public DataVersion queryBrokerTopicConfig(String brokerAddr) {
        BrokerLiveInfo prev = this.brokerLiveTable.get(brokerAddr);
        if (prev != null) {
            return prev.getDataVersion();
        }
        return null;
    }

    public void updateBrokerInfoUpdateTimestamp(String brokerAddr, long timeStamp) {
        BrokerLiveInfo prev = this.brokerLiveTable.get(brokerAddr);
        if (prev != null) {
            prev.setLastUpdateTimestamp(timeStamp);
        }
    }

    private void createAndUpdateQueueData(String brokerName, TopicConfig topicConfig) {
        QueueData queueData = new QueueData();
        queueData.setBrokerName(brokerName);
        queueData.setWriteQueueNums(topicConfig.getWriteQueueNums());
        queueData.setReadQueueNums(topicConfig.getReadQueueNums());
        queueData.setPerm(topicConfig.getPerm());
        queueData.setTopicSysFlag(topicConfig.getTopicSysFlag());
        Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topicConfig.getTopicName());
        if (null == queueDataMap) {
            queueDataMap = new HashMap<String, QueueData>();
            queueDataMap.put(queueData.getBrokerName(), queueData);
            this.topicQueueTable.put(topicConfig.getTopicName(), queueDataMap);
            log.info("new topic registered, {} {}", (Object)topicConfig.getTopicName(), (Object)queueData);
        } else {
            QueueData old = queueDataMap.put(queueData.getBrokerName(), queueData);
            if (old != null && !old.equals((Object)queueData)) {
                log.info("topic changed, {} OLD: {} NEW: {}", new Object[]{topicConfig.getTopicName(), old, queueData});
            }
        }
    }

    public int wipeWritePermOfBrokerByLock(String brokerName) {
        return this.operateWritePermOfBrokerByLock(brokerName, 205);
    }

    public int addWritePermOfBrokerByLock(String brokerName) {
        return this.operateWritePermOfBrokerByLock(brokerName, 327);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int operateWritePermOfBrokerByLock(String brokerName, int requestCode) {
        try {
            this.lock.writeLock().lockInterruptibly();
            int n = this.operateWritePermOfBroker(brokerName, requestCode);
            this.lock.writeLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                log.error("operateWritePermOfBrokerByLock Exception", (Throwable)e);
                return 0;
            }
        }
    }

    private int operateWritePermOfBroker(String brokerName, int requestCode) {
        int topicCnt = 0;
        for (Map.Entry<String, Map<String, QueueData>> entry : this.topicQueueTable.entrySet()) {
            QueueData qd;
            String topic = entry.getKey();
            Map<String, QueueData> queueDataMap = entry.getValue();
            if (queueDataMap == null || (qd = queueDataMap.get(brokerName)) == null) continue;
            int perm = qd.getPerm();
            switch (requestCode) {
                case 205: {
                    perm &= 0xFFFFFFFD;
                    break;
                }
                case 327: {
                    perm = 6;
                }
            }
            qd.setPerm(perm);
            ++topicCnt;
        }
        return topicCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBroker(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        try {
            try {
                this.lock.writeLock().lockInterruptibly();
                BrokerLiveInfo brokerLiveInfo = this.brokerLiveTable.remove(brokerAddr);
                log.info("unregisterBroker, remove from brokerLiveTable {}, {}", (Object)(brokerLiveInfo != null ? "OK" : "Failed"), (Object)brokerAddr);
                this.filterServerTable.remove(brokerAddr);
                boolean removeBrokerName = false;
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null != brokerData) {
                    String addr = (String)brokerData.getBrokerAddrs().remove(brokerId);
                    log.info("unregisterBroker, remove addr from brokerAddrTable {}, {}", (Object)(addr != null ? "OK" : "Failed"), (Object)brokerAddr);
                    if (brokerData.getBrokerAddrs().isEmpty()) {
                        this.brokerAddrTable.remove(brokerName);
                        log.info("unregisterBroker, remove name from brokerAddrTable OK, {}", (Object)brokerName);
                        removeBrokerName = true;
                    }
                }
                if (removeBrokerName) {
                    Set<String> nameSet = this.clusterAddrTable.get(clusterName);
                    if (nameSet != null) {
                        boolean removed = nameSet.remove(brokerName);
                        log.info("unregisterBroker, remove name from clusterAddrTable {}, {}", (Object)(removed ? "OK" : "Failed"), (Object)brokerName);
                        if (nameSet.isEmpty()) {
                            this.clusterAddrTable.remove(clusterName);
                            log.info("unregisterBroker, remove cluster from clusterAddrTable {}", (Object)clusterName);
                        }
                    }
                    this.removeTopicByBrokerName(brokerName);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("unregisterBroker Exception", (Throwable)e);
        }
    }

    private void removeTopicByBrokerName(String brokerName) {
        HashSet noBrokerRegisterTopic = new HashSet();
        this.topicQueueTable.forEach((topic, queueDataMap) -> {
            QueueData old = (QueueData)queueDataMap.remove(brokerName);
            if (old != null) {
                log.info("removeTopicByBrokerName, remove one broker's topic {} {}", topic, (Object)old);
            }
            if (queueDataMap.size() == 0) {
                noBrokerRegisterTopic.add(topic);
                log.info("removeTopicByBrokerName, remove the topic all queue {}", topic);
            }
        });
        noBrokerRegisterTopic.forEach(this.topicQueueTable::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicRouteData pickupTopicRouteData(String topic) {
        TopicRouteData topicRouteData = new TopicRouteData();
        boolean foundQueueData = false;
        boolean foundBrokerData = false;
        HashSet<String> brokerNameSet = new HashSet<String>();
        LinkedList<BrokerData> brokerDataList = new LinkedList<BrokerData>();
        topicRouteData.setBrokerDatas(brokerDataList);
        HashMap<String, List<String>> filterServerMap = new HashMap<String, List<String>>();
        topicRouteData.setFilterServerTable(filterServerMap);
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topic);
                if (queueDataMap != null) {
                    topicRouteData.setQueueDatas(new ArrayList<QueueData>(queueDataMap.values()));
                    foundQueueData = true;
                    brokerNameSet.addAll(queueDataMap.keySet());
                    for (String brokerName : brokerNameSet) {
                        BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                        if (null == brokerData) continue;
                        BrokerData brokerDataClone = new BrokerData(brokerData.getCluster(), brokerData.getBrokerName(), (HashMap)brokerData.getBrokerAddrs().clone());
                        brokerDataList.add(brokerDataClone);
                        foundBrokerData = true;
                        if (this.filterServerTable.isEmpty()) continue;
                        for (String brokerAddr : brokerDataClone.getBrokerAddrs().values()) {
                            List<String> filterServerList = this.filterServerTable.get(brokerAddr);
                            if (filterServerList == null) continue;
                            filterServerMap.put(brokerAddr, filterServerList);
                        }
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("pickupTopicRouteData Exception", (Throwable)e);
        }
        log.debug("pickupTopicRouteData {} {}", (Object)topic, (Object)topicRouteData);
        if (foundBrokerData && foundQueueData) {
            return topicRouteData;
        }
        return null;
    }

    public int scanNotActiveBroker() {
        int removeCount = 0;
        Iterator<Map.Entry<String, BrokerLiveInfo>> it = this.brokerLiveTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, BrokerLiveInfo> next = it.next();
            long last = next.getValue().getLastUpdateTimestamp();
            if (last + 120000L >= System.currentTimeMillis()) continue;
            RemotingUtil.closeChannel((Channel)next.getValue().getChannel());
            it.remove();
            log.warn("The broker channel expired, {} {}ms", (Object)next.getKey(), (Object)120000L);
            this.onChannelDestroy(next.getKey(), next.getValue().getChannel());
            ++removeCount;
        }
        return removeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelDestroy(String remoteAddr, Channel channel) {
        String brokerAddrFound = null;
        if (channel != null) {
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    for (Map.Entry<String, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
                        if (entry.getValue().getChannel() != channel) continue;
                        brokerAddrFound = entry.getKey();
                        break;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
        if (null == brokerAddrFound) {
            brokerAddrFound = remoteAddr;
        } else {
            log.info("the broker's channel destroyed, {}, clean it's data structure at once", (Object)brokerAddrFound);
        }
        if (brokerAddrFound != null && brokerAddrFound.length() > 0) {
            try {
                try {
                    this.lock.writeLock().lockInterruptibly();
                    this.brokerLiveTable.remove(brokerAddrFound);
                    this.filterServerTable.remove(brokerAddrFound);
                    String brokerNameFound = null;
                    boolean removeBrokerName = false;
                    Iterator<Map.Entry<String, BrokerData>> itBrokerAddrTable = this.brokerAddrTable.entrySet().iterator();
                    while (itBrokerAddrTable.hasNext() && null == brokerNameFound) {
                        BrokerData brokerData = itBrokerAddrTable.next().getValue();
                        Iterator it = brokerData.getBrokerAddrs().entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            Long brokerId = (Long)entry.getKey();
                            String brokerAddr = (String)entry.getValue();
                            if (!brokerAddr.equals(brokerAddrFound)) continue;
                            brokerNameFound = brokerData.getBrokerName();
                            it.remove();
                            log.info("remove brokerAddr[{}, {}] from brokerAddrTable, because channel destroyed", (Object)brokerId, (Object)brokerAddr);
                            break;
                        }
                        if (!brokerData.getBrokerAddrs().isEmpty()) continue;
                        removeBrokerName = true;
                        itBrokerAddrTable.remove();
                        log.info("remove brokerName[{}] from brokerAddrTable, because channel destroyed", (Object)brokerData.getBrokerName());
                    }
                    if (brokerNameFound != null && removeBrokerName) {
                        Iterator<Map.Entry<String, Set<String>>> it = this.clusterAddrTable.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<String, Set<String>> entry = it.next();
                            String clusterName = entry.getKey();
                            Set<String> brokerNames = entry.getValue();
                            boolean removed = brokerNames.remove(brokerNameFound);
                            if (!removed) continue;
                            log.info("remove brokerName[{}], clusterName[{}] from clusterAddrTable, because channel destroyed", brokerNameFound, (Object)clusterName);
                            if (!brokerNames.isEmpty()) break;
                            log.info("remove the clusterName[{}] from clusterAddrTable, because channel destroyed and no broker in this cluster", (Object)clusterName);
                            it.remove();
                            break;
                        }
                    }
                    if (removeBrokerName) {
                        String finalBrokerNameFound = brokerNameFound;
                        HashSet needRemoveTopic = new HashSet();
                        this.topicQueueTable.forEach((topic, queueDataMap) -> {
                            QueueData old = (QueueData)queueDataMap.remove(finalBrokerNameFound);
                            log.info("remove topic[{} {}], from topicQueueTable, because channel destroyed", topic, (Object)old);
                            if (queueDataMap.size() == 0) {
                                log.info("remove topic[{}] all queue, from topicQueueTable, because channel destroyed", topic);
                                needRemoveTopic.add(topic);
                            }
                        });
                        needRemoveTopic.forEach(this.topicQueueTable::remove);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
    }

    public void printAllPeriodically() {
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                log.info("--------------------------------------------------------");
                log.info("topicQueueTable SIZE: {}", (Object)this.topicQueueTable.size());
                for (Map.Entry<String, Map<String, QueueData>> entry : this.topicQueueTable.entrySet()) {
                    log.info("topicQueueTable Topic: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerAddrTable SIZE: {}", (Object)this.brokerAddrTable.size());
                for (Map.Entry<String, Map<String, QueueData>> entry : this.brokerAddrTable.entrySet()) {
                    log.info("brokerAddrTable brokerName: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerLiveTable SIZE: {}", (Object)this.brokerLiveTable.size());
                for (Map.Entry<String, Object> entry : this.brokerLiveTable.entrySet()) {
                    log.info("brokerLiveTable brokerAddr: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("clusterAddrTable SIZE: {}", (Object)this.clusterAddrTable.size());
                for (Map.Entry<String, Object> entry : this.clusterAddrTable.entrySet()) {
                    log.info("clusterAddrTable clusterName: {} {}", (Object)entry.getKey(), entry.getValue());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("printAllPeriodically Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getSystemTopicList() {
        TopicList topicList;
        block7: {
            topicList = new TopicList();
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    for (Map.Entry<String, Set<String>> entry : this.clusterAddrTable.entrySet()) {
                        topicList.getTopicList().add(entry.getKey());
                        topicList.getTopicList().addAll((Collection)entry.getValue());
                    }
                    if (this.brokerAddrTable == null || this.brokerAddrTable.isEmpty()) break block7;
                    Iterator<String> it = this.brokerAddrTable.keySet().iterator();
                    while (it.hasNext()) {
                        BrokerData bd = this.brokerAddrTable.get(it.next());
                        HashMap brokerAddrs = bd.getBrokerAddrs();
                        if (brokerAddrs == null || brokerAddrs.isEmpty()) continue;
                        Iterator it2 = brokerAddrs.keySet().iterator();
                        topicList.setBrokerAddr((String)brokerAddrs.get(it2.next()));
                        break;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("getAllTopicList Exception", (Throwable)e);
            }
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getTopicsByCluster(String cluster) {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                Set<String> brokerNameSet = this.clusterAddrTable.get(cluster);
                for (String brokerName : brokerNameSet) {
                    this.topicQueueTable.forEach((topic, queueDataMap) -> {
                        if (queueDataMap.containsKey(brokerName)) {
                            topicList.getTopicList().add(topic);
                        }
                    });
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList;
    }

    public TopicList getUnitTopics() {
        return this.topicQueueTableIter(qd -> TopicSysFlag.hasUnitFlag((int)qd.getTopicSysFlag()));
    }

    public TopicList getHasUnitSubTopicList() {
        return this.topicQueueTableIter(qd -> TopicSysFlag.hasUnitSubFlag((int)qd.getTopicSysFlag()));
    }

    public TopicList getHasUnitSubUnUnitTopicList() {
        return this.topicQueueTableIter(qd -> !TopicSysFlag.hasUnitFlag((int)qd.getTopicSysFlag()) && TopicSysFlag.hasUnitSubFlag((int)qd.getTopicSysFlag()));
    }

    private TopicList topicQueueTableIter(Predicate<QueueData> pickCondition) {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                this.topicQueueTable.forEach((topic, queueDataMap) -> {
                    block0: {
                        QueueData qd;
                        Iterator iterator = queueDataMap.values().iterator();
                        if (!iterator.hasNext() || !pickCondition.test(qd = (QueueData)iterator.next())) break block0;
                        topicList.getTopicList().add(topic);
                    }
                });
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList;
    }
}

