/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.tieredstore.TieredMessageFetcher;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.container.TieredContainerManager;
import org.apache.rocketmq.tieredstore.container.TieredMessageQueueContainer;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredStoreMetricsManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    private static String storageMedium;
    public static LongHistogram apiLatency;
    public static LongHistogram providerRpcLatency;
    public static LongHistogram uploadBytes;
    public static LongHistogram downloadBytes;
    public static ObservableLongGauge dispatchBehind;
    public static ObservableLongGauge dispatchLatency;
    public static LongCounter messagesDispatchTotal;
    public static LongCounter messagesOutTotal;
    public static LongCounter fallbackTotal;
    public static ObservableLongGauge cacheCount;
    public static ObservableLongGauge cacheBytes;
    public static LongCounter cacheAccess;
    public static LongCounter cacheHit;
    public static ObservableLongGauge storageSize;
    public static ObservableLongGauge storageMessageReserveTime;

    public static List<Pair<InstrumentSelector, View>> getMetricsView() {
        ArrayList<Pair<InstrumentSelector, View>> res = new ArrayList<Pair<InstrumentSelector, View>>();
        InstrumentSelector providerRpcLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_rpc_latency").build();
        InstrumentSelector rpcLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_api_latency").build();
        View rpcLatencyView = View.builder().setAggregation(Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 3.0, 5.0, 7.0, 10.0, 100.0, 200.0, 400.0, 600.0, 800.0, 1000.0, 1500.0, 3000.0))).setDescription("tiered_store_rpc_latency_view").build();
        InstrumentSelector uploadBufferSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_upload_bytes").build();
        InstrumentSelector downloadBufferSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_download_bytes").build();
        View bufferSizeView = View.builder().setAggregation(Aggregation.explicitBucketHistogram(Arrays.asList(1024.0, 10240.0, 102400.0, 1048576.0, 1.048576E7, 3.3554432E7, 5.24288E7, 1.048576E8))).setDescription("tiered_store_buffer_size_view").build();
        res.add(new Pair((Object)rpcLatencySelector, (Object)rpcLatencyView));
        res.add(new Pair((Object)providerRpcLatencySelector, (Object)rpcLatencyView));
        res.add(new Pair((Object)uploadBufferSizeSelector, (Object)bufferSizeView));
        res.add(new Pair((Object)downloadBufferSizeSelector, (Object)bufferSizeView));
        return res;
    }

    public static void setStorageMedium(String storageMedium) {
        TieredStoreMetricsManager.storageMedium = storageMedium;
    }

    public static void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, TieredMessageStoreConfig storeConfig, TieredMessageFetcher fetcher, MessageStore next) {
        TieredStoreMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        apiLatency = meter.histogramBuilder("rocketmq_tiered_store_api_latency").setDescription("Tiered store rpc latency").setUnit("milliseconds").ofLongs().build();
        providerRpcLatency = meter.histogramBuilder("rocketmq_tiered_store_provider_rpc_latency").setDescription("Tiered store rpc latency").setUnit("milliseconds").ofLongs().build();
        uploadBytes = meter.histogramBuilder("rocketmq_tiered_store_provider_upload_bytes").setDescription("Tiered store upload buffer size").setUnit("bytes").ofLongs().build();
        downloadBytes = meter.histogramBuilder("rocketmq_tiered_store_provider_download_bytes").setDescription("Tiered store download buffer size").setUnit("bytes").ofLongs().build();
        dispatchBehind = meter.gaugeBuilder("rocketmq_tiered_store_dispatch_behind").setDescription("Tiered store dispatch behind message count").ofLongs().buildWithCallback(measurement -> {
            for (TieredMessageQueueContainer container : TieredContainerManager.getInstance(storeConfig).getAllMQContainer()) {
                MessageQueue mq = container.getMessageQueue();
                long maxOffset = next.getMaxOffsetInQueue(mq.getTopic(), mq.getQueueId());
                long maxTimestamp = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), maxOffset - 1L);
                if (maxTimestamp > 0L && System.currentTimeMillis() - maxTimestamp > (long)storeConfig.getTieredStoreFileReservedTime() * 60L * 60L * 1000L) continue;
                Attributes commitLogAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                measurement.record(Math.max(maxOffset - container.getDispatchOffset(), 0L), commitLogAttributes);
                Attributes consumeQueueAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
                measurement.record(Math.max(maxOffset - container.getConsumeQueueMaxOffset(), 0L), consumeQueueAttributes);
            }
        });
        dispatchLatency = meter.gaugeBuilder("rocketmq_tiered_store_dispatch_latency").setDescription("Tiered store dispatch latency").setUnit("seconds").ofLongs().buildWithCallback(measurement -> {
            for (TieredMessageQueueContainer container : TieredContainerManager.getInstance(storeConfig).getAllMQContainer()) {
                MessageQueue mq = container.getMessageQueue();
                long maxOffset = next.getMaxOffsetInQueue(mq.getTopic(), mq.getQueueId());
                long maxTimestamp = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), maxOffset - 1L);
                if (maxTimestamp > 0L && System.currentTimeMillis() - maxTimestamp > (long)storeConfig.getTieredStoreFileReservedTime() * 60L * 60L * 1000L) continue;
                Attributes commitLogAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                long commitLogDispatchLatency = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), container.getDispatchOffset());
                if (maxOffset <= container.getDispatchOffset() || commitLogDispatchLatency < 0L) {
                    measurement.record(0L, commitLogAttributes);
                } else {
                    measurement.record(System.currentTimeMillis() - commitLogDispatchLatency, commitLogAttributes);
                }
                Attributes consumeQueueAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
                long consumeQueueDispatchOffset = container.getConsumeQueueMaxOffset();
                long consumeQueueDispatchLatency = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), consumeQueueDispatchOffset);
                if (maxOffset <= consumeQueueDispatchOffset || consumeQueueDispatchLatency < 0L) {
                    measurement.record(0L, consumeQueueAttributes);
                    continue;
                }
                measurement.record(System.currentTimeMillis() - consumeQueueDispatchLatency, consumeQueueAttributes);
            }
        });
        messagesDispatchTotal = meter.counterBuilder("rocketmq_tiered_store_messages_dispatch_total").setDescription("Total number of dispatch messages").build();
        messagesOutTotal = meter.counterBuilder("rocketmq_tiered_store_messages_out_total").setDescription("Total number of outgoing messages").build();
        fallbackTotal = meter.counterBuilder("rocketmq_tiered_store_get_message_fallback_total").setDescription("Total times of fallback to next store when getting message").build();
        cacheCount = meter.gaugeBuilder("rocketmq_tiered_store_read_ahead_cache_count").setDescription("Tiered store cache message count").ofLongs().buildWithCallback(measurement -> measurement.record(fetcher.getReadAheadCache().estimatedSize(), TieredStoreMetricsManager.newAttributesBuilder().build()));
        cacheBytes = meter.gaugeBuilder("rocketmq_tiered_store_read_ahead_cache_bytes").setDescription("Tiered store cache message bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            Optional eviction = fetcher.getReadAheadCache().policy().eviction();
            eviction.ifPresent(resultEviction -> measurement.record(resultEviction.weightedSize().orElse(0L), TieredStoreMetricsManager.newAttributesBuilder().build()));
        });
        cacheAccess = meter.counterBuilder("rocketmq_tiered_store_read_ahead_cache_access_total").setDescription("Tiered store cache access count").build();
        cacheHit = meter.counterBuilder("rocketmq_tiered_store_read_ahead_cache_hit_total").setDescription("Tiered store cache hit count").build();
        storageSize = meter.gaugeBuilder("rocketmq_storage_size").setDescription("Broker storage size").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            HashMap<String, Map> topicFileSizeMap = new HashMap<String, Map>();
            try {
                TieredMetadataStore metadataStore = TieredStoreUtil.getMetadataStore(storeConfig);
                metadataStore.iterateFileSegment(fileSegment -> {
                    Map subMap = topicFileSizeMap.computeIfAbsent(fileSegment.getQueue().getTopic(), k -> new HashMap());
                    TieredFileSegment.FileSegmentType fileSegmentType = TieredFileSegment.FileSegmentType.valueOf(fileSegment.getType());
                    Long size = subMap.computeIfAbsent(fileSegmentType, k -> 0L);
                    subMap.put(fileSegmentType, size + fileSegment.getSize());
                });
            }
            catch (Exception e) {
                logger.error("Failed to get storage size", (Throwable)e);
            }
            topicFileSizeMap.forEach((topic, subMap) -> subMap.forEach((fileSegmentType, size) -> {
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("file_type", fileSegmentType.name().toLowerCase()).build();
                measurement.record(size.longValue(), attributes);
            }));
        });
        storageMessageReserveTime = meter.gaugeBuilder("rocketmq_storage_message_reserve_time").setDescription("Broker message reserve time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            for (TieredMessageQueueContainer container : TieredContainerManager.getInstance(storeConfig).getAllMQContainer()) {
                long timestamp = container.getCommitLogBeginTimestamp();
                if (timestamp <= 0L) continue;
                MessageQueue mq = container.getMessageQueue();
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).build();
                measurement.record(System.currentTimeMillis() - timestamp, attributes);
            }
        });
    }

    public static AttributesBuilder newAttributesBuilder() {
        AttributesBuilder builder = attributesBuilderSupplier != null ? attributesBuilderSupplier.get() : Attributes.builder();
        return builder.put("storage_type", "tiered").put("storage_medium", storageMedium);
    }

    static {
        storageMedium = "blob";
        apiLatency = new NopLongHistogram();
        providerRpcLatency = new NopLongHistogram();
        uploadBytes = new NopLongHistogram();
        downloadBytes = new NopLongHistogram();
        dispatchBehind = new NopObservableLongGauge();
        dispatchLatency = new NopObservableLongGauge();
        messagesDispatchTotal = new NopLongCounter();
        messagesOutTotal = new NopLongCounter();
        fallbackTotal = new NopLongCounter();
        cacheCount = new NopObservableLongGauge();
        cacheBytes = new NopObservableLongGauge();
        cacheAccess = new NopLongCounter();
        cacheHit = new NopLongCounter();
        storageSize = new NopObservableLongGauge();
        storageMessageReserveTime = new NopObservableLongGauge();
    }
}

