/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.queue.BatchConsumeQueue;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.FileQueueLifeCycle;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;

public class ConsumeQueueStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final DefaultMessageStore messageStore;
    protected final MessageStoreConfig messageStoreConfig;
    protected final QueueOffsetOperator queueOffsetOperator = new QueueOffsetOperator();
    protected final ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> consumeQueueTable;

    public ConsumeQueueStore(DefaultMessageStore messageStore, MessageStoreConfig messageStoreConfig) {
        this.messageStore = messageStore;
        this.messageStoreConfig = messageStoreConfig;
        this.consumeQueueTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>>(32);
    }

    private FileQueueLifeCycle getLifeCycle(String topic, int queueId) {
        return this.findOrCreateConsumeQueue(topic, queueId);
    }

    public long rollNextFile(ConsumeQueueInterface consumeQueue, long offset) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.rollNextFile(offset);
    }

    public void correctMinOffset(ConsumeQueueInterface consumeQueue, long minCommitLogOffset) {
        consumeQueue.correctMinOffset(minCommitLogOffset);
    }

    public void putMessagePositionInfoWrapper(ConsumeQueueInterface consumeQueue, DispatchRequest request) {
        consumeQueue.putMessagePositionInfoWrapper(request);
    }

    public void putMessagePositionInfoWrapper(DispatchRequest dispatchRequest) {
        ConsumeQueueInterface cq = this.findOrCreateConsumeQueue(dispatchRequest.getTopic(), dispatchRequest.getQueueId());
        this.putMessagePositionInfoWrapper(cq, dispatchRequest);
    }

    public boolean load(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.load();
    }

    public boolean load() {
        boolean cqLoadResult = this.loadConsumeQueues(StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), CQType.SimpleCQ);
        boolean bcqLoadResult = this.loadConsumeQueues(StorePathConfigHelper.getStorePathBatchConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), CQType.BatchCQ);
        return cqLoadResult && bcqLoadResult;
    }

    private boolean loadConsumeQueues(String storePath, CQType cqType) {
        File dirLogic = new File(storePath);
        File[] fileTopicList = dirLogic.listFiles();
        if (fileTopicList != null) {
            for (File fileTopic : fileTopicList) {
                String topic = fileTopic.getName();
                File[] fileQueueIdList = fileTopic.listFiles();
                if (fileQueueIdList == null) continue;
                for (File fileQueueId : fileQueueIdList) {
                    int queueId;
                    try {
                        queueId = Integer.parseInt(fileQueueId.getName());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    this.queueTypeShouldBe(topic, cqType);
                    ConsumeQueueInterface logic = this.createConsumeQueueByType(cqType, topic, queueId, storePath);
                    this.putConsumeQueue(topic, queueId, logic);
                    if (this.load(logic)) continue;
                    return false;
                }
            }
        }
        log.info("load {} all over, OK", (Object)cqType);
        return true;
    }

    private ConsumeQueueInterface createConsumeQueueByType(CQType cqType, String topic, int queueId, String storePath) {
        if (Objects.equals(CQType.SimpleCQ, cqType)) {
            return new ConsumeQueue(topic, queueId, storePath, this.messageStoreConfig.getMappedFileSizeConsumeQueue(), this.messageStore);
        }
        if (Objects.equals(CQType.BatchCQ, cqType)) {
            return new BatchConsumeQueue(topic, queueId, storePath, this.messageStoreConfig.getMapperFileSizeBatchConsumeQueue(), this.messageStore);
        }
        throw new RuntimeException(String.format("queue type %s is not supported.", cqType.toString()));
    }

    private void queueTypeShouldBe(String topic, CQType cqTypeExpected) {
        Optional<TopicConfig> topicConfig = this.messageStore.getTopicConfig(topic);
        CQType cqTypeActual = QueueTypeUtils.getCQType(topicConfig);
        if (!Objects.equals(cqTypeExpected, cqTypeActual)) {
            throw new RuntimeException(String.format("The queue type of topic: %s should be %s, but is %s", topic, cqTypeExpected, cqTypeActual));
        }
    }

    private ExecutorService buildExecutorService(BlockingQueue<Runnable> blockingQueue, String threadNamePrefix) {
        return ThreadUtils.newThreadPoolExecutor((int)this.messageStore.getBrokerConfig().getRecoverThreadPoolNums(), (int)this.messageStore.getBrokerConfig().getRecoverThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, blockingQueue, (ThreadFactory)new ThreadFactoryImpl(threadNamePrefix));
    }

    public void recover(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.recover();
    }

    public void recover() {
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                this.recover(logic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverConcurrently() {
        int count = 0;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            count += maps.values().size();
        }
        CountDownLatch countDownLatch = new CountDownLatch(count);
        LinkedBlockingQueue<Runnable> recoverQueue = new LinkedBlockingQueue<Runnable>();
        ExecutorService executor = this.buildExecutorService(recoverQueue, "RecoverConsumeQueueThread_");
        ArrayList<FutureTask<Boolean>> result = new ArrayList<FutureTask<Boolean>>(count);
        try {
            for (ConcurrentMap concurrentMap : this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface logic : concurrentMap.values()) {
                    FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
                        boolean ret = true;
                        try {
                            logic.recover();
                        }
                        catch (Throwable e) {
                            ret = false;
                            log.error("Exception occurs while recover consume queue concurrently, topic={}, queueId={}", new Object[]{logic.getTopic(), logic.getQueueId(), e});
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                        return ret;
                    });
                    result.add(futureTask);
                    executor.submit(futureTask);
                }
            }
            countDownLatch.await();
            for (FutureTask futureTask : result) {
                if (futureTask == null || !futureTask.isDone() || ((Boolean)futureTask.get()).booleanValue()) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("Exception occurs while recover consume queue concurrently", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
        return true;
    }

    public long getMaxOffsetInConsumeQueue() {
        long maxPhysicOffset = -1L;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                if (logic.getMaxPhysicOffset() <= maxPhysicOffset) continue;
                maxPhysicOffset = logic.getMaxPhysicOffset();
            }
        }
        return maxPhysicOffset;
    }

    public void checkSelf(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.checkSelf();
    }

    public void checkSelf() {
        for (Map.Entry topicEntry : this.consumeQueueTable.entrySet()) {
            for (Map.Entry cqEntry : ((ConcurrentMap)topicEntry.getValue()).entrySet()) {
                this.checkSelf((ConsumeQueueInterface)cqEntry.getValue());
            }
        }
    }

    public boolean flush(ConsumeQueueInterface consumeQueue, int flushLeastPages) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.flush(flushLeastPages);
    }

    public void destroy(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.destroy();
    }

    public int deleteExpiredFile(ConsumeQueueInterface consumeQueue, long minCommitLogPos) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.deleteExpiredFile(minCommitLogPos);
    }

    public void truncateDirtyLogicFiles(ConsumeQueueInterface consumeQueue, long phyOffset) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.truncateDirtyLogicFiles(phyOffset);
    }

    public void swapMap(ConsumeQueueInterface consumeQueue, int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.swapMap(reserveNum, forceSwapIntervalMs, normalSwapIntervalMs);
    }

    public void cleanSwappedMap(ConsumeQueueInterface consumeQueue, long forceCleanSwapIntervalMs) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.cleanSwappedMap(forceCleanSwapIntervalMs);
    }

    public boolean isFirstFileAvailable(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.isFirstFileAvailable();
    }

    public boolean isFirstFileExist(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.isFirstFileExist();
    }

    public ConsumeQueueInterface findOrCreateConsumeQueue(String topic, int queueId) {
        return this.doFindOrCreateConsumeQueue(topic, queueId);
    }

    private ConsumeQueueInterface doFindOrCreateConsumeQueue(String topic, int queueId) {
        ConsumeQueueInterface logic;
        ConcurrentMap<Integer, BatchConsumeQueue> map = (ConcurrentHashMap<Integer, BatchConsumeQueue>)this.consumeQueueTable.get(topic);
        if (null == map) {
            ConcurrentHashMap<Integer, BatchConsumeQueue> newMap = new ConcurrentHashMap<Integer, BatchConsumeQueue>(128);
            ConcurrentMap oldMap = this.consumeQueueTable.putIfAbsent(topic, newMap);
            map = oldMap != null ? oldMap : newMap;
        }
        if ((logic = (ConsumeQueueInterface)map.get(queueId)) != null) {
            return logic;
        }
        Optional<TopicConfig> topicConfig = this.messageStore.getTopicConfig(topic);
        ConsumeQueueInterface newLogic = Objects.equals(CQType.BatchCQ, QueueTypeUtils.getCQType(topicConfig)) ? new BatchConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathBatchConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), this.messageStoreConfig.getMapperFileSizeBatchConsumeQueue(), this.messageStore) : new ConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), this.messageStoreConfig.getMappedFileSizeConsumeQueue(), this.messageStore);
        ConsumeQueueInterface oldLogic = map.putIfAbsent(queueId, (BatchConsumeQueue)newLogic);
        logic = oldLogic != null ? oldLogic : newLogic;
        return logic;
    }

    public Long getMaxOffset(String topic, int queueId) {
        return this.queueOffsetOperator.currentQueueOffset(topic + "-" + queueId);
    }

    public void setTopicQueueTable(ConcurrentMap<String, Long> topicQueueTable) {
        this.queueOffsetOperator.setTopicQueueTable(topicQueueTable);
        this.queueOffsetOperator.setLmqTopicQueueTable(topicQueueTable);
    }

    public ConcurrentMap getTopicQueueTable() {
        return this.queueOffsetOperator.getTopicQueueTable();
    }

    public void setBatchTopicQueueTable(ConcurrentMap<String, Long> batchTopicQueueTable) {
        this.queueOffsetOperator.setBatchTopicQueueTable(batchTopicQueueTable);
    }

    public void assignQueueOffset(MessageExtBrokerInner msg) {
        ConsumeQueueInterface consumeQueue = this.findOrCreateConsumeQueue(msg.getTopic(), msg.getQueueId());
        consumeQueue.assignQueueOffset(this.queueOffsetOperator, msg);
    }

    public void increaseQueueOffset(MessageExtBrokerInner msg, short messageNum) {
        ConsumeQueueInterface consumeQueue = this.findOrCreateConsumeQueue(msg.getTopic(), msg.getQueueId());
        consumeQueue.increaseQueueOffset(this.queueOffsetOperator, msg, messageNum);
    }

    public void updateQueueOffset(String topic, int queueId, long offset) {
        String topicQueueKey = topic + "-" + queueId;
        this.queueOffsetOperator.updateQueueOffset(topicQueueKey, offset);
    }

    public void removeTopicQueueTable(String topic, Integer queueId) {
        this.queueOffsetOperator.remove(topic, queueId);
    }

    public ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> getConsumeQueueTable() {
        return this.consumeQueueTable;
    }

    private void putConsumeQueue(String topic, int queueId, ConsumeQueueInterface consumeQueue) {
        ConcurrentHashMap<Integer, ConsumeQueueInterface> map = (ConcurrentHashMap<Integer, ConsumeQueueInterface>)this.consumeQueueTable.get(topic);
        if (null == map) {
            map = new ConcurrentHashMap<Integer, ConsumeQueueInterface>();
            map.put(queueId, consumeQueue);
            this.consumeQueueTable.put(topic, map);
        } else {
            map.put(queueId, consumeQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverOffsetTable(long minPhyOffset) {
        ConcurrentHashMap<String, Long> cqOffsetTable = new ConcurrentHashMap<String, Long>(1024);
        ConcurrentHashMap<String, Long> bcqOffsetTable = new ConcurrentHashMap<String, Long>(1024);
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                String key = logic.getTopic() + "-" + logic.getQueueId();
                long maxOffsetInQueue = logic.getMaxOffsetInQueue();
                if (Objects.equals(CQType.BatchCQ, logic.getCQType())) {
                    bcqOffsetTable.put(key, maxOffsetInQueue);
                } else {
                    cqOffsetTable.put(key, maxOffsetInQueue);
                }
                this.correctMinOffset(logic, minPhyOffset);
            }
        }
        if (this.messageStoreConfig.isDuplicationEnable()) {
            long startReadOffset;
            SelectMappedBufferResult lastBuffer = null;
            long l = startReadOffset = this.messageStore.getCommitLog().getConfirmOffset() == -1L ? 0L : this.messageStore.getCommitLog().getConfirmOffset();
            while ((lastBuffer = this.messageStore.selectOneMessageByOffset(startReadOffset)) != null) {
                try {
                    if (lastBuffer.getStartOffset() > startReadOffset) {
                        startReadOffset = lastBuffer.getStartOffset();
                        continue;
                    }
                    ByteBuffer bb = lastBuffer.getByteBuffer();
                    int magicCode = bb.getInt(bb.position() + 4);
                    if (magicCode == -875286124) {
                        startReadOffset += (long)bb.getInt(bb.position());
                        continue;
                    }
                    if (magicCode != -626843481) {
                        throw new RuntimeException("Unknown magicCode: " + magicCode);
                    }
                    lastBuffer.getByteBuffer().mark();
                    DispatchRequest dispatchRequest = this.messageStore.getCommitLog().checkMessageAndReturnSize(lastBuffer.getByteBuffer(), true, true, true);
                    if (!dispatchRequest.isSuccess()) break;
                    lastBuffer.getByteBuffer().reset();
                    MessageExt msg = MessageDecoder.decode((ByteBuffer)lastBuffer.getByteBuffer(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    if (msg == null) break;
                    String key = msg.getTopic() + "-" + msg.getQueueId();
                    cqOffsetTable.put(key, msg.getQueueOffset() + 1L);
                    startReadOffset += (long)msg.getStoreSize();
                }
                finally {
                    if (lastBuffer != null) {
                        lastBuffer.release();
                    }
                }
            }
        }
        this.setTopicQueueTable(cqOffsetTable);
        this.setBatchTopicQueueTable(bcqOffsetTable);
    }

    public void destroy() {
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                this.destroy(logic);
            }
        }
    }

    public void cleanExpired(long minCommitLogOffset) {
        Iterator it = this.consumeQueueTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String topic = (String)next.getKey();
            if (TopicValidator.isSystemTopic((String)topic)) continue;
            ConcurrentMap queueTable = (ConcurrentMap)next.getValue();
            Iterator itQT = queueTable.entrySet().iterator();
            while (itQT.hasNext()) {
                Map.Entry nextQT = itQT.next();
                long maxCLOffsetInConsumeQueue = ((ConsumeQueueInterface)nextQT.getValue()).getLastOffset();
                if (maxCLOffsetInConsumeQueue == -1L) {
                    log.warn("maybe ConsumeQueue was created just now. topic={} queueId={} maxPhysicOffset={} minLogicOffset={}.", new Object[]{((ConsumeQueueInterface)nextQT.getValue()).getTopic(), ((ConsumeQueueInterface)nextQT.getValue()).getQueueId(), ((ConsumeQueueInterface)nextQT.getValue()).getMaxPhysicOffset(), ((ConsumeQueueInterface)nextQT.getValue()).getMinLogicOffset()});
                    continue;
                }
                if (maxCLOffsetInConsumeQueue >= minCommitLogOffset) continue;
                log.info("cleanExpiredConsumerQueue: {} {} consumer queue destroyed, minCommitLogOffset: {} maxCLOffsetInConsumeQueue: {}", new Object[]{topic, nextQT.getKey(), minCommitLogOffset, maxCLOffsetInConsumeQueue});
                this.removeTopicQueueTable(((ConsumeQueueInterface)nextQT.getValue()).getTopic(), ((ConsumeQueueInterface)nextQT.getValue()).getQueueId());
                this.destroy((ConsumeQueueInterface)nextQT.getValue());
                itQT.remove();
            }
            if (!queueTable.isEmpty()) continue;
            log.info("cleanExpiredConsumerQueue: {},topic destroyed", (Object)topic);
            it.remove();
        }
    }

    public void truncateDirty(long phyOffset) {
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                this.truncateDirtyLogicFiles(logic, phyOffset);
            }
        }
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                totalSize += logic.getTotalSize();
            }
        }
        return totalSize;
    }
}

