/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.IOException;
import java.util.Map;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.config.RocksDBConfigManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.rocksdb.Statistics;

public abstract class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    protected RocksDBConfigManager rocksDBConfigManager;

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (null == jsonString || jsonString.length() == 0) {
                return this.loadBak();
            }
            this.decode(jsonString);
            log.info("load " + fileName + " OK");
            return true;
        }
        catch (Exception e) {
            log.error("load " + fileName + " failed, and try to load backup file", (Throwable)e);
            return this.loadBak();
        }
    }

    private boolean loadBak() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName + ".bak");
            if (jsonString != null && jsonString.length() > 0) {
                this.decode(jsonString);
                log.info("load " + fileName + " OK");
                return true;
            }
        }
        catch (Exception e) {
            log.error("load " + fileName + " Failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized <T> void persist(String topicName, T t) {
        this.persist();
    }

    public synchronized <T> void persist(Map<String, T> m) {
        this.persist();
    }

    public synchronized void persist() {
        String jsonString = this.encode(true);
        if (jsonString != null) {
            String fileName = this.configFilePath();
            try {
                MixAll.string2File(jsonString, fileName);
            }
            catch (IOException e) {
                log.error("persist file " + fileName + " exception", (Throwable)e);
            }
        }
    }

    protected void decode0(byte[] key, byte[] body) {
    }

    public boolean stop() {
        return true;
    }

    public abstract String configFilePath();

    public abstract String encode();

    public abstract String encode(boolean var1);

    public abstract void decode(String var1);

    public Statistics getStatistics() {
        return this.rocksDBConfigManager == null ? null : this.rocksDBConfigManager.getStatistics();
    }
}

