/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.producer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.Encoding;
import apache.rocketmq.v2.MessageType;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.SendResultEntry;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcProxyException;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcValidator;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.QueueSelector;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;

public class SendMessageActivity
extends AbstractMessingActivity {
    public SendMessageActivity(MessagingProcessor messagingProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
    }

    public CompletableFuture<SendMessageResponse> sendMessage(ProxyContext ctx, SendMessageRequest request) {
        CompletionStage<Object> future = new CompletableFuture<SendMessageResponse>();
        try {
            if (request.getMessagesCount() <= 0) {
                throw new GrpcProxyException(Code.MESSAGE_CORRUPTED, "no message to send");
            }
            List messageList = request.getMessagesList();
            apache.rocketmq.v2.Message message = (apache.rocketmq.v2.Message)messageList.get(0);
            Resource topic = message.getTopic();
            this.validateTopic(topic);
            future = this.messagingProcessor.sendMessage(ctx, new SendMessageQueueSelector(request), topic.getName(), this.buildSysFlag(message), this.buildMessage(ctx, request.getMessagesList(), topic)).thenApply(result -> this.convertToSendMessageResponse(ctx, request, (List<SendResult>)result));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    protected List<Message> buildMessage(ProxyContext context, List<apache.rocketmq.v2.Message> protoMessageList, Resource topic) {
        String topicName = topic.getName();
        ArrayList<Message> messageExtList = new ArrayList<Message>();
        for (apache.rocketmq.v2.Message protoMessage : protoMessageList) {
            if (!protoMessage.getTopic().equals((Object)topic)) {
                throw new GrpcProxyException(Code.MESSAGE_CORRUPTED, "topic in message is not same");
            }
            messageExtList.add(this.buildMessage(context, protoMessage, topicName));
        }
        return messageExtList;
    }

    protected Message buildMessage(ProxyContext context, apache.rocketmq.v2.Message protoMessage, String producerGroup) {
        String topicName = protoMessage.getTopic().getName();
        this.validateMessageBodySize(protoMessage.getBody());
        Message messageExt = new Message();
        messageExt.setTopic(topicName);
        messageExt.setBody(protoMessage.getBody().toByteArray());
        Map<String, String> messageProperty = this.buildMessageProperty(context, protoMessage, producerGroup);
        MessageAccessor.setProperties((Message)messageExt, messageProperty);
        return messageExt;
    }

    protected int buildSysFlag(apache.rocketmq.v2.Message protoMessage) {
        MessageType messageType;
        int sysFlag = 0;
        Encoding bodyEncoding = protoMessage.getSystemProperties().getBodyEncoding();
        if (bodyEncoding.equals((Object)Encoding.GZIP)) {
            sysFlag |= 1;
        }
        if ((messageType = protoMessage.getSystemProperties().getMessageType()).equals((Object)MessageType.TRANSACTION)) {
            sysFlag |= 4;
        }
        return sysFlag;
    }

    protected void validateMessageBodySize(ByteString body) {
        int max = ConfigurationManager.getProxyConfig().getMaxMessageSize();
        if (max <= 0) {
            return;
        }
        if (body.size() > max) {
            throw new GrpcProxyException(Code.MESSAGE_BODY_TOO_LARGE, "message body cannot exceed the max " + max);
        }
    }

    protected void validateMessageKey(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_KEY, "key cannot be the char sequence of whitespace");
            }
            if (GrpcValidator.getInstance().containControlCharacter(key)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_KEY, "key cannot contain control character");
            }
        }
    }

    protected void validateMessageGroup(String messageGroup) {
        if (StringUtils.isNotEmpty((CharSequence)messageGroup)) {
            if (StringUtils.isBlank((CharSequence)messageGroup)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_GROUP, "message group cannot be the char sequence of whitespace");
            }
            int maxSize = ConfigurationManager.getProxyConfig().getMaxMessageGroupSize();
            if (maxSize <= 0) {
                return;
            }
            if (messageGroup.getBytes(StandardCharsets.UTF_8).length >= maxSize) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_GROUP, "message group exceed the max size " + maxSize);
            }
            if (GrpcValidator.getInstance().containControlCharacter(messageGroup)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_GROUP, "message group cannot contain control character");
            }
        }
    }

    protected void validateDelayTime(long deliveryTimestampMs) {
        long maxDelay = ConfigurationManager.getProxyConfig().getMaxDelayTimeMills();
        if (maxDelay <= 0L) {
            return;
        }
        if (deliveryTimestampMs - System.currentTimeMillis() > maxDelay) {
            throw new GrpcProxyException(Code.ILLEGAL_DELIVERY_TIME, "the max delay time of message is too large, max is " + maxDelay);
        }
    }

    protected void validateTransactionRecoverySecond(long transactionRecoverySecond) {
        long maxTransactionRecoverySecond = ConfigurationManager.getProxyConfig().getMaxTransactionRecoverySecond();
        if (maxTransactionRecoverySecond <= 0L) {
            return;
        }
        if (transactionRecoverySecond > maxTransactionRecoverySecond) {
            throw new GrpcProxyException(Code.BAD_REQUEST, "the max transaction recovery time of message is too large, max is " + maxTransactionRecoverySecond);
        }
    }

    protected Map<String, String> buildMessageProperty(ProxyContext context, apache.rocketmq.v2.Message message, String producerGroup) {
        Timestamp bornTimestamp;
        String bornHost;
        String traceContext;
        long userPropertySize = 0L;
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        Message messageWithHeader = new Message();
        Map userProperties = message.getUserPropertiesMap();
        if (userProperties.size() > config.getUserPropertyMaxNum()) {
            throw new GrpcProxyException(Code.MESSAGE_PROPERTIES_TOO_LARGE, "too many user properties, max is " + config.getUserPropertyMaxNum());
        }
        for (Map.Entry userPropertiesEntry : userProperties.entrySet()) {
            if (MessageConst.STRING_HASH_SET.contains(userPropertiesEntry.getKey())) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_PROPERTY_KEY, "property is used by system: " + (String)userPropertiesEntry.getKey());
            }
            if (GrpcValidator.getInstance().containControlCharacter((String)userPropertiesEntry.getKey())) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_PROPERTY_KEY, "the key of property cannot contain control character");
            }
            if (GrpcValidator.getInstance().containControlCharacter((String)userPropertiesEntry.getValue())) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_PROPERTY_KEY, "the value of property cannot contain control character");
            }
            userPropertySize += (long)((String)userPropertiesEntry.getKey()).getBytes(StandardCharsets.UTF_8).length;
            userPropertySize += (long)((String)userPropertiesEntry.getValue()).getBytes(StandardCharsets.UTF_8).length;
        }
        MessageAccessor.setProperties((Message)messageWithHeader, (Map)Maps.newHashMap((Map)userProperties));
        String tag = message.getSystemProperties().getTag();
        GrpcValidator.getInstance().validateTag(tag);
        messageWithHeader.setTags(tag);
        userPropertySize += (long)tag.getBytes(StandardCharsets.UTF_8).length;
        ProtocolStringList keysList = message.getSystemProperties().getKeysList();
        for (String key : keysList) {
            this.validateMessageKey(key);
            userPropertySize += (long)key.getBytes(StandardCharsets.UTF_8).length;
        }
        if (keysList.size() > 0) {
            messageWithHeader.setKeys((Collection)keysList);
        }
        if (userPropertySize > (long)config.getMaxUserPropertySize()) {
            throw new GrpcProxyException(Code.MESSAGE_PROPERTIES_TOO_LARGE, "the total size of user property is too large, max is " + config.getMaxUserPropertySize());
        }
        String messageId = message.getSystemProperties().getMessageId();
        if (StringUtils.isBlank((CharSequence)messageId)) {
            throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_ID, "message id cannot be empty");
        }
        MessageAccessor.putProperty((Message)messageWithHeader, (String)"UNIQ_KEY", (String)messageId);
        MessageType messageType = message.getSystemProperties().getMessageType();
        if (messageType.equals((Object)MessageType.TRANSACTION)) {
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"TRAN_MSG", (String)"true");
            if (message.getSystemProperties().hasOrphanedTransactionRecoveryDuration()) {
                long transactionRecoverySecond = Durations.toSeconds((Duration)message.getSystemProperties().getOrphanedTransactionRecoveryDuration());
                this.validateTransactionRecoverySecond(transactionRecoverySecond);
                MessageAccessor.putProperty((Message)messageWithHeader, (String)"CHECK_IMMUNITY_TIME_IN_SECONDS", (String)String.valueOf(transactionRecoverySecond));
            }
        }
        this.fillDelayMessageProperty(message, messageWithHeader);
        int reconsumeTimes = message.getSystemProperties().getDeliveryAttempt();
        MessageAccessor.setReconsumeTime((Message)messageWithHeader, (String)String.valueOf(reconsumeTimes));
        MessageAccessor.putProperty((Message)messageWithHeader, (String)"PGROUP", (String)producerGroup);
        String messageGroup = message.getSystemProperties().getMessageGroup();
        if (StringUtils.isNotEmpty((CharSequence)messageGroup)) {
            this.validateMessageGroup(messageGroup);
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"__SHARDINGKEY", (String)messageGroup);
        }
        if (!(traceContext = message.getSystemProperties().getTraceContext()).isEmpty()) {
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"TRACE_CONTEXT", (String)traceContext);
        }
        if (StringUtils.isBlank((CharSequence)(bornHost = message.getSystemProperties().getBornHost()))) {
            bornHost = context.getRemoteAddress();
        }
        if (StringUtils.isNotBlank((CharSequence)bornHost)) {
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"__BORNHOST", (String)bornHost);
        }
        if (Timestamps.isValid((Timestamp)(bornTimestamp = message.getSystemProperties().getBornTimestamp()))) {
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"BORN_TIMESTAMP", (String)String.valueOf(Timestamps.toMillis((Timestamp)bornTimestamp)));
        }
        return messageWithHeader.getProperties();
    }

    protected void fillDelayMessageProperty(apache.rocketmq.v2.Message message, Message messageWithHeader) {
        if (message.getSystemProperties().hasDeliveryTimestamp()) {
            Timestamp deliveryTimestamp = message.getSystemProperties().getDeliveryTimestamp();
            long deliveryTimestampMs = Timestamps.toMillis((Timestamp)deliveryTimestamp);
            this.validateDelayTime(deliveryTimestampMs);
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            if (config.isUseDelayLevel()) {
                int delayLevel = config.computeDelayLevel(deliveryTimestampMs);
                MessageAccessor.putProperty((Message)messageWithHeader, (String)"DELAY", (String)String.valueOf(delayLevel));
            }
            String timestampString = String.valueOf(deliveryTimestampMs);
            MessageAccessor.putProperty((Message)messageWithHeader, (String)"TIMER_DELIVER_MS", (String)timestampString);
        }
    }

    protected SendMessageResponse convertToSendMessageResponse(ProxyContext ctx, SendMessageRequest request, List<SendResult> resultList) {
        SendMessageResponse.Builder builder = SendMessageResponse.newBuilder();
        HashSet<Code> responseCodes = new HashSet<Code>();
        for (SendResult result : resultList) {
            SendResultEntry resultEntry;
            switch (result.getSendStatus()) {
                case FLUSH_DISK_TIMEOUT: {
                    resultEntry = SendResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.MASTER_PERSISTENCE_TIMEOUT, "send message failed, sendStatus=" + result.getSendStatus())).build();
                    break;
                }
                case FLUSH_SLAVE_TIMEOUT: {
                    resultEntry = SendResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.SLAVE_PERSISTENCE_TIMEOUT, "send message failed, sendStatus=" + result.getSendStatus())).build();
                    break;
                }
                case SLAVE_NOT_AVAILABLE: {
                    resultEntry = SendResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.HA_NOT_AVAILABLE, "send message failed, sendStatus=" + result.getSendStatus())).build();
                    break;
                }
                case SEND_OK: {
                    resultEntry = SendResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).setOffset(result.getQueueOffset()).setMessageId(StringUtils.defaultString((String)result.getMsgId())).setTransactionId(StringUtils.defaultString((String)result.getTransactionId())).build();
                    break;
                }
                default: {
                    resultEntry = SendResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.INTERNAL_SERVER_ERROR, "send message failed, sendStatus=" + result.getSendStatus())).build();
                }
            }
            builder.addEntries(resultEntry);
            responseCodes.add(resultEntry.getStatus().getCode());
        }
        if (responseCodes.size() > 1) {
            builder.setStatus(ResponseBuilder.getInstance().buildStatus(Code.MULTIPLE_RESULTS, Code.MULTIPLE_RESULTS.name()));
        } else if (responseCodes.size() == 1) {
            Code code = (Code)responseCodes.stream().findAny().get();
            builder.setStatus(ResponseBuilder.getInstance().buildStatus(code, code.name()));
        } else {
            builder.setStatus(ResponseBuilder.getInstance().buildStatus(Code.INTERNAL_SERVER_ERROR, "send status is empty"));
        }
        return builder.build();
    }

    protected static class SendMessageQueueSelector
    implements QueueSelector {
        private final SendMessageRequest request;

        public SendMessageQueueSelector(SendMessageRequest request) {
            this.request = request;
        }

        @Override
        public AddressableMessageQueue select(ProxyContext ctx, MessageQueueView messageQueueView) {
            try {
                AddressableMessageQueue targetMessageQueue;
                apache.rocketmq.v2.Message message = this.request.getMessages(0);
                String shardingKey = null;
                if (this.request.getMessagesCount() == 1) {
                    shardingKey = message.getSystemProperties().getMessageGroup();
                }
                if (StringUtils.isNotEmpty(shardingKey)) {
                    List<AddressableMessageQueue> writeQueues = messageQueueView.getWriteSelector().getQueues();
                    int bucket = Hashing.consistentHash((long)shardingKey.hashCode(), (int)writeQueues.size());
                    targetMessageQueue = writeQueues.get(bucket);
                } else {
                    targetMessageQueue = messageQueueView.getWriteSelector().selectOneByPipeline(false);
                }
                return targetMessageQueue;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

