/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.metrics.MetricsExporterType;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.ProxyMode;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigFile;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.MetricCollectorMode;

public class ProxyConfig
implements ConfigFile {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    public static final String DEFAULT_CONFIG_FILE_NAME = "rmq-proxy.json";
    private static final int PROCESSOR_NUMBER = Runtime.getRuntime().availableProcessors();
    private static final String DEFAULT_CLUSTER_NAME = "DefaultCluster";
    private static String localHostName;
    private String rocketMQClusterName = "DefaultCluster";
    private String proxyClusterName = "DefaultCluster";
    private String proxyName = StringUtils.isEmpty((CharSequence)localHostName) ? "DEFAULT_PROXY" : localHostName;
    private String localServeAddr = "";
    private String heartbeatSyncerTopicClusterName = "";
    private int heartbeatSyncerThreadPoolNums = 4;
    private int heartbeatSyncerThreadPoolQueueCapacity = 100;
    private String heartbeatSyncerTopicName = "DefaultHeartBeatSyncerTopic";
    private boolean enablePrintJstack = true;
    private long printJstackInMillis = Duration.ofSeconds(60L).toMillis();
    private long printThreadPoolStatusInMillis = Duration.ofSeconds(3L).toMillis();
    private String namesrvAddr = System.getProperty("rocketmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String namesrvDomain = "";
    private String namesrvDomainSubgroup = "";
    private boolean tlsTestModeEnable = true;
    private String tlsKeyPath = ConfigurationManager.getProxyHome() + "/conf/tls/rocketmq.key";
    private String tlsCertPath = ConfigurationManager.getProxyHome() + "/conf/tls/rocketmq.crt";
    private String proxyMode = ProxyMode.CLUSTER.name();
    private Integer grpcServerPort = 8081;
    private long grpcShutdownTimeSeconds = 30L;
    private int grpcBossLoopNum = 1;
    private int grpcWorkerLoopNum = PROCESSOR_NUMBER * 2;
    private boolean enableGrpcEpoll = false;
    private int grpcThreadPoolNums = 16 + PROCESSOR_NUMBER * 2;
    private int grpcThreadPoolQueueCapacity = 100000;
    private String brokerConfigPath = ConfigurationManager.getProxyHome() + "/conf/broker.conf";
    private int grpcMaxInboundMessageSize = 0x8200000;
    private int maxMessageSize = 0x400000;
    private boolean enableMessageBodyEmptyCheck = true;
    private int maxUserPropertySize = 16384;
    private int userPropertyMaxNum = 128;
    private int maxMessageGroupSize = 64;
    private long defaultInvisibleTimeMills = Duration.ofSeconds(60L).toMillis();
    private long minInvisibleTimeMillsForRecv = Duration.ofSeconds(10L).toMillis();
    private long maxInvisibleTimeMills = Duration.ofHours(12L).toMillis();
    private long maxDelayTimeMills = Duration.ofDays(1L).toMillis();
    private long maxTransactionRecoverySecond = Duration.ofHours(1L).getSeconds();
    private boolean enableTopicMessageTypeCheck = true;
    private int grpcClientProducerMaxAttempts = 3;
    private long grpcClientProducerBackoffInitialMillis = 10L;
    private long grpcClientProducerBackoffMaxMillis = 1000L;
    private int grpcClientProducerBackoffMultiplier = 2;
    private long grpcClientConsumerMinLongPollingTimeoutMillis = Duration.ofSeconds(5L).toMillis();
    private long grpcClientConsumerMaxLongPollingTimeoutMillis = Duration.ofSeconds(20L).toMillis();
    private int grpcClientConsumerLongPollingBatchSize = 32;
    private long grpcClientIdleTimeMills = Duration.ofSeconds(120L).toMillis();
    private int channelExpiredInSeconds = 60;
    private int contextExpiredInSeconds = 30;
    private int rocketmqMQClientNum = 6;
    private long grpcProxyRelayRequestTimeoutInSeconds = 5L;
    private int grpcProducerThreadPoolNums = PROCESSOR_NUMBER;
    private int grpcProducerThreadQueueCapacity = 10000;
    private int grpcConsumerThreadPoolNums = PROCESSOR_NUMBER;
    private int grpcConsumerThreadQueueCapacity = 10000;
    private int grpcRouteThreadPoolNums = PROCESSOR_NUMBER;
    private int grpcRouteThreadQueueCapacity = 10000;
    private int grpcClientManagerThreadPoolNums = PROCESSOR_NUMBER;
    private int grpcClientManagerThreadQueueCapacity = 10000;
    private int grpcTransactionThreadPoolNums = PROCESSOR_NUMBER;
    private int grpcTransactionThreadQueueCapacity = 10000;
    private int producerProcessorThreadPoolNums = PROCESSOR_NUMBER;
    private int producerProcessorThreadPoolQueueCapacity = 10000;
    private int consumerProcessorThreadPoolNums = PROCESSOR_NUMBER;
    private int consumerProcessorThreadPoolQueueCapacity = 10000;
    private boolean useEndpointPortFromRequest = false;
    private int topicRouteServiceCacheExpiredSeconds = 300;
    private int topicRouteServiceCacheRefreshSeconds = 20;
    private int topicRouteServiceCacheMaxNum = 20000;
    private int topicRouteServiceThreadPoolNums = PROCESSOR_NUMBER;
    private int topicRouteServiceThreadPoolQueueCapacity = 5000;
    private int topicConfigCacheExpiredSeconds = 300;
    private int topicConfigCacheRefreshSeconds = 20;
    private int topicConfigCacheMaxNum = 20000;
    private int subscriptionGroupConfigCacheExpiredSeconds = 300;
    private int subscriptionGroupConfigCacheRefreshSeconds = 20;
    private int subscriptionGroupConfigCacheMaxNum = 20000;
    private int userCacheExpiredSeconds = 300;
    private int userCacheRefreshSeconds = 20;
    private int userCacheMaxNum = 20000;
    private int aclCacheExpiredSeconds = 300;
    private int aclCacheRefreshSeconds = 20;
    private int aclCacheMaxNum = 20000;
    private int metadataThreadPoolNums = 3;
    private int metadataThreadPoolQueueCapacity = 100000;
    private int transactionHeartbeatThreadPoolNums = 20;
    private int transactionHeartbeatThreadPoolQueueCapacity = 200;
    private int transactionHeartbeatPeriodSecond = 20;
    private int transactionHeartbeatBatchNum = 100;
    private long transactionDataExpireScanPeriodMillis = Duration.ofSeconds(10L).toMillis();
    private long transactionDataMaxWaitClearMillis = Duration.ofSeconds(30L).toMillis();
    private long transactionDataExpireMillis = Duration.ofSeconds(30L).toMillis();
    private int transactionDataMaxNum = 15;
    private long longPollingReserveTimeInMillis = 100L;
    private long invisibleTimeMillisWhenClear = 1000L;
    private boolean enableProxyAutoRenew = true;
    private int maxRenewRetryTimes = 3;
    private int renewThreadPoolNums = 2;
    private int renewMaxThreadPoolNums = 4;
    private int renewThreadPoolQueueCapacity = 300;
    private long lockTimeoutMsInHandleGroup = TimeUnit.SECONDS.toMillis(3L);
    private long renewAheadTimeMillis = TimeUnit.SECONDS.toMillis(10L);
    private long renewMaxTimeMillis = TimeUnit.HOURS.toMillis(3L);
    private long renewSchedulePeriodMillis = TimeUnit.SECONDS.toMillis(5L);
    private boolean enableACL = false;
    private boolean enableAclRpcHookForClusterMode = false;
    private boolean useDelayLevel = false;
    private String messageDelayLevel = "1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h";
    private transient ConcurrentSkipListMap<Integer, Long> delayLevelTable = new ConcurrentSkipListMap();
    private String metricCollectorMode = MetricCollectorMode.OFF.getModeString();
    private String metricCollectorAddress = "";
    private String regionId = "";
    private boolean traceOn = false;
    private MetricsExporterType metricsExporterType = MetricsExporterType.DISABLE;
    private String metricsGrpcExporterTarget = "";
    private String metricsGrpcExporterHeader = "";
    private long metricGrpcExporterTimeOutInMills = 3000L;
    private long metricGrpcExporterIntervalInMills = 60000L;
    private long metricLoggingExporterIntervalInMills = 10000L;
    private int metricsPromExporterPort = 5557;
    private String metricsPromExporterHost = "";
    private String metricsLabel = "";
    private boolean metricsInDelta = false;
    private long channelExpiredTimeout = 120000L;
    private boolean enableRemotingLocalProxyGrpc = true;
    private int localProxyConnectTimeoutMs = 3000;
    private String remotingAccessAddr = "";
    private int remotingListenPort = 8080;
    private boolean sendLatencyEnable = false;
    private boolean startDetectorEnable = false;
    private int detectTimeout = 200;
    private int detectInterval = 2000;
    private int remotingHeartbeatThreadPoolNums = 2 * PROCESSOR_NUMBER;
    private int remotingTopicRouteThreadPoolNums = 2 * PROCESSOR_NUMBER;
    private int remotingSendMessageThreadPoolNums = 4 * PROCESSOR_NUMBER;
    private int remotingPullMessageThreadPoolNums = 4 * PROCESSOR_NUMBER;
    private int remotingUpdateOffsetThreadPoolNums = 4 * PROCESSOR_NUMBER;
    private int remotingDefaultThreadPoolNums = 4 * PROCESSOR_NUMBER;
    private int remotingHeartbeatThreadPoolQueueCapacity = 50000;
    private int remotingTopicRouteThreadPoolQueueCapacity = 50000;
    private int remotingSendThreadPoolQueueCapacity = 10000;
    private int remotingPullThreadPoolQueueCapacity = 50000;
    private int remotingUpdateOffsetThreadPoolQueueCapacity = 10000;
    private int remotingDefaultThreadPoolQueueCapacity = 50000;
    private long remotingWaitTimeMillsInSendQueue = 3000L;
    private long remotingWaitTimeMillsInPullQueue = 5000L;
    private long remotingWaitTimeMillsInHeartbeatQueue = 31000L;
    private long remotingWaitTimeMillsInUpdateOffsetQueue = 3000L;
    private long remotingWaitTimeMillsInTopicRouteQueue = 3000L;
    private long remotingWaitTimeMillsInDefaultQueue = 3000L;
    private boolean enableBatchAck = false;

    @Override
    public void initData() {
        this.parseDelayLevel();
        if (StringUtils.isEmpty((CharSequence)this.localServeAddr)) {
            this.localServeAddr = NetworkUtil.getLocalAddress();
        }
        if (StringUtils.isBlank((CharSequence)this.localServeAddr)) {
            throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "get local serve ip failed");
        }
        if (StringUtils.isBlank((CharSequence)this.remotingAccessAddr)) {
            this.remotingAccessAddr = this.localServeAddr;
        }
        if (StringUtils.isBlank((CharSequence)this.heartbeatSyncerTopicClusterName)) {
            this.heartbeatSyncerTopicClusterName = this.rocketMQClusterName;
        }
    }

    public int computeDelayLevel(long timeMillis) {
        long intervalMillis = timeMillis - System.currentTimeMillis();
        List sortedLevels = this.delayLevelTable.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue)).collect(Collectors.toList());
        for (Map.Entry entry : sortedLevels) {
            if ((Long)entry.getValue() <= intervalMillis) continue;
            return (Integer)entry.getKey();
        }
        return (Integer)((Map.Entry)sortedLevels.get(sortedLevels.size() - 1)).getKey();
    }

    public void parseDelayLevel() {
        this.delayLevelTable = new ConcurrentSkipListMap();
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
            }
        }
        catch (Exception e) {
            log.error("parse delay level failed. messageDelayLevel:{}", (Object)this.messageDelayLevel, (Object)e);
        }
    }

    public String getRocketMQClusterName() {
        return this.rocketMQClusterName;
    }

    public void setRocketMQClusterName(String rocketMQClusterName) {
        this.rocketMQClusterName = rocketMQClusterName;
    }

    public String getProxyClusterName() {
        return this.proxyClusterName;
    }

    public void setProxyClusterName(String proxyClusterName) {
        this.proxyClusterName = proxyClusterName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public String getLocalServeAddr() {
        return this.localServeAddr;
    }

    public void setLocalServeAddr(String localServeAddr) {
        this.localServeAddr = localServeAddr;
    }

    public String getHeartbeatSyncerTopicClusterName() {
        return this.heartbeatSyncerTopicClusterName;
    }

    public void setHeartbeatSyncerTopicClusterName(String heartbeatSyncerTopicClusterName) {
        this.heartbeatSyncerTopicClusterName = heartbeatSyncerTopicClusterName;
    }

    public int getHeartbeatSyncerThreadPoolNums() {
        return this.heartbeatSyncerThreadPoolNums;
    }

    public void setHeartbeatSyncerThreadPoolNums(int heartbeatSyncerThreadPoolNums) {
        this.heartbeatSyncerThreadPoolNums = heartbeatSyncerThreadPoolNums;
    }

    public int getHeartbeatSyncerThreadPoolQueueCapacity() {
        return this.heartbeatSyncerThreadPoolQueueCapacity;
    }

    public void setHeartbeatSyncerThreadPoolQueueCapacity(int heartbeatSyncerThreadPoolQueueCapacity) {
        this.heartbeatSyncerThreadPoolQueueCapacity = heartbeatSyncerThreadPoolQueueCapacity;
    }

    public String getHeartbeatSyncerTopicName() {
        return this.heartbeatSyncerTopicName;
    }

    public void setHeartbeatSyncerTopicName(String heartbeatSyncerTopicName) {
        this.heartbeatSyncerTopicName = heartbeatSyncerTopicName;
    }

    public boolean isEnablePrintJstack() {
        return this.enablePrintJstack;
    }

    public void setEnablePrintJstack(boolean enablePrintJstack) {
        this.enablePrintJstack = enablePrintJstack;
    }

    public long getPrintJstackInMillis() {
        return this.printJstackInMillis;
    }

    public void setPrintJstackInMillis(long printJstackInMillis) {
        this.printJstackInMillis = printJstackInMillis;
    }

    public long getPrintThreadPoolStatusInMillis() {
        return this.printThreadPoolStatusInMillis;
    }

    public void setPrintThreadPoolStatusInMillis(long printThreadPoolStatusInMillis) {
        this.printThreadPoolStatusInMillis = printThreadPoolStatusInMillis;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getNamesrvDomain() {
        return this.namesrvDomain;
    }

    public void setNamesrvDomain(String namesrvDomain) {
        this.namesrvDomain = namesrvDomain;
    }

    public String getNamesrvDomainSubgroup() {
        return this.namesrvDomainSubgroup;
    }

    public void setNamesrvDomainSubgroup(String namesrvDomainSubgroup) {
        this.namesrvDomainSubgroup = namesrvDomainSubgroup;
    }

    public String getProxyMode() {
        return this.proxyMode;
    }

    public void setProxyMode(String proxyMode) {
        this.proxyMode = proxyMode;
    }

    public Integer getGrpcServerPort() {
        return this.grpcServerPort;
    }

    public void setGrpcServerPort(Integer grpcServerPort) {
        this.grpcServerPort = grpcServerPort;
    }

    public long getGrpcShutdownTimeSeconds() {
        return this.grpcShutdownTimeSeconds;
    }

    public void setGrpcShutdownTimeSeconds(long grpcShutdownTimeSeconds) {
        this.grpcShutdownTimeSeconds = grpcShutdownTimeSeconds;
    }

    public boolean isUseEndpointPortFromRequest() {
        return this.useEndpointPortFromRequest;
    }

    public void setUseEndpointPortFromRequest(boolean useEndpointPortFromRequest) {
        this.useEndpointPortFromRequest = useEndpointPortFromRequest;
    }

    public boolean isTlsTestModeEnable() {
        return this.tlsTestModeEnable;
    }

    public void setTlsTestModeEnable(boolean tlsTestModeEnable) {
        this.tlsTestModeEnable = tlsTestModeEnable;
    }

    public String getTlsKeyPath() {
        return this.tlsKeyPath;
    }

    public void setTlsKeyPath(String tlsKeyPath) {
        this.tlsKeyPath = tlsKeyPath;
    }

    public String getTlsCertPath() {
        return this.tlsCertPath;
    }

    public void setTlsCertPath(String tlsCertPath) {
        this.tlsCertPath = tlsCertPath;
    }

    public int getGrpcBossLoopNum() {
        return this.grpcBossLoopNum;
    }

    public void setGrpcBossLoopNum(int grpcBossLoopNum) {
        this.grpcBossLoopNum = grpcBossLoopNum;
    }

    public int getGrpcWorkerLoopNum() {
        return this.grpcWorkerLoopNum;
    }

    public void setGrpcWorkerLoopNum(int grpcWorkerLoopNum) {
        this.grpcWorkerLoopNum = grpcWorkerLoopNum;
    }

    public boolean isEnableGrpcEpoll() {
        return this.enableGrpcEpoll;
    }

    public void setEnableGrpcEpoll(boolean enableGrpcEpoll) {
        this.enableGrpcEpoll = enableGrpcEpoll;
    }

    public int getGrpcThreadPoolNums() {
        return this.grpcThreadPoolNums;
    }

    public void setGrpcThreadPoolNums(int grpcThreadPoolNums) {
        this.grpcThreadPoolNums = grpcThreadPoolNums;
    }

    public int getGrpcThreadPoolQueueCapacity() {
        return this.grpcThreadPoolQueueCapacity;
    }

    public void setGrpcThreadPoolQueueCapacity(int grpcThreadPoolQueueCapacity) {
        this.grpcThreadPoolQueueCapacity = grpcThreadPoolQueueCapacity;
    }

    public String getBrokerConfigPath() {
        return this.brokerConfigPath;
    }

    public void setBrokerConfigPath(String brokerConfigPath) {
        this.brokerConfigPath = brokerConfigPath;
    }

    public int getGrpcMaxInboundMessageSize() {
        return this.grpcMaxInboundMessageSize;
    }

    public void setGrpcMaxInboundMessageSize(int grpcMaxInboundMessageSize) {
        this.grpcMaxInboundMessageSize = grpcMaxInboundMessageSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxUserPropertySize() {
        return this.maxUserPropertySize;
    }

    public void setMaxUserPropertySize(int maxUserPropertySize) {
        this.maxUserPropertySize = maxUserPropertySize;
    }

    public int getUserPropertyMaxNum() {
        return this.userPropertyMaxNum;
    }

    public void setUserPropertyMaxNum(int userPropertyMaxNum) {
        this.userPropertyMaxNum = userPropertyMaxNum;
    }

    public int getMaxMessageGroupSize() {
        return this.maxMessageGroupSize;
    }

    public void setMaxMessageGroupSize(int maxMessageGroupSize) {
        this.maxMessageGroupSize = maxMessageGroupSize;
    }

    public long getMinInvisibleTimeMillsForRecv() {
        return this.minInvisibleTimeMillsForRecv;
    }

    public void setMinInvisibleTimeMillsForRecv(long minInvisibleTimeMillsForRecv) {
        this.minInvisibleTimeMillsForRecv = minInvisibleTimeMillsForRecv;
    }

    public long getDefaultInvisibleTimeMills() {
        return this.defaultInvisibleTimeMills;
    }

    public void setDefaultInvisibleTimeMills(long defaultInvisibleTimeMills) {
        this.defaultInvisibleTimeMills = defaultInvisibleTimeMills;
    }

    public long getMaxInvisibleTimeMills() {
        return this.maxInvisibleTimeMills;
    }

    public void setMaxInvisibleTimeMills(long maxInvisibleTimeMills) {
        this.maxInvisibleTimeMills = maxInvisibleTimeMills;
    }

    public long getMaxDelayTimeMills() {
        return this.maxDelayTimeMills;
    }

    public void setMaxDelayTimeMills(long maxDelayTimeMills) {
        this.maxDelayTimeMills = maxDelayTimeMills;
    }

    public long getMaxTransactionRecoverySecond() {
        return this.maxTransactionRecoverySecond;
    }

    public void setMaxTransactionRecoverySecond(long maxTransactionRecoverySecond) {
        this.maxTransactionRecoverySecond = maxTransactionRecoverySecond;
    }

    public int getGrpcClientProducerMaxAttempts() {
        return this.grpcClientProducerMaxAttempts;
    }

    public void setGrpcClientProducerMaxAttempts(int grpcClientProducerMaxAttempts) {
        this.grpcClientProducerMaxAttempts = grpcClientProducerMaxAttempts;
    }

    public long getGrpcClientProducerBackoffInitialMillis() {
        return this.grpcClientProducerBackoffInitialMillis;
    }

    public void setGrpcClientProducerBackoffInitialMillis(long grpcClientProducerBackoffInitialMillis) {
        this.grpcClientProducerBackoffInitialMillis = grpcClientProducerBackoffInitialMillis;
    }

    public long getGrpcClientProducerBackoffMaxMillis() {
        return this.grpcClientProducerBackoffMaxMillis;
    }

    public void setGrpcClientProducerBackoffMaxMillis(long grpcClientProducerBackoffMaxMillis) {
        this.grpcClientProducerBackoffMaxMillis = grpcClientProducerBackoffMaxMillis;
    }

    public int getGrpcClientProducerBackoffMultiplier() {
        return this.grpcClientProducerBackoffMultiplier;
    }

    public void setGrpcClientProducerBackoffMultiplier(int grpcClientProducerBackoffMultiplier) {
        this.grpcClientProducerBackoffMultiplier = grpcClientProducerBackoffMultiplier;
    }

    public long getGrpcClientConsumerMinLongPollingTimeoutMillis() {
        return this.grpcClientConsumerMinLongPollingTimeoutMillis;
    }

    public void setGrpcClientConsumerMinLongPollingTimeoutMillis(long grpcClientConsumerMinLongPollingTimeoutMillis) {
        this.grpcClientConsumerMinLongPollingTimeoutMillis = grpcClientConsumerMinLongPollingTimeoutMillis;
    }

    public long getGrpcClientConsumerMaxLongPollingTimeoutMillis() {
        return this.grpcClientConsumerMaxLongPollingTimeoutMillis;
    }

    public void setGrpcClientConsumerMaxLongPollingTimeoutMillis(long grpcClientConsumerMaxLongPollingTimeoutMillis) {
        this.grpcClientConsumerMaxLongPollingTimeoutMillis = grpcClientConsumerMaxLongPollingTimeoutMillis;
    }

    public int getGrpcClientConsumerLongPollingBatchSize() {
        return this.grpcClientConsumerLongPollingBatchSize;
    }

    public void setGrpcClientConsumerLongPollingBatchSize(int grpcClientConsumerLongPollingBatchSize) {
        this.grpcClientConsumerLongPollingBatchSize = grpcClientConsumerLongPollingBatchSize;
    }

    public int getChannelExpiredInSeconds() {
        return this.channelExpiredInSeconds;
    }

    public void setChannelExpiredInSeconds(int channelExpiredInSeconds) {
        this.channelExpiredInSeconds = channelExpiredInSeconds;
    }

    public int getContextExpiredInSeconds() {
        return this.contextExpiredInSeconds;
    }

    public void setContextExpiredInSeconds(int contextExpiredInSeconds) {
        this.contextExpiredInSeconds = contextExpiredInSeconds;
    }

    public int getRocketmqMQClientNum() {
        return this.rocketmqMQClientNum;
    }

    public void setRocketmqMQClientNum(int rocketmqMQClientNum) {
        this.rocketmqMQClientNum = rocketmqMQClientNum;
    }

    public long getGrpcProxyRelayRequestTimeoutInSeconds() {
        return this.grpcProxyRelayRequestTimeoutInSeconds;
    }

    public void setGrpcProxyRelayRequestTimeoutInSeconds(long grpcProxyRelayRequestTimeoutInSeconds) {
        this.grpcProxyRelayRequestTimeoutInSeconds = grpcProxyRelayRequestTimeoutInSeconds;
    }

    public int getGrpcProducerThreadPoolNums() {
        return this.grpcProducerThreadPoolNums;
    }

    public void setGrpcProducerThreadPoolNums(int grpcProducerThreadPoolNums) {
        this.grpcProducerThreadPoolNums = grpcProducerThreadPoolNums;
    }

    public int getGrpcProducerThreadQueueCapacity() {
        return this.grpcProducerThreadQueueCapacity;
    }

    public void setGrpcProducerThreadQueueCapacity(int grpcProducerThreadQueueCapacity) {
        this.grpcProducerThreadQueueCapacity = grpcProducerThreadQueueCapacity;
    }

    public int getGrpcConsumerThreadPoolNums() {
        return this.grpcConsumerThreadPoolNums;
    }

    public void setGrpcConsumerThreadPoolNums(int grpcConsumerThreadPoolNums) {
        this.grpcConsumerThreadPoolNums = grpcConsumerThreadPoolNums;
    }

    public int getGrpcConsumerThreadQueueCapacity() {
        return this.grpcConsumerThreadQueueCapacity;
    }

    public void setGrpcConsumerThreadQueueCapacity(int grpcConsumerThreadQueueCapacity) {
        this.grpcConsumerThreadQueueCapacity = grpcConsumerThreadQueueCapacity;
    }

    public int getGrpcRouteThreadPoolNums() {
        return this.grpcRouteThreadPoolNums;
    }

    public void setGrpcRouteThreadPoolNums(int grpcRouteThreadPoolNums) {
        this.grpcRouteThreadPoolNums = grpcRouteThreadPoolNums;
    }

    public int getGrpcRouteThreadQueueCapacity() {
        return this.grpcRouteThreadQueueCapacity;
    }

    public void setGrpcRouteThreadQueueCapacity(int grpcRouteThreadQueueCapacity) {
        this.grpcRouteThreadQueueCapacity = grpcRouteThreadQueueCapacity;
    }

    public int getGrpcClientManagerThreadPoolNums() {
        return this.grpcClientManagerThreadPoolNums;
    }

    public void setGrpcClientManagerThreadPoolNums(int grpcClientManagerThreadPoolNums) {
        this.grpcClientManagerThreadPoolNums = grpcClientManagerThreadPoolNums;
    }

    public int getGrpcClientManagerThreadQueueCapacity() {
        return this.grpcClientManagerThreadQueueCapacity;
    }

    public void setGrpcClientManagerThreadQueueCapacity(int grpcClientManagerThreadQueueCapacity) {
        this.grpcClientManagerThreadQueueCapacity = grpcClientManagerThreadQueueCapacity;
    }

    public int getGrpcTransactionThreadPoolNums() {
        return this.grpcTransactionThreadPoolNums;
    }

    public void setGrpcTransactionThreadPoolNums(int grpcTransactionThreadPoolNums) {
        this.grpcTransactionThreadPoolNums = grpcTransactionThreadPoolNums;
    }

    public int getGrpcTransactionThreadQueueCapacity() {
        return this.grpcTransactionThreadQueueCapacity;
    }

    public void setGrpcTransactionThreadQueueCapacity(int grpcTransactionThreadQueueCapacity) {
        this.grpcTransactionThreadQueueCapacity = grpcTransactionThreadQueueCapacity;
    }

    public int getProducerProcessorThreadPoolNums() {
        return this.producerProcessorThreadPoolNums;
    }

    public void setProducerProcessorThreadPoolNums(int producerProcessorThreadPoolNums) {
        this.producerProcessorThreadPoolNums = producerProcessorThreadPoolNums;
    }

    public int getProducerProcessorThreadPoolQueueCapacity() {
        return this.producerProcessorThreadPoolQueueCapacity;
    }

    public void setProducerProcessorThreadPoolQueueCapacity(int producerProcessorThreadPoolQueueCapacity) {
        this.producerProcessorThreadPoolQueueCapacity = producerProcessorThreadPoolQueueCapacity;
    }

    public int getConsumerProcessorThreadPoolNums() {
        return this.consumerProcessorThreadPoolNums;
    }

    public void setConsumerProcessorThreadPoolNums(int consumerProcessorThreadPoolNums) {
        this.consumerProcessorThreadPoolNums = consumerProcessorThreadPoolNums;
    }

    public int getConsumerProcessorThreadPoolQueueCapacity() {
        return this.consumerProcessorThreadPoolQueueCapacity;
    }

    public void setConsumerProcessorThreadPoolQueueCapacity(int consumerProcessorThreadPoolQueueCapacity) {
        this.consumerProcessorThreadPoolQueueCapacity = consumerProcessorThreadPoolQueueCapacity;
    }

    public int getTopicRouteServiceCacheExpiredSeconds() {
        return this.topicRouteServiceCacheExpiredSeconds;
    }

    public void setTopicRouteServiceCacheExpiredSeconds(int topicRouteServiceCacheExpiredSeconds) {
        this.topicRouteServiceCacheExpiredSeconds = topicRouteServiceCacheExpiredSeconds;
    }

    public int getTopicRouteServiceCacheRefreshSeconds() {
        return this.topicRouteServiceCacheRefreshSeconds;
    }

    public void setTopicRouteServiceCacheRefreshSeconds(int topicRouteServiceCacheRefreshSeconds) {
        this.topicRouteServiceCacheRefreshSeconds = topicRouteServiceCacheRefreshSeconds;
    }

    public int getTopicRouteServiceCacheMaxNum() {
        return this.topicRouteServiceCacheMaxNum;
    }

    public void setTopicRouteServiceCacheMaxNum(int topicRouteServiceCacheMaxNum) {
        this.topicRouteServiceCacheMaxNum = topicRouteServiceCacheMaxNum;
    }

    public int getTopicRouteServiceThreadPoolNums() {
        return this.topicRouteServiceThreadPoolNums;
    }

    public void setTopicRouteServiceThreadPoolNums(int topicRouteServiceThreadPoolNums) {
        this.topicRouteServiceThreadPoolNums = topicRouteServiceThreadPoolNums;
    }

    public int getTopicRouteServiceThreadPoolQueueCapacity() {
        return this.topicRouteServiceThreadPoolQueueCapacity;
    }

    public void setTopicRouteServiceThreadPoolQueueCapacity(int topicRouteServiceThreadPoolQueueCapacity) {
        this.topicRouteServiceThreadPoolQueueCapacity = topicRouteServiceThreadPoolQueueCapacity;
    }

    public int getTopicConfigCacheRefreshSeconds() {
        return this.topicConfigCacheRefreshSeconds;
    }

    public void setTopicConfigCacheRefreshSeconds(int topicConfigCacheRefreshSeconds) {
        this.topicConfigCacheRefreshSeconds = topicConfigCacheRefreshSeconds;
    }

    public int getTopicConfigCacheExpiredSeconds() {
        return this.topicConfigCacheExpiredSeconds;
    }

    public void setTopicConfigCacheExpiredSeconds(int topicConfigCacheExpiredSeconds) {
        this.topicConfigCacheExpiredSeconds = topicConfigCacheExpiredSeconds;
    }

    public int getTopicConfigCacheMaxNum() {
        return this.topicConfigCacheMaxNum;
    }

    public void setTopicConfigCacheMaxNum(int topicConfigCacheMaxNum) {
        this.topicConfigCacheMaxNum = topicConfigCacheMaxNum;
    }

    public int getSubscriptionGroupConfigCacheRefreshSeconds() {
        return this.subscriptionGroupConfigCacheRefreshSeconds;
    }

    public void setSubscriptionGroupConfigCacheRefreshSeconds(int subscriptionGroupConfigCacheRefreshSeconds) {
        this.subscriptionGroupConfigCacheRefreshSeconds = subscriptionGroupConfigCacheRefreshSeconds;
    }

    public int getSubscriptionGroupConfigCacheExpiredSeconds() {
        return this.subscriptionGroupConfigCacheExpiredSeconds;
    }

    public void setSubscriptionGroupConfigCacheExpiredSeconds(int subscriptionGroupConfigCacheExpiredSeconds) {
        this.subscriptionGroupConfigCacheExpiredSeconds = subscriptionGroupConfigCacheExpiredSeconds;
    }

    public int getSubscriptionGroupConfigCacheMaxNum() {
        return this.subscriptionGroupConfigCacheMaxNum;
    }

    public void setSubscriptionGroupConfigCacheMaxNum(int subscriptionGroupConfigCacheMaxNum) {
        this.subscriptionGroupConfigCacheMaxNum = subscriptionGroupConfigCacheMaxNum;
    }

    public int getUserCacheExpiredSeconds() {
        return this.userCacheExpiredSeconds;
    }

    public void setUserCacheExpiredSeconds(int userCacheExpiredSeconds) {
        this.userCacheExpiredSeconds = userCacheExpiredSeconds;
    }

    public int getUserCacheRefreshSeconds() {
        return this.userCacheRefreshSeconds;
    }

    public void setUserCacheRefreshSeconds(int userCacheRefreshSeconds) {
        this.userCacheRefreshSeconds = userCacheRefreshSeconds;
    }

    public int getUserCacheMaxNum() {
        return this.userCacheMaxNum;
    }

    public void setUserCacheMaxNum(int userCacheMaxNum) {
        this.userCacheMaxNum = userCacheMaxNum;
    }

    public int getAclCacheExpiredSeconds() {
        return this.aclCacheExpiredSeconds;
    }

    public void setAclCacheExpiredSeconds(int aclCacheExpiredSeconds) {
        this.aclCacheExpiredSeconds = aclCacheExpiredSeconds;
    }

    public int getAclCacheRefreshSeconds() {
        return this.aclCacheRefreshSeconds;
    }

    public void setAclCacheRefreshSeconds(int aclCacheRefreshSeconds) {
        this.aclCacheRefreshSeconds = aclCacheRefreshSeconds;
    }

    public int getAclCacheMaxNum() {
        return this.aclCacheMaxNum;
    }

    public void setAclCacheMaxNum(int aclCacheMaxNum) {
        this.aclCacheMaxNum = aclCacheMaxNum;
    }

    public int getMetadataThreadPoolNums() {
        return this.metadataThreadPoolNums;
    }

    public void setMetadataThreadPoolNums(int metadataThreadPoolNums) {
        this.metadataThreadPoolNums = metadataThreadPoolNums;
    }

    public int getMetadataThreadPoolQueueCapacity() {
        return this.metadataThreadPoolQueueCapacity;
    }

    public void setMetadataThreadPoolQueueCapacity(int metadataThreadPoolQueueCapacity) {
        this.metadataThreadPoolQueueCapacity = metadataThreadPoolQueueCapacity;
    }

    public int getTransactionHeartbeatThreadPoolNums() {
        return this.transactionHeartbeatThreadPoolNums;
    }

    public void setTransactionHeartbeatThreadPoolNums(int transactionHeartbeatThreadPoolNums) {
        this.transactionHeartbeatThreadPoolNums = transactionHeartbeatThreadPoolNums;
    }

    public int getTransactionHeartbeatThreadPoolQueueCapacity() {
        return this.transactionHeartbeatThreadPoolQueueCapacity;
    }

    public void setTransactionHeartbeatThreadPoolQueueCapacity(int transactionHeartbeatThreadPoolQueueCapacity) {
        this.transactionHeartbeatThreadPoolQueueCapacity = transactionHeartbeatThreadPoolQueueCapacity;
    }

    public int getTransactionHeartbeatPeriodSecond() {
        return this.transactionHeartbeatPeriodSecond;
    }

    public void setTransactionHeartbeatPeriodSecond(int transactionHeartbeatPeriodSecond) {
        this.transactionHeartbeatPeriodSecond = transactionHeartbeatPeriodSecond;
    }

    public int getTransactionHeartbeatBatchNum() {
        return this.transactionHeartbeatBatchNum;
    }

    public void setTransactionHeartbeatBatchNum(int transactionHeartbeatBatchNum) {
        this.transactionHeartbeatBatchNum = transactionHeartbeatBatchNum;
    }

    public long getTransactionDataExpireScanPeriodMillis() {
        return this.transactionDataExpireScanPeriodMillis;
    }

    public void setTransactionDataExpireScanPeriodMillis(long transactionDataExpireScanPeriodMillis) {
        this.transactionDataExpireScanPeriodMillis = transactionDataExpireScanPeriodMillis;
    }

    public long getTransactionDataMaxWaitClearMillis() {
        return this.transactionDataMaxWaitClearMillis;
    }

    public void setTransactionDataMaxWaitClearMillis(long transactionDataMaxWaitClearMillis) {
        this.transactionDataMaxWaitClearMillis = transactionDataMaxWaitClearMillis;
    }

    public long getTransactionDataExpireMillis() {
        return this.transactionDataExpireMillis;
    }

    public void setTransactionDataExpireMillis(long transactionDataExpireMillis) {
        this.transactionDataExpireMillis = transactionDataExpireMillis;
    }

    public int getTransactionDataMaxNum() {
        return this.transactionDataMaxNum;
    }

    public void setTransactionDataMaxNum(int transactionDataMaxNum) {
        this.transactionDataMaxNum = transactionDataMaxNum;
    }

    public long getLongPollingReserveTimeInMillis() {
        return this.longPollingReserveTimeInMillis;
    }

    public void setLongPollingReserveTimeInMillis(long longPollingReserveTimeInMillis) {
        this.longPollingReserveTimeInMillis = longPollingReserveTimeInMillis;
    }

    public boolean isEnableACL() {
        return this.enableACL;
    }

    public void setEnableACL(boolean enableACL) {
        this.enableACL = enableACL;
    }

    public boolean isEnableAclRpcHookForClusterMode() {
        return this.enableAclRpcHookForClusterMode;
    }

    public void setEnableAclRpcHookForClusterMode(boolean enableAclRpcHookForClusterMode) {
        this.enableAclRpcHookForClusterMode = enableAclRpcHookForClusterMode;
    }

    public boolean isEnableTopicMessageTypeCheck() {
        return this.enableTopicMessageTypeCheck;
    }

    public void setEnableTopicMessageTypeCheck(boolean enableTopicMessageTypeCheck) {
        this.enableTopicMessageTypeCheck = enableTopicMessageTypeCheck;
    }

    public long getInvisibleTimeMillisWhenClear() {
        return this.invisibleTimeMillisWhenClear;
    }

    public void setInvisibleTimeMillisWhenClear(long invisibleTimeMillisWhenClear) {
        this.invisibleTimeMillisWhenClear = invisibleTimeMillisWhenClear;
    }

    public boolean isEnableProxyAutoRenew() {
        return this.enableProxyAutoRenew;
    }

    public void setEnableProxyAutoRenew(boolean enableProxyAutoRenew) {
        this.enableProxyAutoRenew = enableProxyAutoRenew;
    }

    public int getMaxRenewRetryTimes() {
        return this.maxRenewRetryTimes;
    }

    public void setMaxRenewRetryTimes(int maxRenewRetryTimes) {
        this.maxRenewRetryTimes = maxRenewRetryTimes;
    }

    public int getRenewThreadPoolNums() {
        return this.renewThreadPoolNums;
    }

    public void setRenewThreadPoolNums(int renewThreadPoolNums) {
        this.renewThreadPoolNums = renewThreadPoolNums;
    }

    public int getRenewMaxThreadPoolNums() {
        return this.renewMaxThreadPoolNums;
    }

    public void setRenewMaxThreadPoolNums(int renewMaxThreadPoolNums) {
        this.renewMaxThreadPoolNums = renewMaxThreadPoolNums;
    }

    public int getRenewThreadPoolQueueCapacity() {
        return this.renewThreadPoolQueueCapacity;
    }

    public void setRenewThreadPoolQueueCapacity(int renewThreadPoolQueueCapacity) {
        this.renewThreadPoolQueueCapacity = renewThreadPoolQueueCapacity;
    }

    public long getLockTimeoutMsInHandleGroup() {
        return this.lockTimeoutMsInHandleGroup;
    }

    public void setLockTimeoutMsInHandleGroup(long lockTimeoutMsInHandleGroup) {
        this.lockTimeoutMsInHandleGroup = lockTimeoutMsInHandleGroup;
    }

    public long getRenewAheadTimeMillis() {
        return this.renewAheadTimeMillis;
    }

    public void setRenewAheadTimeMillis(long renewAheadTimeMillis) {
        this.renewAheadTimeMillis = renewAheadTimeMillis;
    }

    public long getRenewMaxTimeMillis() {
        return this.renewMaxTimeMillis;
    }

    public void setRenewMaxTimeMillis(long renewMaxTimeMillis) {
        this.renewMaxTimeMillis = renewMaxTimeMillis;
    }

    public long getRenewSchedulePeriodMillis() {
        return this.renewSchedulePeriodMillis;
    }

    public void setRenewSchedulePeriodMillis(long renewSchedulePeriodMillis) {
        this.renewSchedulePeriodMillis = renewSchedulePeriodMillis;
    }

    public String getMetricCollectorMode() {
        return this.metricCollectorMode;
    }

    public void setMetricCollectorMode(String metricCollectorMode) {
        this.metricCollectorMode = metricCollectorMode;
    }

    public String getMetricCollectorAddress() {
        return this.metricCollectorAddress;
    }

    public void setMetricCollectorAddress(String metricCollectorAddress) {
        this.metricCollectorAddress = metricCollectorAddress;
    }

    public boolean isUseDelayLevel() {
        return this.useDelayLevel;
    }

    public void setUseDelayLevel(boolean useDelayLevel) {
        this.useDelayLevel = useDelayLevel;
    }

    public String getMessageDelayLevel() {
        return this.messageDelayLevel;
    }

    public void setMessageDelayLevel(String messageDelayLevel) {
        this.messageDelayLevel = messageDelayLevel;
    }

    public ConcurrentSkipListMap<Integer, Long> getDelayLevelTable() {
        return this.delayLevelTable;
    }

    public long getGrpcClientIdleTimeMills() {
        return this.grpcClientIdleTimeMills;
    }

    public void setGrpcClientIdleTimeMills(long grpcClientIdleTimeMills) {
        this.grpcClientIdleTimeMills = grpcClientIdleTimeMills;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setTraceOn(boolean traceOn) {
        this.traceOn = traceOn;
    }

    public String getRemotingAccessAddr() {
        return this.remotingAccessAddr;
    }

    public void setRemotingAccessAddr(String remotingAccessAddr) {
        this.remotingAccessAddr = remotingAccessAddr;
    }

    public MetricsExporterType getMetricsExporterType() {
        return this.metricsExporterType;
    }

    public void setMetricsExporterType(MetricsExporterType metricsExporterType) {
        this.metricsExporterType = metricsExporterType;
    }

    public void setMetricsExporterType(int metricsExporterType) {
        this.metricsExporterType = MetricsExporterType.valueOf((int)metricsExporterType);
    }

    public void setMetricsExporterType(String metricsExporterType) {
        this.metricsExporterType = MetricsExporterType.valueOf((String)metricsExporterType);
    }

    public String getMetricsGrpcExporterTarget() {
        return this.metricsGrpcExporterTarget;
    }

    public void setMetricsGrpcExporterTarget(String metricsGrpcExporterTarget) {
        this.metricsGrpcExporterTarget = metricsGrpcExporterTarget;
    }

    public String getMetricsGrpcExporterHeader() {
        return this.metricsGrpcExporterHeader;
    }

    public void setMetricsGrpcExporterHeader(String metricsGrpcExporterHeader) {
        this.metricsGrpcExporterHeader = metricsGrpcExporterHeader;
    }

    public long getMetricGrpcExporterTimeOutInMills() {
        return this.metricGrpcExporterTimeOutInMills;
    }

    public void setMetricGrpcExporterTimeOutInMills(long metricGrpcExporterTimeOutInMills) {
        this.metricGrpcExporterTimeOutInMills = metricGrpcExporterTimeOutInMills;
    }

    public long getMetricGrpcExporterIntervalInMills() {
        return this.metricGrpcExporterIntervalInMills;
    }

    public void setMetricGrpcExporterIntervalInMills(long metricGrpcExporterIntervalInMills) {
        this.metricGrpcExporterIntervalInMills = metricGrpcExporterIntervalInMills;
    }

    public long getMetricLoggingExporterIntervalInMills() {
        return this.metricLoggingExporterIntervalInMills;
    }

    public void setMetricLoggingExporterIntervalInMills(long metricLoggingExporterIntervalInMills) {
        this.metricLoggingExporterIntervalInMills = metricLoggingExporterIntervalInMills;
    }

    public int getMetricsPromExporterPort() {
        return this.metricsPromExporterPort;
    }

    public void setMetricsPromExporterPort(int metricsPromExporterPort) {
        this.metricsPromExporterPort = metricsPromExporterPort;
    }

    public String getMetricsPromExporterHost() {
        return this.metricsPromExporterHost;
    }

    public void setMetricsPromExporterHost(String metricsPromExporterHost) {
        this.metricsPromExporterHost = metricsPromExporterHost;
    }

    public String getMetricsLabel() {
        return this.metricsLabel;
    }

    public void setMetricsLabel(String metricsLabel) {
        this.metricsLabel = metricsLabel;
    }

    public boolean isMetricsInDelta() {
        return this.metricsInDelta;
    }

    public void setMetricsInDelta(boolean metricsInDelta) {
        this.metricsInDelta = metricsInDelta;
    }

    public long getChannelExpiredTimeout() {
        return this.channelExpiredTimeout;
    }

    public boolean isEnableRemotingLocalProxyGrpc() {
        return this.enableRemotingLocalProxyGrpc;
    }

    public void setChannelExpiredTimeout(long channelExpiredTimeout) {
        this.channelExpiredTimeout = channelExpiredTimeout;
    }

    public void setEnableRemotingLocalProxyGrpc(boolean enableRemotingLocalProxyGrpc) {
        this.enableRemotingLocalProxyGrpc = enableRemotingLocalProxyGrpc;
    }

    public int getLocalProxyConnectTimeoutMs() {
        return this.localProxyConnectTimeoutMs;
    }

    public void setLocalProxyConnectTimeoutMs(int localProxyConnectTimeoutMs) {
        this.localProxyConnectTimeoutMs = localProxyConnectTimeoutMs;
    }

    public int getRemotingListenPort() {
        return this.remotingListenPort;
    }

    public void setRemotingListenPort(int remotingListenPort) {
        this.remotingListenPort = remotingListenPort;
    }

    public int getRemotingHeartbeatThreadPoolNums() {
        return this.remotingHeartbeatThreadPoolNums;
    }

    public void setRemotingHeartbeatThreadPoolNums(int remotingHeartbeatThreadPoolNums) {
        this.remotingHeartbeatThreadPoolNums = remotingHeartbeatThreadPoolNums;
    }

    public int getRemotingTopicRouteThreadPoolNums() {
        return this.remotingTopicRouteThreadPoolNums;
    }

    public void setRemotingTopicRouteThreadPoolNums(int remotingTopicRouteThreadPoolNums) {
        this.remotingTopicRouteThreadPoolNums = remotingTopicRouteThreadPoolNums;
    }

    public int getRemotingSendMessageThreadPoolNums() {
        return this.remotingSendMessageThreadPoolNums;
    }

    public void setRemotingSendMessageThreadPoolNums(int remotingSendMessageThreadPoolNums) {
        this.remotingSendMessageThreadPoolNums = remotingSendMessageThreadPoolNums;
    }

    public int getRemotingPullMessageThreadPoolNums() {
        return this.remotingPullMessageThreadPoolNums;
    }

    public void setRemotingPullMessageThreadPoolNums(int remotingPullMessageThreadPoolNums) {
        this.remotingPullMessageThreadPoolNums = remotingPullMessageThreadPoolNums;
    }

    public int getRemotingUpdateOffsetThreadPoolNums() {
        return this.remotingUpdateOffsetThreadPoolNums;
    }

    public void setRemotingUpdateOffsetThreadPoolNums(int remotingUpdateOffsetThreadPoolNums) {
        this.remotingUpdateOffsetThreadPoolNums = remotingUpdateOffsetThreadPoolNums;
    }

    public int getRemotingDefaultThreadPoolNums() {
        return this.remotingDefaultThreadPoolNums;
    }

    public void setRemotingDefaultThreadPoolNums(int remotingDefaultThreadPoolNums) {
        this.remotingDefaultThreadPoolNums = remotingDefaultThreadPoolNums;
    }

    public int getRemotingHeartbeatThreadPoolQueueCapacity() {
        return this.remotingHeartbeatThreadPoolQueueCapacity;
    }

    public void setRemotingHeartbeatThreadPoolQueueCapacity(int remotingHeartbeatThreadPoolQueueCapacity) {
        this.remotingHeartbeatThreadPoolQueueCapacity = remotingHeartbeatThreadPoolQueueCapacity;
    }

    public int getRemotingTopicRouteThreadPoolQueueCapacity() {
        return this.remotingTopicRouteThreadPoolQueueCapacity;
    }

    public void setRemotingTopicRouteThreadPoolQueueCapacity(int remotingTopicRouteThreadPoolQueueCapacity) {
        this.remotingTopicRouteThreadPoolQueueCapacity = remotingTopicRouteThreadPoolQueueCapacity;
    }

    public int getRemotingSendThreadPoolQueueCapacity() {
        return this.remotingSendThreadPoolQueueCapacity;
    }

    public void setRemotingSendThreadPoolQueueCapacity(int remotingSendThreadPoolQueueCapacity) {
        this.remotingSendThreadPoolQueueCapacity = remotingSendThreadPoolQueueCapacity;
    }

    public int getRemotingPullThreadPoolQueueCapacity() {
        return this.remotingPullThreadPoolQueueCapacity;
    }

    public void setRemotingPullThreadPoolQueueCapacity(int remotingPullThreadPoolQueueCapacity) {
        this.remotingPullThreadPoolQueueCapacity = remotingPullThreadPoolQueueCapacity;
    }

    public int getRemotingUpdateOffsetThreadPoolQueueCapacity() {
        return this.remotingUpdateOffsetThreadPoolQueueCapacity;
    }

    public void setRemotingUpdateOffsetThreadPoolQueueCapacity(int remotingUpdateOffsetThreadPoolQueueCapacity) {
        this.remotingUpdateOffsetThreadPoolQueueCapacity = remotingUpdateOffsetThreadPoolQueueCapacity;
    }

    public int getRemotingDefaultThreadPoolQueueCapacity() {
        return this.remotingDefaultThreadPoolQueueCapacity;
    }

    public void setRemotingDefaultThreadPoolQueueCapacity(int remotingDefaultThreadPoolQueueCapacity) {
        this.remotingDefaultThreadPoolQueueCapacity = remotingDefaultThreadPoolQueueCapacity;
    }

    public long getRemotingWaitTimeMillsInSendQueue() {
        return this.remotingWaitTimeMillsInSendQueue;
    }

    public void setRemotingWaitTimeMillsInSendQueue(long remotingWaitTimeMillsInSendQueue) {
        this.remotingWaitTimeMillsInSendQueue = remotingWaitTimeMillsInSendQueue;
    }

    public long getRemotingWaitTimeMillsInPullQueue() {
        return this.remotingWaitTimeMillsInPullQueue;
    }

    public void setRemotingWaitTimeMillsInPullQueue(long remotingWaitTimeMillsInPullQueue) {
        this.remotingWaitTimeMillsInPullQueue = remotingWaitTimeMillsInPullQueue;
    }

    public long getRemotingWaitTimeMillsInHeartbeatQueue() {
        return this.remotingWaitTimeMillsInHeartbeatQueue;
    }

    public void setRemotingWaitTimeMillsInHeartbeatQueue(long remotingWaitTimeMillsInHeartbeatQueue) {
        this.remotingWaitTimeMillsInHeartbeatQueue = remotingWaitTimeMillsInHeartbeatQueue;
    }

    public long getRemotingWaitTimeMillsInUpdateOffsetQueue() {
        return this.remotingWaitTimeMillsInUpdateOffsetQueue;
    }

    public void setRemotingWaitTimeMillsInUpdateOffsetQueue(long remotingWaitTimeMillsInUpdateOffsetQueue) {
        this.remotingWaitTimeMillsInUpdateOffsetQueue = remotingWaitTimeMillsInUpdateOffsetQueue;
    }

    public long getRemotingWaitTimeMillsInTopicRouteQueue() {
        return this.remotingWaitTimeMillsInTopicRouteQueue;
    }

    public void setRemotingWaitTimeMillsInTopicRouteQueue(long remotingWaitTimeMillsInTopicRouteQueue) {
        this.remotingWaitTimeMillsInTopicRouteQueue = remotingWaitTimeMillsInTopicRouteQueue;
    }

    public long getRemotingWaitTimeMillsInDefaultQueue() {
        return this.remotingWaitTimeMillsInDefaultQueue;
    }

    public void setRemotingWaitTimeMillsInDefaultQueue(long remotingWaitTimeMillsInDefaultQueue) {
        this.remotingWaitTimeMillsInDefaultQueue = remotingWaitTimeMillsInDefaultQueue;
    }

    public boolean isSendLatencyEnable() {
        return this.sendLatencyEnable;
    }

    public boolean isStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public void setStartDetectorEnable(boolean startDetectorEnable) {
        this.startDetectorEnable = startDetectorEnable;
    }

    public void setSendLatencyEnable(boolean sendLatencyEnable) {
        this.sendLatencyEnable = sendLatencyEnable;
    }

    public boolean getStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public boolean getSendLatencyEnable() {
        return this.sendLatencyEnable;
    }

    public int getDetectTimeout() {
        return this.detectTimeout;
    }

    public void setDetectTimeout(int detectTimeout) {
        this.detectTimeout = detectTimeout;
    }

    public int getDetectInterval() {
        return this.detectInterval;
    }

    public void setDetectInterval(int detectInterval) {
        this.detectInterval = detectInterval;
    }

    public boolean isEnableBatchAck() {
        return this.enableBatchAck;
    }

    public void setEnableBatchAck(boolean enableBatchAck) {
        this.enableBatchAck = enableBatchAck;
    }

    public boolean isEnableMessageBodyEmptyCheck() {
        return this.enableMessageBodyEmptyCheck;
    }

    public void setEnableMessageBodyEmptyCheck(boolean enableMessageBodyEmptyCheck) {
        this.enableMessageBodyEmptyCheck = enableMessageBodyEmptyCheck;
    }

    static {
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Failed to obtain the host name", (Throwable)e);
        }
    }
}

