/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Requires;
import com.google.protobuf.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteTable
implements Describer {
    private static final Logger LOG = LoggerFactory.getLogger(RouteTable.class);
    private static final RouteTable INSTANCE = new RouteTable();
    private final ConcurrentMap<String, GroupConf> groupConfTable = new ConcurrentHashMap<String, GroupConf>();

    public static RouteTable getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfiguration(String groupId, Configuration conf) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        GroupConf gc = this.getOrCreateGroupConf(groupId);
        StampedLock stampedLock = gc.stampedLock;
        long stamp = stampedLock.writeLock();
        try {
            gc.conf = conf;
            if (gc.leader != null && !gc.conf.contains(gc.leader)) {
                gc.leader = null;
            }
        }
        finally {
            stampedLock.unlockWrite(stamp);
        }
        return true;
    }

    private GroupConf getOrCreateGroupConf(String groupId) {
        GroupConf old;
        GroupConf gc = (GroupConf)this.groupConfTable.get(groupId);
        if (gc == null && (old = this.groupConfTable.putIfAbsent(groupId, gc = new GroupConf())) != null) {
            gc = old;
        }
        return gc;
    }

    public boolean updateConfiguration(String groupId, String confStr) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireTrue(!StringUtils.isBlank((String)confStr), "Blank configuration");
        Configuration conf = new Configuration();
        if (conf.parse(confStr)) {
            return this.updateConfiguration(groupId, conf);
        }
        LOG.error("Fail to parse confStr: {}", (Object)confStr);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerId selectLeader(String groupId) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        GroupConf gc = (GroupConf)this.groupConfTable.get(groupId);
        if (gc == null) {
            return null;
        }
        StampedLock stampedLock = gc.stampedLock;
        long stamp = stampedLock.tryOptimisticRead();
        PeerId leader = gc.leader;
        if (!stampedLock.validate(stamp)) {
            stamp = stampedLock.readLock();
            try {
                leader = gc.leader;
            }
            finally {
                stampedLock.unlockRead(stamp);
            }
        }
        return leader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLeader(String groupId, PeerId leader) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        if (leader != null) {
            Requires.requireTrue(!leader.isEmpty(), "Empty leader");
        }
        GroupConf gc = this.getOrCreateGroupConf(groupId);
        StampedLock stampedLock = gc.stampedLock;
        long stamp = stampedLock.writeLock();
        try {
            gc.leader = leader;
        }
        finally {
            stampedLock.unlockWrite(stamp);
        }
        return true;
    }

    public boolean updateLeader(String groupId, String leaderStr) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireTrue(!StringUtils.isBlank((String)leaderStr), "Blank leader");
        PeerId leader = new PeerId();
        if (leader.parse(leaderStr)) {
            return this.updateLeader(groupId, leader);
        }
        LOG.error("Fail to parse leaderStr: {}", (Object)leaderStr);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(String groupId) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        GroupConf gc = (GroupConf)this.groupConfTable.get(groupId);
        if (gc == null) {
            return null;
        }
        StampedLock stampedLock = gc.stampedLock;
        long stamp = stampedLock.tryOptimisticRead();
        Configuration conf = gc.conf;
        if (!stampedLock.validate(stamp)) {
            stamp = stampedLock.readLock();
            try {
                conf = gc.conf;
            }
            finally {
                stampedLock.unlockRead(stamp);
            }
        }
        return conf;
    }

    public Status refreshLeader(CliClientService cliClientService, String groupId, int timeoutMs) throws InterruptedException, TimeoutException {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireTrue(timeoutMs > 0, "Invalid timeout: " + timeoutMs);
        Configuration conf = this.getConfiguration(groupId);
        if (conf == null) {
            return new Status(RaftError.ENOENT, "Group %s is not registered in RouteTable, forgot to call updateConfiguration?", groupId);
        }
        Status st = Status.OK();
        CliRequests.GetLeaderRequest.Builder rb = CliRequests.GetLeaderRequest.newBuilder();
        rb.setGroupId(groupId);
        CliRequests.GetLeaderRequest request = rb.build();
        TimeoutException timeoutException = null;
        for (PeerId peer : conf) {
            String savedMsg;
            if (!cliClientService.connect(peer.getEndpoint())) {
                if (st.isOk()) {
                    st.setError(-1, "Fail to init channel to %s", peer);
                    continue;
                }
                String savedMsg2 = st.getErrorMsg();
                st.setError(-1, "%s, Fail to init channel to %s", savedMsg2, peer);
                continue;
            }
            Future<Message> result = cliClientService.getLeader(peer.getEndpoint(), request, null);
            try {
                Message msg = result.get(timeoutMs, TimeUnit.MILLISECONDS);
                if (msg instanceof RpcRequests.ErrorResponse) {
                    if (st.isOk()) {
                        st.setError(-1, ((RpcRequests.ErrorResponse)msg).getErrorMsg(), new Object[0]);
                        continue;
                    }
                    savedMsg = st.getErrorMsg();
                    st.setError(-1, "%s, %s", savedMsg, ((RpcRequests.ErrorResponse)msg).getErrorMsg());
                    continue;
                }
                CliRequests.GetLeaderResponse response = (CliRequests.GetLeaderResponse)msg;
                this.updateLeader(groupId, response.getLeaderId());
                return Status.OK();
            }
            catch (TimeoutException e) {
                timeoutException = e;
            }
            catch (ExecutionException e) {
                if (st.isOk()) {
                    st.setError(-1, e.getMessage(), new Object[0]);
                    continue;
                }
                savedMsg = st.getErrorMsg();
                st.setError(-1, "%s, %s", savedMsg, e.getMessage());
            }
        }
        if (timeoutException != null) {
            throw timeoutException;
        }
        return st;
    }

    public Status refreshConfiguration(CliClientService cliClientService, String groupId, int timeoutMs) throws InterruptedException, TimeoutException {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireTrue(timeoutMs > 0, "Invalid timeout: " + timeoutMs);
        Configuration conf = this.getConfiguration(groupId);
        if (conf == null) {
            return new Status(RaftError.ENOENT, "Group %s is not registered in RouteTable, forgot to call updateConfiguration?", groupId);
        }
        Status st = Status.OK();
        PeerId leaderId = this.selectLeader(groupId);
        if (leaderId == null) {
            this.refreshLeader(cliClientService, groupId, timeoutMs);
            leaderId = this.selectLeader(groupId);
        }
        if (leaderId == null) {
            st.setError(-1, "Fail to get leader of group %s", groupId);
            return st;
        }
        if (!cliClientService.connect(leaderId.getEndpoint())) {
            st.setError(-1, "Fail to init channel to %s", leaderId);
            return st;
        }
        CliRequests.GetPeersRequest.Builder rb = CliRequests.GetPeersRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        try {
            Message result = cliClientService.getPeers(leaderId.getEndpoint(), rb.build(), null).get(timeoutMs, TimeUnit.MILLISECONDS);
            if (result instanceof CliRequests.GetPeersResponse) {
                CliRequests.GetPeersResponse resp = (CliRequests.GetPeersResponse)result;
                Configuration newConf = new Configuration();
                for (String peerIdStr : resp.getPeersList()) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    newConf.addPeer(newPeer);
                }
                for (String learnerIdStr : resp.getLearnersList()) {
                    PeerId newLearner = new PeerId();
                    newLearner.parse(learnerIdStr);
                    newConf.addLearner(newLearner);
                }
                if (!conf.equals(newConf)) {
                    LOG.info("Configuration of replication group {} changed from {} to {}", new Object[]{groupId, conf, newConf});
                }
                this.updateConfiguration(groupId, newConf);
            } else {
                RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)result;
                st.setError(resp.getErrorCode(), resp.getErrorMsg(), new Object[0]);
            }
        }
        catch (Exception e) {
            st.setError(-1, e.getMessage(), new Object[0]);
        }
        return st;
    }

    public void reset() {
        this.groupConfTable.clear();
    }

    public boolean removeGroup(String groupId) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        return this.groupConfTable.remove(groupId) != null;
    }

    public String toString() {
        return "RouteTable{groupConfTable=" + this.groupConfTable + '}';
    }

    private RouteTable() {
    }

    @Override
    public void describe(Describer.Printer out) {
        out.println("RouteTable:").print("  ").println(this.toString());
    }

    private static class GroupConf {
        private final StampedLock stampedLock = new StampedLock();
        private Configuration conf;
        private PeerId leader;

        private GroupConf() {
        }

        public String toString() {
            return "GroupConf{conf=" + this.conf + ", leader=" + this.leader + '}';
        }
    }
}

