/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.impl.GrpcRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.MarshallerRegistry;
import com.alipay.sofa.jraft.rpc.impl.cli.CliClientServiceImpl;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.meta.RaftUtil;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetaRpcClient {
    private static Logger logger = LoggerFactory.getLogger(MetaRpcClient.class);
    private RouteTable rt;
    private Configuration conf;
    private CliClientServiceImpl cliClientService;
    private static ScheduledExecutorService raftClientExecutor = Executors.newSingleThreadScheduledExecutor();
    public String[] raftGroups;
    @Resource
    private ServiceConf serviceConf;

    @PostConstruct
    public void init() throws InterruptedException, TimeoutException {
        this.initRpcServer();
        this.cliClientService = new CliClientServiceImpl();
        this.cliClientService.init((RpcOptions)new CliOptions());
        this.rt = RouteTable.getInstance();
        this.conf = JRaftUtils.getConfiguration((String)this.serviceConf.getMetaAddr());
        for (String groupId : this.raftGroups = RaftUtil.LIST_RAFT_GROUPS()) {
            this.rt.updateConfiguration(groupId, this.conf);
        }
        this.refreshLeader();
        raftClientExecutor.scheduleAtFixedRate(() -> this.refreshLeader(), 3L, 3L, TimeUnit.SECONDS);
    }

    public void initRpcServer() {
        GrpcRaftRpcFactory raftRpcFactory = (GrpcRaftRpcFactory)RpcFactoryHelper.rpcFactory();
        raftRpcFactory.registerProtobufSerializer(WriteRequest.class.getName(), new Object[]{WriteRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(ReadRequest.class.getName(), new Object[]{ReadRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(Response.class.getName(), new Object[]{Response.getDefaultInstance()});
        MarshallerRegistry registry = raftRpcFactory.getMarshallerRegistry();
        registry.registerResponseInstance(WriteRequest.class.getName(), (Message)Response.getDefaultInstance());
        registry.registerResponseInstance(ReadRequest.class.getName(), (Message)Response.getDefaultInstance());
    }

    private void refreshLeader() {
        for (String groupId : this.raftGroups) {
            try {
                this.rt.refreshLeader((CliClientService)this.cliClientService, groupId, 1000);
            }
            catch (Exception e) {
                logger.error("refreshLeader failed {}", (Object)groupId, (Object)e);
            }
        }
    }

    public PeerId getLeader(String raftGroupId) {
        return this.rt.selectLeader(raftGroupId);
    }

    public CliClientServiceImpl getCliClientService() {
        return this.cliClientService;
    }

    public String whichGroup(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        int index = key.hashCode() % 3;
        if (index < 0) {
            index = 0;
        }
        return this.raftGroups[index];
    }

    public String[] getRaftGroups() {
        return this.raftGroups;
    }
}

