/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.google.protobuf.Message;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;

public class MqttClosure
implements Closure {
    private Message message;
    private Closure closure;
    private MqttStatus mqttStatus = new MqttStatus();

    public MqttClosure(Message message, Closure closure) {
        this.message = message;
        this.closure = closure;
    }

    public void run(Status status) {
        this.mqttStatus.setStatus(status);
        this.closure.run((Status)this.mqttStatus);
        this.clear();
    }

    private void clear() {
        this.message = null;
        this.closure = null;
        this.mqttStatus = null;
    }

    public void setResponse(Response response) {
        this.mqttStatus.setResponse(response);
    }

    public void setThrowable(Throwable throwable) {
        this.mqttStatus.setThrowable(throwable);
    }

    public Message getMessage() {
        return this.message;
    }

    public static class MqttStatus
    extends Status {
        private Status status;
        private Response response = null;
        private Throwable throwable = null;

        public void setStatus(Status status) {
            this.status = status;
        }

        public void reset() {
            this.status.reset();
        }

        public boolean isOk() {
            return this.status.isOk();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public void setCode(int code) {
            this.status.setCode(code);
        }

        public RaftError getRaftError() {
            return this.status.getRaftError();
        }

        public void setError(int code, String fmt, Object ... args) {
            this.status.setError(code, fmt, args);
        }

        public void setError(RaftError error, String fmt, Object ... args) {
            this.status.setError(error, fmt, args);
        }

        public String toString() {
            return this.status.toString();
        }

        public Status copy() {
            MqttStatus copy = new MqttStatus();
            copy.status = this.status;
            copy.response = this.response;
            copy.throwable = this.throwable;
            return copy;
        }

        public String getErrorMsg() {
            return this.status.getErrorMsg();
        }

        public void setErrorMsg(String errMsg) {
            this.status.setErrorMsg(errMsg);
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

