/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.infly;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.cs.session.infly.MqttMsgId;
import org.springframework.stereotype.Component;

@Component
public class InFlyCache {
    @Resource
    private MqttMsgId mqttMsgId;
    private ConcurrentMap<String, Set<Integer>> pubCache = new ConcurrentHashMap<String, Set<Integer>>(128);
    private PendingDownCache pendingDownCache = new PendingDownCache();

    public void cleanResource(String clientId, String channelId) {
        this.pubCache.remove(channelId);
        this.pendingDownCache.clear(clientId, channelId);
    }

    private ConcurrentMap<String, Set<Integer>> whichCache(CacheType cacheType) {
        switch (cacheType) {
            case PUB: {
                return this.pubCache;
            }
        }
        throw new RuntimeException("invalid cache type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheType cacheType, String channelId, int mqttMsgId) {
        ConcurrentMap<String, Set<Integer>> cache = this.whichCache(cacheType);
        cache.putIfAbsent(channelId, new HashSet());
        Set idCache = (Set)cache.get(channelId);
        if (idCache == null) {
            return;
        }
        Set set = idCache;
        synchronized (set) {
            idCache.add(mqttMsgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(CacheType cacheType, String channelId, int mqttMsgId) {
        ConcurrentMap<String, Set<Integer>> cache = this.whichCache(cacheType);
        Set idCache = (Set)cache.get(channelId);
        if (idCache == null) {
            return false;
        }
        Set set = idCache;
        synchronized (set) {
            return idCache.contains(mqttMsgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheType cacheType, String channelId, int mqttMsgId) {
        ConcurrentMap<String, Set<Integer>> cache = this.whichCache(cacheType);
        Set idCache = (Set)cache.get(channelId);
        if (idCache == null) {
            return;
        }
        Set set = idCache;
        synchronized (set) {
            idCache.remove(mqttMsgId);
            if (idCache.isEmpty()) {
                cache.remove(channelId);
            }
        }
    }

    public PendingDownCache getPendingDownCache() {
        return this.pendingDownCache;
    }

    public class PendingDown {
        private Subscription subscription;
        private Queue queue;
        private long seqId;
        private long t = System.currentTimeMillis();

        public Subscription getSubscription() {
            return this.subscription;
        }

        public void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public Queue getQueue() {
            return this.queue;
        }

        public void setQueue(Queue queue) {
            this.queue = queue;
        }

        public long getSeqId() {
            return this.seqId;
        }

        public void setSeqId(long seqId) {
            this.seqId = seqId;
        }

        public long getT() {
            return this.t;
        }
    }

    public class PendingDownCache {
        private ConcurrentMap<String, Map<Integer, PendingDown>> cache = new ConcurrentHashMap<String, Map<Integer, PendingDown>>(128);

        public PendingDown put(String channelId, int mqttMsgId, Subscription subscription, Queue queue, Message message) {
            PendingDown pendingDown = new PendingDown();
            pendingDown.setSubscription(subscription);
            pendingDown.setQueue(queue);
            pendingDown.setSeqId(message.getOffset());
            this.cache.putIfAbsent(channelId, new ConcurrentHashMap(16));
            ((Map)this.cache.get(channelId)).put(mqttMsgId, pendingDown);
            return pendingDown;
        }

        public Map<Integer, PendingDown> all(String channelId) {
            if (StringUtils.isBlank((CharSequence)channelId)) {
                return null;
            }
            return (Map)this.cache.get(channelId);
        }

        public PendingDown remove(String channelId, int mqttMsgId) {
            Map map = (Map)this.cache.get(channelId);
            if (map != null) {
                return (PendingDown)map.remove(mqttMsgId);
            }
            return null;
        }

        public PendingDown get(String channelId, int mqttMsgId) {
            Map map = (Map)this.cache.get(channelId);
            if (map != null) {
                return (PendingDown)map.get(mqttMsgId);
            }
            return null;
        }

        public void clear(String clientId, String channelId) {
            Map pendingDownMap = (Map)this.cache.remove(channelId);
            if (clientId != null && pendingDownMap != null) {
                pendingDownMap.forEach((mqttId, pendingDown) -> InFlyCache.this.mqttMsgId.releaseId((int)mqttId, clientId));
            }
        }
    }

    public static enum CacheType {
        PUB;

    }
}

