/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.loop;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.LmqQueueStore;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.PullResult;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.QueueOffset;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.StatUtil;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.loop.PullResultStatus;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QueueCache {
    private static Logger logger = LoggerFactory.getLogger(QueueCache.class);
    @Resource
    private ConnectConf connectConf;
    @Resource
    private LmqQueueStore lmqQueueStore;
    private ScheduledThreadPoolExecutor loadCacheService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("loadCache_"));
    private AtomicLong rid = new AtomicLong();
    private Map<Queue, QueueEvent> loadEvent = new ConcurrentHashMap<Queue, QueueEvent>();
    private Map<Queue, Boolean> loadStatus = new ConcurrentHashMap<Queue, Boolean>();
    private Cache<Queue, CacheEntry> cache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).build();

    @PostConstruct
    public void init() {
        this.loadCacheService.scheduleWithFixedDelay(() -> {
            for (Map.Entry<Queue, QueueEvent> entry : this.loadEvent.entrySet()) {
                Queue queue = entry.getKey();
                QueueEvent event = entry.getValue();
                if (Boolean.TRUE.equals(this.loadStatus.get(queue))) continue;
                CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent((Object)queue);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry();
                    this.cache.put((Object)queue, (Object)cacheEntry);
                }
                if (CollectionUtils.isEmpty((Collection)cacheEntry.messageList)) {
                    this.loadCache(true, queue.toFirstTopic(), queue, null, 1, event);
                    continue;
                }
                QueueOffset queueOffset = new QueueOffset();
                Message lastMessage = (Message)cacheEntry.messageList.get(cacheEntry.messageList.size() - 1);
                queueOffset.setOffset(lastMessage.getOffset() + 1L);
                this.loadCache(false, queue.toFirstTopic(), queue, queueOffset, this.connectConf.getPullBatchSize(), event);
            }
        }, 10L, 10L, TimeUnit.MILLISECONDS);
    }

    public void refreshCache(Pair<Queue, Session> pair) {
        Queue queue = (Queue)pair.getLeft();
        if (queue == null) {
            return;
        }
        if (queue.isP2p() || queue.isRetry()) {
            return;
        }
        this.addLoadEvent(queue, (Session)pair.getRight());
    }

    private void addLoadEvent(Queue queue, Session session) {
        this.loadEvent.put(queue, new QueueEvent(this.rid.incrementAndGet(), session));
        CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent((Object)queue);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cache.put((Object)queue, (Object)cacheEntry);
        }
    }

    private void callbackResult(CompletableFuture<PullResult> pullResult, CompletableFuture<PullResult> callBackResult) {
        pullResult.whenComplete((pullResult1, throwable) -> {
            if (throwable != null) {
                callBackResult.completeExceptionally((Throwable)throwable);
            } else {
                callBackResult.complete((PullResult)pullResult1);
            }
        });
    }

    private String toFirstTopic(Subscription subscription) {
        String firstTopic = subscription.toFirstTopic();
        if (subscription.isRetry()) {
            firstTopic = this.lmqQueueStore.getClientRetryTopic();
        }
        if (subscription.isP2p()) {
            firstTopic = StringUtils.isNotBlank((CharSequence)this.lmqQueueStore.getClientP2pTopic()) ? this.lmqQueueStore.getClientP2pTopic() : this.lmqQueueStore.getClientRetryTopic();
        }
        return firstTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PullResultStatus pullMessage(Session session, Subscription subscription, Queue queue, QueueOffset queueOffset, int count, CompletableFuture<PullResult> callBackResult) {
        Object pullResult;
        if (subscription.isP2p() || subscription.isRetry()) {
            StatUtil.addPv((String)"NotPullCache", (long)1L);
            this.collectorPullCacheStatus("NotPullCache");
            CompletableFuture pullResult2 = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
            this.callbackResult(pullResult2, callBackResult);
            return PullResultStatus.DONE;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent((Object)queue);
        if (cacheEntry == null) {
            StatUtil.addPv((String)"NoPullCache", (long)1L);
            this.collectorPullCacheStatus("NotPullCache");
            CompletableFuture pullResult3 = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
            this.callbackResult(pullResult3, callBackResult);
            return PullResultStatus.DONE;
        }
        if (cacheEntry.loading.get()) {
            if (System.currentTimeMillis() - cacheEntry.startLoadingT > 1000L) {
                StatUtil.addPv((String)"LoadPullCacheTimeout", (long)1L);
                this.collectorPullCacheStatus("LoadPullCacheTimeout");
                CompletableFuture pullResult4 = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
                this.callbackResult(pullResult4, callBackResult);
                return PullResultStatus.DONE;
            }
            return PullResultStatus.LATER;
        }
        List cacheMsgList = cacheEntry.messageList;
        if (cacheMsgList.isEmpty()) {
            if (this.loadEvent.get(queue) != null) {
                this.collectorPullCacheStatus("EmptyPullCacheLATER");
                StatUtil.addPv((String)"EmptyPullCacheLATER", (long)1L);
                return PullResultStatus.LATER;
            }
            StatUtil.addPv((String)"EmptyPullCache", (long)1L);
            this.collectorPullCacheStatus("EmptyPullCache");
            CompletableFuture pullResult5 = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
            this.callbackResult(pullResult5, callBackResult);
            return PullResultStatus.DONE;
        }
        if (queueOffset.getOffset() < ((Message)cacheMsgList.get(0)).getOffset()) {
            StatUtil.addPv((String)"OutPullCache", (long)1L);
            this.collectorPullCacheStatus("OutPullCache");
            CompletableFuture pullResult6 = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
            this.callbackResult(pullResult6, callBackResult);
            return PullResultStatus.DONE;
        }
        ArrayList<Message> resultMsgs = new ArrayList<Message>();
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            for (Message message : cacheMsgList) {
                if (message.getOffset() >= queueOffset.getOffset()) {
                    resultMsgs.add(message);
                }
                if (resultMsgs.size() < count) continue;
                break;
            }
        }
        if (resultMsgs.isEmpty()) {
            if (this.loadEvent.get(queue) != null) {
                StatUtil.addPv((String)"PullCacheLATER", (long)1L);
                this.collectorPullCacheStatus("PullCacheLATER");
                return PullResultStatus.LATER;
            }
            StatUtil.addPv((String)"OutPullCache2", (long)1L);
            this.collectorPullCacheStatus("OutPullCache2");
            pullResult = this.lmqQueueStore.pullMessage(this.toFirstTopic(subscription), queue, queueOffset, (long)count);
            this.callbackResult((CompletableFuture<PullResult>)pullResult, callBackResult);
            return PullResultStatus.DONE;
        }
        pullResult = new PullResult();
        pullResult.setMessageList(resultMsgs);
        callBackResult.complete((PullResult)pullResult);
        StatUtil.addPv((String)"PullFromCache", (long)1L);
        this.collectorPullCacheStatus("PullFromCache");
        if (this.loadEvent.get(queue) != null) {
            return PullResultStatus.LATER;
        }
        return PullResultStatus.DONE;
    }

    private void collectorPullCacheStatus(String pullCacheStatus) {
        try {
            MqttMetricsCollector.collectPullCacheStatusTps((long)1L, (String[])new String[]{pullCacheStatus});
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    private void loadCache(boolean isFirst, String firstTopic, Queue queue, QueueOffset queueOffset, int count, QueueEvent event) {
        this.loadStatus.put(queue, true);
        CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent((Object)queue);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cache.put((Object)queue, (Object)cacheEntry);
        }
        cacheEntry.startLoad();
        CacheEntry finalCacheEntry = cacheEntry;
        CompletableFuture result = isFirst ? this.lmqQueueStore.pullLastMessages(firstTopic, queue, (long)count) : this.lmqQueueStore.pullMessage(firstTopic, queue, queueOffset, (long)count);
        result.whenComplete((pullResult, throwable) -> {
            block12: {
                if (throwable != null) {
                    logger.error("", throwable);
                    this.loadEvent.remove(queue, event);
                    this.loadStatus.remove(queue);
                    finalCacheEntry.endLoad();
                    this.addLoadEvent(queue, event.session);
                    return;
                }
                try {
                    if (pullResult == null || CollectionUtils.isEmpty((Collection)pullResult.getMessageList())) break block12;
                    CacheEntry cacheEntry = finalCacheEntry;
                    synchronized (cacheEntry) {
                        finalCacheEntry.messageList.addAll(pullResult.getMessageList());
                        if (isFirst) {
                            Collections.sort(finalCacheEntry.messageList, Comparator.comparingLong(Message::getOffset));
                        }
                        int overNum = finalCacheEntry.messageList.size() - this.connectConf.getQueueCacheSize();
                        for (int i = 0; i < overNum; ++i) {
                            finalCacheEntry.messageList.remove(0);
                        }
                    }
                    if (pullResult.getMessageList().size() >= count && !isFirst) {
                        this.addLoadEvent(queue, event.session);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("loadCache failed {}", (Object)queue.getQueueName(), (Object)e);
                    this.addLoadEvent(queue, event.session);
                }
                finally {
                    this.loadEvent.remove(queue, event);
                    this.loadStatus.remove(queue);
                    finalCacheEntry.endLoad();
                }
            }
        });
    }

    class CacheEntry {
        private AtomicBoolean loading = new AtomicBoolean(false);
        private List<Message> messageList = new ArrayList<Message>();
        private volatile long startLoadingT = System.currentTimeMillis();

        CacheEntry() {
        }

        private void startLoad() {
            if (this.loading.compareAndSet(false, true)) {
                this.startLoadingT = System.currentTimeMillis();
            }
        }

        private void endLoad() {
            this.loading.compareAndSet(true, false);
        }
    }

    class QueueEvent {
        long id;
        Session session;

        public QueueEvent(long id, Session session) {
            this.id = id;
            this.session = session;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueEvent that = (QueueEvent)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

