---
layout: page
title: Contact Us
---
<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

There are many ways to reach the Samza user and developer communities - use whichever one seems best! 

Please make sure you are subscribed to the mailing list you are posting to! If you are not subscribed to the mailing list, your message will be rejected.

<table class="table table-condensed table-bordered table-striped">
  <thead>
    <tr>
        <th> How to contact us</th>
        <th> When to use it </th>
    </tr>
  </thead>
  <tbody>
    <tr>
        <td> <a href="https://lists.apache.org/list.html?dev@samza.apache.org">dev@</a> mailing list </td>
        <td> General and Development discussions (<a href="mailto:dev-subscribe@samza.apache.org">Subscribe</a>, <a href="mailto:dev-unsubscribe@samza.apache.org">Unsubscribe</a>) </td>
    </tr>
    <tr>
        <td> <a href="https://lists.apache.org/list.html?commits@samza.apache.org"> commits@ </a> mailing list </td>
        <td> Commits, bugs, pull requests, etc. (<a href="mailto:commits-subscribe@samza.apache.org">Subscribe</a>, <a href="mailto:commits-unsubscribe@samza.apache.org">Unsubscribe</a>) </td>
    </tr>
    <tr>
        <td> <a href="https://issues.apache.org/jira/projects/SAMZA/issues/SAMZA-1371?filter=allopenissues">JIRA</a> bug tracker </td>
        <td> Report bugs / discover known issues </td>
    </tr>
  </tbody>  
</table>

If you would like to post to these mailing lists, please

1. subscribe by sending an email using the **subscribe** links above; and
2. confirm the subscription by replying to the confirmation email; and
3. send your email to the mailing list.

Please note that you won’t receive any responses to your email if you are not subscribed.

### Having a Question?

The Apache Samza community answers many user questions every day. You can search for answers and advices in the archives or reach out to the community for help and guidance.

#### User Mailing List

Many Samza users, contributors, and committers are subscribed to Samza’s user mailing list. The user mailing list is a great place to get help.

Some quick tips when using the mailing lists:

* Prior to submitting questions, you can search the archive to find if the same questions have been asked before in [dev@samza.apache.org mail archives](http://mail-archives.apache.org/mod_mbox/samza-dev/). 
* For error logs or long code examples, please use [GitHub gist](https://gist.github.com/) and include only a few lines of the pertinent code / log within the email.
* No jobs, sales, or solicitation is permitted on the Apache Samza mailing lists.

### Found a Bug?

If you observe an unexpected behavior that might be caused by a bug, you can search for reported bugs or file a bug report in [Samza’s JIRA](https://issues.apache.org/jira/projects/SAMZA/issues/SAMZA-1371?filter=allopenissues). More instructions are available in [contribors corner](/contribute/contributors-corner.html).

If you are unsure whether the unexpected behavior was a bug or not, please post a question to the [user mailing list](mailto:dev@samza.apache.org).


