/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlay.snap.SnapTransformer;

public class GeometrySnapper {
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private Geometry srcGeom;

    public static double computeOverlaySnapTolerance(Geometry g) {
        double fixedSnapTol;
        double snapTolerance = GeometrySnapper.computeSizeBasedSnapTolerance(g);
        PrecisionModel pm = g.getPrecisionModel();
        if (pm.getType() == PrecisionModel.FIXED && (fixedSnapTol = 1.0 / pm.getScale() * 2.0 / 1.415) > snapTolerance) {
            snapTolerance = fixedSnapTol;
        }
        return snapTolerance;
    }

    public static double computeSizeBasedSnapTolerance(Geometry g) {
        Envelope env = g.getEnvelopeInternal();
        double minDimension = Math.min(env.getHeight(), env.getWidth());
        double snapTol = minDimension * 1.0E-9;
        return snapTol;
    }

    public static double computeOverlaySnapTolerance(Geometry g0, Geometry g1) {
        return Math.min(GeometrySnapper.computeOverlaySnapTolerance(g0), GeometrySnapper.computeOverlaySnapTolerance(g1));
    }

    public static Geometry[] snap(Geometry g0, Geometry g1, double snapTolerance) {
        Geometry[] snapGeom = new Geometry[2];
        GeometrySnapper snapper0 = new GeometrySnapper(g0);
        snapGeom[0] = snapper0.snapTo(g1, snapTolerance);
        GeometrySnapper snapper1 = new GeometrySnapper(g1);
        snapGeom[1] = snapper1.snapTo(snapGeom[0], snapTolerance);
        return snapGeom;
    }

    public static Geometry snapToSelf(Geometry geom, double snapTolerance, boolean cleanResult) {
        GeometrySnapper snapper0 = new GeometrySnapper(geom);
        return snapper0.snapToSelf(snapTolerance, cleanResult);
    }

    public GeometrySnapper(Geometry srcGeom) {
        this.srcGeom = srcGeom;
    }

    public Geometry snapTo(Geometry snapGeom, double snapTolerance) {
        Coordinate[] snapPts = this.extractTargetCoordinates(snapGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts);
        return snapTrans.transform(this.srcGeom);
    }

    public Geometry snapToSelf(double snapTolerance, boolean cleanResult) {
        Geometry snappedGeom;
        Coordinate[] snapPts = this.extractTargetCoordinates(this.srcGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts, true);
        Geometry result2 = snappedGeom = snapTrans.transform(this.srcGeom);
        if (cleanResult && result2 instanceof Polygonal) {
            result2 = snappedGeom.buffer(0.0);
        }
        return result2;
    }

    private Coordinate[] extractTargetCoordinates(Geometry g) {
        TreeSet<Coordinate> ptSet = new TreeSet<Coordinate>();
        Coordinate[] pts = g.getCoordinates();
        for (int i = 0; i < pts.length; ++i) {
            ptSet.add(pts[i]);
        }
        return ptSet.toArray(new Coordinate[0]);
    }

    private double computeSnapTolerance(Coordinate[] ringPts) {
        double minSegLen = this.computeMinimumSegmentLength(ringPts);
        double snapTol = minSegLen / 10.0;
        return snapTol;
    }

    private double computeMinimumSegmentLength(Coordinate[] pts) {
        double minSegLen = Double.MAX_VALUE;
        for (int i = 0; i < pts.length - 1; ++i) {
            double segLen = pts[i].distance(pts[i + 1]);
            if (!(segLen < minSegLen)) continue;
            minSegLen = segLen;
        }
        return minSegLen;
    }
}

