/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.RenderedImage;
import java.util.Optional;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;

public class RasterAccessors {
    public static int srid(GridCoverage2D raster) throws FactoryException {
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem();
        if (crs instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)crs).isWildcard()) {
            return 0;
        }
        return Optional.ofNullable(CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true)).orElse(0);
    }

    public static int numBands(GridCoverage2D raster) {
        return raster.getNumSampleDimensions();
    }

    public static Geometry envelope(GridCoverage2D raster) throws FactoryException {
        Envelope2D envelope2D = raster.getEnvelope2D();
        Envelope envelope = new Envelope(envelope2D.getMinX(), envelope2D.getMaxX(), envelope2D.getMinY(), envelope2D.getMaxY());
        int srid = RasterAccessors.srid(raster);
        return new GeometryFactory(new PrecisionModel(), srid).toGeometry(envelope);
    }

    public static double[] metadata(GridCoverage2D raster) throws FactoryException {
        RenderedImage image = raster.getRenderedImage();
        Envelope2D envelope2D = raster.getEnvelope2D();
        MathTransform2D gridToCRS = raster.getGridGeometry().getGridToCRS2D();
        if (gridToCRS instanceof AffineTransform2D) {
            AffineTransform2D affine = (AffineTransform2D)gridToCRS;
            double scaleX = affine.getScaleX();
            double scaleY = affine.getScaleY();
            double shearX = affine.getShearX();
            double shearY = affine.getShearY();
            return new double[]{envelope2D.getMinX(), envelope2D.getMaxY(), image.getWidth(), image.getHeight(), scaleX, scaleY, shearX, shearY, RasterAccessors.srid(raster), raster.getNumSampleDimensions()};
        }
        throw new UnsupportedOperationException("Only AffineTransform2D is supported");
    }
}

