/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.raster;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.sedona_sql.io.raster.ImageReadOptions;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GeotiffSchema$ {
    public static final GeotiffSchema$ MODULE$ = new GeotiffSchema$();
    private static final String undefinedImageType = "Undefined";
    private static final StructType columnSchema;
    private static final String[] imageFields;
    private static final StructType imageSchema;

    static {
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("geometry", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("nBands", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4());
        columnSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        imageFields = MODULE$.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)MODULE$.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        imageSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField7));
    }

    public String undefinedImageType() {
        return undefinedImageType;
    }

    public StructType columnSchema() {
        return columnSchema;
    }

    public String[] imageFields() {
        return imageFields;
    }

    public StructType imageSchema() {
        return imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public GeometryUDT getGeometry(Row row) {
        return (GeometryUDT)((Object)row.getAs(1));
    }

    public int getHeight(Row row) {
        return row.getInt(2);
    }

    public int getWidth(Row row) {
        return row.getInt(3);
    }

    public int getNBands(Row row) {
        return row.getInt(4);
    }

    public double[] getData(Row row) {
        return (double[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), Array$.MODULE$.ofDim(0, (ClassTag)ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes, ImageReadOptions imageSourceOptions) {
        CoordinateReferenceSystem source;
        CoordinateReferenceSystem coordinateReferenceSystem;
        None$ none$;
        GeoTiffReader geoTiffReader;
        ParameterValue policy = AbstractGridFormat.OVERVIEW_POLICY.createValue();
        policy.setValue((Object)OverviewPolicy.IGNORE);
        ParameterValue gridsize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        ParameterValue useJaiRead = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJaiRead.setValue(true);
        try {
            geoTiffReader = new GeoTiffReader((Object)new ByteArrayInputStream(bytes));
        }
        catch (RuntimeException runtimeException) {
            geoTiffReader = null;
        }
        GeoTiffReader reader = geoTiffReader;
        ObjectRef coverage = ObjectRef.create(null);
        if (reader == null) {
            none$ = None$.MODULE$;
        } else {
            coverage.elem = reader.read((GeneralParameterValue[])((Object[])new GeneralParameterValue[]{policy, gridsize, useJaiRead}));
            none$ = BoxedUnit.UNIT;
        }
        try {
            coordinateReferenceSystem = ((GridCoverage2D)coverage.elem).getCoordinateReferenceSystem();
        }
        catch (Exception exception) {
            coordinateReferenceSystem = source = null;
        }
        if (source == null) {
            String string = imageSourceOptions.readFromCRS();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                source = CRS.decode((String)imageSourceOptions.readFromCRS(), (boolean)true);
            }
        }
        String string = imageSourceOptions.readToCRS();
        String string3 = "";
        CoordinateReferenceSystem target = (string == null ? string3 != null : !string.equals(string3)) ? CRS.decode((String)imageSourceOptions.readToCRS(), (boolean)true) : null;
        MathTransform targetCRS = null;
        if (target != null) {
            if (source == null) {
                throw new IllegalArgumentException("Invalid arguments. Source coordinate reference system was not found.");
            }
            targetCRS = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)imageSourceOptions.disableErrorInCRS());
        }
        GridEnvelope gridRange2D = ((GridCoverage2D)coverage.elem).getGridGeometry().getGridRange();
        int[][] cords = (int[][])((Object[])new int[][]{{gridRange2D.getLow(0), gridRange2D.getLow(1)}, {gridRange2D.getLow(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getLow(1)}});
        Coordinate[] polyCoordinates = new Coordinate[5];
        IntRef index = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])cords), (Function1 & Serializable)point -> {
            GeotiffSchema$.$anonfun$decode$1(coverage, polyCoordinates, index, point);
            return BoxedUnit.UNIT;
        });
        polyCoordinates[index.elem] = polyCoordinates[0];
        GeometryFactory factory = new GeometryFactory();
        Polygon polygon = factory.createPolygon(polyCoordinates);
        if (targetCRS != null) {
            polygon = (Polygon)JTS.transform((Geometry)polygon, (MathTransform)targetCRS);
        }
        int nBands = ((GridCoverage2D)coverage.elem).getNumSampleDimensions();
        GridEnvelope dimensions = reader.getOriginalGridRange();
        GridCoordinates maxDimensions = dimensions.getHigh();
        int width = maxDimensions.getCoordinateValue(0) + 1;
        int height = maxDimensions.getCoordinateValue(1) + 1;
        int imageSize = height * width * nBands;
        Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0 & Serializable)() -> "image is too large");
        double[] decoded = (double[])Array$.MODULE$.ofDim(imageSize, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[] vals = new double[nBands];
            ((GridCoverage2D)coverage$1.elem).evaluate(new GridCoordinates2D(j, i), vals);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nBands).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)bandId -> {
                int offset = i * width + j + width * height * bandId;
                decoded$1[offset] = vals[bandId];
            });
        }));
        return new Some((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{origin, polygon.toText(), BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nBands), decoded}))})));
    }

    public static final /* synthetic */ void $anonfun$decode$1(ObjectRef coverage$1, Coordinate[] polyCoordinates$1, IntRef index$1, int[] point) {
        GridCoordinates2D coordinate2D = new GridCoordinates2D(point[0], point[1]);
        DirectPosition result = ((GridCoverage2D)coverage$1.elem).getGridGeometry().gridToWorld(coordinate2D);
        ++index$1.elem;
        polyCoordinates$1[index$1.elem - 1] = new Coordinate(result.getOrdinate(0), result.getOrdinate(1));
    }

    private GeotiffSchema$() {
    }
}

