/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ListLiteral
extends Expression {
    private final List<Expression> args = new ArrayList<Expression>();

    public ListLiteral(List<Expression> args) {
        super(JiffleType.LIST);
        for (Expression arg : args) {
            this.args.add(arg.forceDouble());
        }
    }

    @Override
    public void write(SourceWriter w) {
        if (this.args.isEmpty()) {
            w.append("new ArrayList()");
        } else {
            w.append("new ArrayList(Arrays.asList(");
            for (int i = 0; i < this.args.size(); ++i) {
                Expression arg = this.args.get(i);
                w.append(arg);
                if (i >= this.args.size() - 1) continue;
                w.append(", ");
            }
            w.append("))");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListLiteral that = (ListLiteral)o;
        return Objects.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.args);
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }
}

