/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.RenderingHints;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandEditors;
import org.apache.sedona.common.raster.inputstream.ByteArrayImageInputStream;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.process.vector.VectorToRasterProcess;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class RasterConstructors {
    public static GridCoverage2D fromArcInfoAsciiGrid(byte[] bytes) throws IOException {
        ArcGridReader reader = new ArcGridReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return reader.read(null);
    }

    public static GridCoverage2D fromGeoTiff(byte[] bytes) throws IOException {
        GeoTiffReader geoTiffReader = new GeoTiffReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return geoTiffReader.read(null);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, double value, Double noDataValue) throws FactoryException {
        DefaultFeatureCollection featureCollection = RasterConstructors.getFeatureCollection(geom, raster.getCoordinateReferenceSystem());
        double[] metadata = RasterAccessors.metadata(raster);
        if (metadata[4] < 0.0) {
            throw new IllegalArgumentException(String.format("ScaleX %f of the raster is negative, it should be positive", metadata[4]));
        }
        if (metadata[5] > 0.0) {
            throw new IllegalArgumentException(String.format("ScaleY %f of the raster is positive. It should be negative.", metadata[5]));
        }
        if (metadata[6] != 0.0) {
            throw new IllegalArgumentException(String.format("SkewX %d of the raster is not zero.", metadata[6]));
        }
        if (metadata[7] != 0.0) {
            throw new IllegalArgumentException(String.format("SkewY %d of the raster is not zero.", metadata[7]));
        }
        Envelope2D bound = JTS.getEnvelope2D((Envelope)geom.getEnvelopeInternal(), (CoordinateReferenceSystem)raster.getCoordinateReferenceSystem2D());
        double scaleX = Math.abs(metadata[4]);
        double scaleY = Math.abs(metadata[5]);
        int width = (int)bound.getWidth();
        int height = (int)bound.getHeight();
        if (width == 0 && height == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, scaleX, scaleY);
            width = 1;
            height = 1;
        } else if (height == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, (double)width, scaleY);
            height = 1;
        } else if (width == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, scaleX, (double)height);
            width = 1;
        } else {
            width = (int)((double)width / scaleX);
            height = (int)((double)height / scaleY);
        }
        VectorToRasterProcess rasterProcess = new VectorToRasterProcess();
        GridCoverage2D rasterized = rasterProcess.execute((SimpleFeatureCollection)featureCollection, Integer.valueOf(width), Integer.valueOf(height), "value", Double.toString(value), (org.opengis.geometry.Envelope)bound, null);
        if (noDataValue != null) {
            rasterized = RasterBandEditors.setBandNoDataValue(rasterized, 1, noDataValue);
        }
        WritableRaster writableRaster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(pixelType), (int)width, (int)height, (int)1, null);
        double[] samples = RasterUtils.getRaster(rasterized.getRenderedImage()).getSamples(0, 0, width, height, 0, (double[])null);
        writableRaster.setSamples(0, 0, width, height, 0, samples);
        return RasterUtils.create(writableRaster, rasterized.getGridGeometry(), rasterized.getSampleDimensions(), noDataValue);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, 1.0, null);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, double value) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, value, null);
    }

    public static DefaultFeatureCollection getFeatureCollection(Geometry geom, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("Raster");
        simpleFeatureTypeBuilder.setCRS(crs);
        simpleFeatureTypeBuilder.add("geometry", Geometry.class);
        SimpleFeatureType featureType = simpleFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.add((Object)geom);
        SimpleFeature simpleFeature = featureBuilder.buildFeature("1");
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        featureCollection.add(simpleFeature);
        return featureCollection;
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String dataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, dataType, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, "d", widthInPixel, heightInPixel, upperLeftX, upperLeftY, scaleX, scaleY, skewX, skewY, srid);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null);
    }

    public static GridCoverage2D makeNonEmptyRaster(int numBands, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid, double[][] rasterValues) {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBands, null);
        for (int i = 0; i < numBands; ++i) {
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, rasterValues[i]);
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null);
    }
}

