/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.node.DoubleLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.IntLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.util.Strings;
import java.util.Objects;

public class PrefixUnaryExpression
extends Expression {
    private final Expression arg;
    private final String op;

    public PrefixUnaryExpression(String op, Expression arg) {
        super(arg.getType());
        this.op = op;
        this.arg = arg;
    }

    public String toString() {
        return Strings.spaces(this.op, this.arg);
    }

    @Override
    public void write(SourceWriter w) {
        w.append(this.op).append(this.arg);
    }

    @Override
    public Expression forceDouble() {
        if (this.arg instanceof IntLiteral) {
            if ("-".equals(this.op)) {
                return new DoubleLiteral("-" + ((IntLiteral)this.arg).value);
            }
            if ("+".equals(this.op)) {
                return new DoubleLiteral(((IntLiteral)this.arg).value);
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrefixUnaryExpression that = (PrefixUnaryExpression)o;
        return Objects.equals(this.arg, that.arg) && Objects.equals(this.op, that.op);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.arg, this.op);
    }

    public Expression getArg() {
        return this.arg;
    }

    public String getOp() {
        return this.op;
    }
}

