/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterConstructors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.referencing.FactoryException;

public class RasterBandAccessors {
    public static Double getBandNoDataValue(GridCoverage2D raster, int band) {
        RasterUtils.ensureBand(raster, band);
        GridSampleDimension bandSampleDimension = raster.getSampleDimension(band - 1);
        double noDataValue = RasterUtils.getNoDataValue(bandSampleDimension);
        if (Double.isNaN(noDataValue)) {
            return null;
        }
        return noDataValue;
    }

    public static Double getBandNoDataValue(GridCoverage2D raster) {
        return RasterBandAccessors.getBandNoDataValue(raster, 1);
    }

    public static long getCount(GridCoverage2D raster, int band, boolean excludeNoDataValue) {
        Double bandNoDataValue = RasterBandAccessors.getBandNoDataValue(raster, band);
        int width = RasterAccessors.getWidth(raster);
        int height = RasterAccessors.getHeight(raster);
        if (excludeNoDataValue && bandNoDataValue != null) {
            RasterUtils.ensureBand(raster, band);
            Raster r = RasterUtils.getRaster(raster.getRenderedImage());
            double[] pixels = r.getSamples(0, 0, width, height, band - 1, (double[])null);
            long numberOfPixel = 0L;
            for (double bandValue : pixels) {
                if (Double.compare(bandValue, bandNoDataValue) == 0) continue;
                ++numberOfPixel;
            }
            return numberOfPixel;
        }
        return (long)width * (long)height;
    }

    public static long getCount(GridCoverage2D raster) {
        return RasterBandAccessors.getCount(raster, 1, true);
    }

    public static long getCount(GridCoverage2D raster, int band) {
        return RasterBandAccessors.getCount(raster, band, true);
    }

    public static double[] getSummaryStats(GridCoverage2D rasterGeom, int band, boolean excludeNoDataValue) {
        RasterUtils.ensureBand(rasterGeom, band);
        Raster raster = RasterUtils.getRaster(rasterGeom.getRenderedImage());
        int height = RasterAccessors.getHeight(rasterGeom);
        int width = RasterAccessors.getWidth(rasterGeom);
        double[] pixels = raster.getSamples(0, 0, width, height, band - 1, (double[])null);
        double count = 0.0;
        double sum = 0.0;
        double mean = 0.0;
        double stddev = 0.0;
        double min2 = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Double noDataValue = RasterBandAccessors.getBandNoDataValue(rasterGeom, band);
        for (double pixel : pixels) {
            if (excludeNoDataValue) {
                if (noDataValue != null && pixel == noDataValue) continue;
                count += 1.0;
                sum += pixel;
                min2 = Math.min(min2, pixel);
                max = Math.max(max, pixel);
                continue;
            }
            count = pixels.length;
            sum += pixel;
            min2 = Math.min(min2, pixel);
            max = Math.max(max, pixel);
        }
        if (count == 0.0) {
            return new double[]{0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        mean = sum / count;
        for (double pixel : pixels) {
            if (excludeNoDataValue) {
                if (noDataValue != null && pixel == noDataValue) continue;
                stddev += Math.pow(pixel - mean, 2.0);
                continue;
            }
            stddev += Math.pow(pixel - mean, 2.0);
        }
        stddev = Math.sqrt(stddev / count);
        return new double[]{count, sum, mean, stddev, min2, max};
    }

    public static double[] getSummaryStats(GridCoverage2D raster, int band) {
        return RasterBandAccessors.getSummaryStats(raster, band, true);
    }

    public static double[] getSummaryStats(GridCoverage2D raster) {
        return RasterBandAccessors.getSummaryStats(raster, 1, true);
    }

    public static GridCoverage2D getBand(GridCoverage2D rasterGeom, int[] bandIndexes) throws FactoryException {
        double[] metadata = RasterAccessors.metadata(rasterGeom);
        int width = (int)metadata[2];
        int height = (int)metadata[3];
        GridCoverage2D resultRaster = RasterConstructors.makeEmptyRaster(bandIndexes.length, width, height, metadata[0], metadata[1], metadata[4], metadata[5], metadata[6], metadata[7], (int)metadata[8]);
        Raster raster = RasterUtils.getRaster(rasterGeom.getRenderedImage());
        int dataTypeCode = raster.getDataBuffer().getDataType();
        boolean isDataTypeIntegral = RasterUtils.isDataTypeIntegral(dataTypeCode);
        int[] bandsDistinct = Arrays.stream(bandIndexes).distinct().toArray();
        HashMap<Integer, double[]> bandData = new HashMap<Integer, double[]>();
        for (int curBand : bandsDistinct) {
            RasterUtils.ensureBand(rasterGeom, curBand);
            if (isDataTypeIntegral) {
                bandData.put(curBand - 1, raster.getSamples(0, 0, width, height, curBand - 1, (int[])null));
                continue;
            }
            bandData.put(curBand - 1, raster.getSamples(0, 0, width, height, curBand - 1, (double[])null));
        }
        WritableRaster wr = RasterFactory.createBandedRaster((int)dataTypeCode, (int)width, (int)height, (int)bandIndexes.length, null);
        GridSampleDimension[] sampleDimensionsOg = rasterGeom.getSampleDimensions();
        GridSampleDimension[] sampleDimensionsResult = resultRaster.getSampleDimensions();
        for (int i = 0; i < bandIndexes.length; ++i) {
            sampleDimensionsResult[i] = sampleDimensionsOg[bandIndexes[i] - 1];
            if (isDataTypeIntegral) {
                wr.setSamples(0, 0, width, height, i, (int[])bandData.get(bandIndexes[i] - 1));
            } else {
                wr.setSamples(0, 0, width, height, i, (double[])bandData.get(bandIndexes[i] - 1));
            }
            Double noDataValue = RasterBandAccessors.getBandNoDataValue(rasterGeom, bandIndexes[i]);
            GridSampleDimension sampleDimension = sampleDimensionsResult[i];
            if (noDataValue == null) continue;
            sampleDimensionsResult[i] = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimension, (double)noDataValue);
        }
        return RasterUtils.create(wr, resultRaster.getGridGeometry(), sampleDimensionsResult);
    }

    public static String getBandType(GridCoverage2D raster, int band) {
        RasterUtils.ensureBand(raster, band);
        GridSampleDimension bandSampleDimension = raster.getSampleDimension(band - 1);
        return bandSampleDimension.getSampleDimensionType().name();
    }

    public static String getBandType(GridCoverage2D raster) {
        return RasterBandAccessors.getBandType(raster, 1);
    }

    public static boolean bandIsNoData(GridCoverage2D raster, int band) {
        double[] pixels;
        RasterUtils.ensureBand(raster, band);
        Raster rasterData = RasterUtils.getRaster(raster.getRenderedImage());
        int width = rasterData.getWidth();
        int height = rasterData.getHeight();
        double noDataValue = RasterUtils.getNoDataValue(raster.getSampleDimension(band - 1));
        if (Double.isNaN(noDataValue)) {
            return false;
        }
        for (double pixel : pixels = rasterData.getSamples(0, 0, width, height, band - 1, (double[])null)) {
            if (Double.compare(pixel, noDataValue) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean bandIsNoData(GridCoverage2D raster) {
        return RasterBandAccessors.bandIsNoData(raster, 1);
    }
}

