/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private static final String FIELD_NUMCOORDS = "numCoords";
    private static final String FIELD_NUMRINGS = null;
    private static final String FIELD_NUMELEMS = null;
    private GeometryFactory factory;
    private CoordinateSequenceFactory csFactory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private boolean isStrict = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;
    private int maxNumFieldValue;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = WKBReader.hexToInt(hex.charAt(i2));
            int nib0 = WKBReader.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = this.factory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public Geometry read(byte[] bytes) throws ParseException {
        try {
            return this.read(new ByteArrayInStream(bytes), bytes.length / 16);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public Geometry read(InStream is) throws IOException, ParseException {
        return this.read(is, Integer.MAX_VALUE);
    }

    private Geometry read(InStream is, int maxCoordNum) throws IOException, ParseException {
        this.maxNumFieldValue = maxCoordNum;
        this.dis.setInStream(is);
        return this.readGeometry(0);
    }

    private int readNumField(String fieldName) throws IOException, ParseException {
        int num = this.dis.readInt();
        if (num < 0 || num > this.maxNumFieldValue) {
            throw new ParseException(fieldName + " value is too large");
        }
        return num;
    }

    private Geometry readGeometry(int SRID) throws IOException, ParseException {
        boolean hasSRID;
        byte byteOrderWKB = this.dis.readByte();
        if (byteOrderWKB == 1) {
            this.dis.setOrder(2);
        } else if (byteOrderWKB == 0) {
            this.dis.setOrder(1);
        } else if (this.isStrict) {
            throw new ParseException("Unknown geometry byte order (not NDR or XDR): " + byteOrderWKB);
        }
        int typeInt = this.dis.readInt();
        int geometryType = (typeInt & 0xFFFF) % 1000;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0 || (typeInt & 0xFFFF) / 1000 == 1 || (typeInt & 0xFFFF) / 1000 == 3;
        boolean hasM = (typeInt & 0x40000000) != 0 || (typeInt & 0xFFFF) / 1000 == 2 || (typeInt & 0xFFFF) / 1000 == 3;
        this.inputDimension = 2 + (hasZ ? 1 : 0) + (hasM ? 1 : 0);
        boolean bl = hasSRID = (typeInt & 0x20000000) != 0;
        if (hasSRID) {
            SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        Geometry geom = null;
        switch (geometryType) {
            case 1: {
                geom = this.readPoint();
                break;
            }
            case 2: {
                geom = this.readLineString();
                break;
            }
            case 3: {
                geom = this.readPolygon();
                break;
            }
            case 4: {
                geom = this.readMultiPoint(SRID);
                break;
            }
            case 5: {
                geom = this.readMultiLineString(SRID);
                break;
            }
            case 6: {
                geom = this.readMultiPolygon(SRID);
                break;
            }
            case 7: {
                geom = this.readGeometryCollection(SRID);
                break;
            }
            default: {
                throw new ParseException("Unknown WKB type " + geometryType);
            }
        }
        this.setSRID(geom, SRID);
        return geom;
    }

    private Geometry setSRID(Geometry g2, int SRID) {
        if (SRID != 0) {
            g2.setSRID(SRID);
        }
        return g2;
    }

    private Point readPoint() throws IOException, ParseException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        if (Double.isNaN(pts.getX(0)) || Double.isNaN(pts.getY(0))) {
            return this.factory.createPoint();
        }
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException, ParseException {
        int size = this.readNumField(FIELD_NUMCOORDS);
        CoordinateSequence pts = this.readCoordinateSequenceLineString(size);
        return this.factory.createLineString(pts);
    }

    private LinearRing readLinearRing() throws IOException, ParseException {
        int size = this.readNumField(FIELD_NUMCOORDS);
        CoordinateSequence pts = this.readCoordinateSequenceRing(size);
        return this.factory.createLinearRing(pts);
    }

    private Polygon readPolygon() throws IOException, ParseException {
        int numRings = this.readNumField(FIELD_NUMRINGS);
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        if (numRings <= 0) {
            return this.factory.createPolygon();
        }
        LinearRing shell = this.readLinearRing();
        for (int i = 0; i < numRings - 1; ++i) {
            holes[i] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint readMultiPoint(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        Point[] geoms = new Point[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g2 = this.readGeometry(SRID);
            if (!(g2 instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i] = (Point)g2;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        LineString[] geoms = new LineString[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g2 = this.readGeometry(SRID);
            if (!(g2 instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i] = (LineString)g2;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        Polygon[] geoms = new Polygon[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g2 = this.readGeometry(SRID);
            if (!(g2 instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i] = (Polygon)g2;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        Geometry[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry(SRID);
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.csFactory.create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            for (int j = 0; j < targetDim; ++j) {
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private CoordinateSequence readCoordinateSequenceLineString(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (seq.size() == 0 || seq.size() >= 2) {
            return seq;
        }
        return CoordinateSequences.extend(this.csFactory, seq, 2);
    }

    private CoordinateSequence readCoordinateSequenceRing(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (CoordinateSequences.isRing(seq)) {
            return seq;
        }
        return CoordinateSequences.ensureValidRing(this.csFactory, seq);
    }

    private void readCoordinate() throws IOException, ParseException {
        for (int i = 0; i < this.inputDimension; ++i) {
            this.ordValues[i] = i <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
        }
    }
}

