/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.ft.point.StationFeature;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class StationHelper {
    private List<StationFeature> stations = new ArrayList<StationFeature>();
    private Map<String, StationFeature> stationHash = new HashMap<String, StationFeature>();
    private static final boolean debug = false;
    private LatLonRect rect;

    public void addStation(StationFeature s2) {
        this.stations.add(s2);
        this.stationHash.put(s2.getName(), s2);
    }

    public void setStations(List<StationFeature> nstations) {
        this.stations = new ArrayList<StationFeature>();
        this.stationHash = new HashMap<String, StationFeature>();
        for (StationFeature s2 : nstations) {
            this.addStation(s2);
        }
    }

    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            if (this.stations.isEmpty()) {
                return null;
            }
            Station s2 = this.stations.get(0);
            LatLonPoint llpt = LatLonPoint.create(s2.getLatitude(), s2.getLongitude());
            this.rect = new LatLonRect(llpt, 0.0, 0.0);
            for (int i = 1; i < this.stations.size(); ++i) {
                s2 = this.stations.get(i);
                this.rect.extend(LatLonPoint.create(s2.getLatitude(), s2.getLongitude()));
            }
        }
        if (this.rect.crossDateline() && this.rect.getWidth() > 350.0) {
            double lat_min = this.rect.getLowerLeftPoint().getLatitude();
            double deltaLat = this.rect.getUpperLeftPoint().getLatitude() - lat_min;
            this.rect = new LatLonRect(LatLonPoint.create(lat_min, -180.0), deltaLat, 360.0);
        }
        double newLowerLeftLat = this.rect.getLowerLeftPoint().getLatitude() - 5.0E-4;
        double newLowerLeftLon = this.rect.getLowerLeftPoint().getLongitude() - 5.0E-4;
        LatLonPoint newLowerLeftPoint = LatLonPoint.create(newLowerLeftLat, newLowerLeftLon);
        double newUpperRightLat = this.rect.getUpperRightPoint().getLatitude() + 5.0E-4;
        double newUpperRightLon = this.rect.getUpperRightPoint().getLongitude() + 5.0E-4;
        LatLonPoint newUpperRightPoint = LatLonPoint.create(newUpperRightLat, newUpperRightLon);
        this.rect.extend(newLowerLeftPoint);
        this.rect.extend(newUpperRightPoint);
        return this.rect;
    }

    public List<Station> getStations(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this.getStations();
        }
        ArrayList<Station> result = new ArrayList<Station>();
        for (StationFeature s2 : this.stations) {
            LatLonPoint latlonPt = LatLonPoint.create(s2.getLatitude(), s2.getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(s2);
        }
        return result;
    }

    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this.stations;
        }
        ArrayList<StationFeature> result = new ArrayList<StationFeature>();
        for (StationFeature s2 : this.stations) {
            LatLonPoint latlonPt = LatLonPoint.create(s2.getLatitude(), s2.getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(s2);
        }
        return result;
    }

    public StationFeature getStation(String name) {
        return this.stationHash.get(name);
    }

    public List<StationFeature> getStationFeatures() {
        return this.stations;
    }

    public List<Station> getStations() {
        ArrayList<Station> result = new ArrayList<Station>(this.stations.size());
        result.addAll(this.stations);
        return result;
    }

    public List<StationFeature> getStationFeaturesFromNames(List<String> stnNames) {
        ArrayList<StationFeature> result = new ArrayList<StationFeature>(stnNames.size());
        for (String ss : stnNames) {
            StationFeature s2 = this.stationHash.get(ss);
            if (s2 == null) continue;
            result.add(s2);
        }
        return result;
    }

    public List<StationFeature> getStationFeatures(List<Station> stations) {
        ArrayList<StationFeature> result = new ArrayList<StationFeature>(stations.size());
        for (Station s2 : stations) {
            StationFeature ss = this.stationHash.get(s2.getName());
            if (ss == null) continue;
            result.add(ss);
        }
        return result;
    }

    public StationFeature getStationFeature(Station stn) {
        return this.stationHash.get(stn.getName());
    }

    public List<Station> getStations(List<String> stnNames) {
        ArrayList<Station> result = new ArrayList<Station>(stnNames.size());
        for (String ss : stnNames) {
            Station s2 = this.stationHash.get(ss);
            if (s2 == null) continue;
            result.add(s2);
        }
        return result;
    }

    public StationHelper subset(LatLonRect bb) {
        StationHelper result = new StationHelper();
        result.setStations(this.getStationFeatures(bb));
        return result;
    }

    public StationHelper subset(List<StationFeature> stns) {
        StationHelper result = new StationHelper();
        result.setStations(stns);
        return result;
    }
}

