/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class NUWGConvention
extends CoordSysBuilder {
    private NavInfoList navInfo = new NavInfoList();
    private String xaxisName = "";
    private String yaxisName = "";
    private Grib1 grib;
    private static final boolean dumpNav = false;
    private StringBuilder buf = new StringBuilder(2000);

    public NUWGConvention() {
        this.conventionName = "NUWG";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findGlobalAttribute("_enhanced")) {
            return;
        }
        ds.addAttribute(null, new Attribute("_enhanced", ""));
        ImmutableList<Variable> vars = ds.getVariables();
        for (Variable v : vars) {
            if (0 > v.findDimensionIndex("nav")) continue;
            try {
                this.navInfo.add(new NavInfo(v));
            }
            catch (IOException ex) {
                this.parseInfo.format("ERROR NUWG reading NAV var = %s%n", v);
            }
        }
        this.navInfo.sort(new NavComparator());
        this.parseInfo.format("%s%n%n", this.navInfo);
        int mode = 3;
        try {
            mode = this.navInfo.getInt("grid_type_code");
        }
        catch (NoSuchElementException e) {
            log.warn("No mode in navInfo - assume 3");
        }
        try {
            if (mode == 0) {
                this.xaxisName = this.navInfo.getString("i_dim");
                this.yaxisName = this.navInfo.getString("j_dim");
            } else {
                this.xaxisName = this.navInfo.getString("x_dim");
                this.yaxisName = this.navInfo.getString("y_dim");
            }
        }
        catch (NoSuchElementException e) {
            log.warn("No mode in navInfo - assume = 1");
        }
        this.grib = new Grib1(mode);
        if (null == ds.findVariable(this.xaxisName)) {
            this.grib.makeXCoordAxis(ds, this.xaxisName);
            this.parseInfo.format("Generated x axis from NUWG nav= %s%n", this.xaxisName);
        } else if (this.xaxisName.equalsIgnoreCase("lon")) {
            try {
                boolean ok = true;
                Variable dc = ds.findVariable(this.xaxisName);
                Array coordVal = dc.read();
                IndexIterator coordIndex = coordVal.getIndexIterator();
                double coord1 = coordIndex.getDoubleNext();
                double coord2 = coordIndex.getDoubleNext();
                boolean increase = coord1 > coord2;
                coord1 = coord2;
                while (coordIndex.hasNext()) {
                    coord2 = coordIndex.getDoubleNext();
                    if (coord1 > coord2 ^ increase) {
                        ok = false;
                        break;
                    }
                    coord1 = coord2;
                }
                if (!ok) {
                    this.parseInfo.format("ERROR lon axis is not monotonic, regen from nav%n", new Object[0]);
                    this.grib.makeXCoordAxis(ds, this.xaxisName);
                }
            }
            catch (IOException ioe) {
                log.warn("IOException when reading xaxis = " + this.xaxisName);
            }
        }
        if (null == ds.findVariable(this.yaxisName)) {
            this.grib.makeYCoordAxis(ds, this.yaxisName);
            this.parseInfo.format("Generated y axis from NUWG nav=%s%n", this.yaxisName);
        }
        List<Dimension> dims = ds.getRootGroup().getDimensions();
        for (Dimension dim : dims) {
            Variable ncvar;
            List<Variable> ncvars;
            String dimName = dim.getShortName();
            if (null != ds.findVariable(dimName) || (ncvars = this.searchAliasedDimension(ds, dim)) == null || ncvars.isEmpty()) continue;
            if (ncvars.size() == 1) {
                ncvar = ncvars.get(0);
                if (!(ncvar instanceof VariableDS)) continue;
                if (this.makeCoordinateAxis(ncvar, dim)) {
                    this.parseInfo.format("Added referential coordAxis = ", new Object[0]);
                    ncvar.getNameAndDimensions(this.parseInfo, true, false);
                    this.parseInfo.format("%n", new Object[0]);
                    continue;
                }
                this.parseInfo.format("Couldnt add referential coordAxis = %s%n", ncvar.getFullName());
                continue;
            }
            if (ncvars.size() != 2) continue;
            if (dimName.equals("record")) {
                Variable ncvar2;
                Variable ncvar0 = ncvars.get(0);
                Variable ncvar1 = ncvars.get(1);
                Variable variable = ncvar2 = ncvar0.getShortName().equalsIgnoreCase("valtime") ? ncvar0 : ncvar1;
                if (this.makeCoordinateAxis(ncvar2, dim)) {
                    this.parseInfo.format("Added referential coordAxis (2) = ", new Object[0]);
                    ncvar2.getNameAndDimensions(this.parseInfo, true, false);
                    this.parseInfo.format("%n", new Object[0]);
                    String units = ncvar2.getUnitsString();
                    if (units == null) continue;
                    units = StringUtil2.remove(units, 40);
                    units = StringUtil2.remove(units, 41);
                    ((VariableDS)ncvar2).setUnitsString(units);
                    continue;
                }
                this.parseInfo.format("Couldnt add referential coordAxis = %s%n", ncvar2.getFullName());
                continue;
            }
            ncvar = ncvars.get(0);
            if (!(ncvar instanceof VariableDS)) continue;
            if (this.makeCoordinateAxis(ncvar, dim)) {
                this.parseInfo.format("Added referential boundary coordAxis (2) = ", new Object[0]);
                ncvar.getNameAndDimensions(this.parseInfo, true, false);
                this.parseInfo.format("%n", new Object[0]);
                continue;
            }
            this.parseInfo.format("Couldnt add referential coordAxis = %s%n", ncvar.getFullName());
        }
        if (this.grib.ct != null) {
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.grib.ct);
            v.addAttribute(new Attribute("_CoordinateAxes", this.xaxisName + " " + this.yaxisName));
            ds.addVariable(null, v);
        }
        ds.finish();
    }

    private boolean makeCoordinateAxis(Variable ncvar, Dimension dim) {
        if (ncvar.getRank() != 1) {
            return false;
        }
        Dimension vdim = ncvar.getDimension(0);
        if (!vdim.equals(dim)) {
            return false;
        }
        if (!dim.getShortName().equals(ncvar.getShortName())) {
            ncvar.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        return true;
    }

    private List<Variable> searchAliasedDimension(NetcdfDataset ds, Dimension dim) {
        String dimName = dim.getShortName();
        String alias = ds.findAttValueIgnoreCase(null, dimName, null);
        if (alias == null) {
            return null;
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        StringTokenizer parser = new StringTokenizer(alias, " ,");
        while (parser.hasMoreTokens()) {
            Iterator dimIter;
            Dimension dim2;
            String token = parser.nextToken();
            Variable ncvar = ds.findVariable(token);
            if (ncvar == null || ncvar.getRank() != 1 || !dimName.equals((dim2 = (Dimension)(dimIter = ((ImmutableList)ncvar.getDimensions()).iterator()).next()).getShortName())) continue;
            vars.add(ncvar);
            if (!this.debug) continue;
            System.out.print(" " + token);
        }
        if (this.debug) {
            System.out.println();
        }
        return vars;
    }

    public String extraInfo() {
        this.buf.setLength(0);
        this.buf.append(this.navInfo).append("%n");
        return this.buf.toString();
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.grib != null && this.grib.ct != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.grib.ct.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = this.grib.ct;
        }
        super.makeCoordinateTransforms(ds);
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase(this.xaxisName)) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase(this.yaxisName)) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        Dimension dim = v.getDimension(0);
        if (dim != null && dim.getShortName().equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
            if (SimpleUnit.isCompatible("sec", unit)) {
                return null;
            }
        }
        return AxisType.GeoZ;
    }

    public String getZisPositive(CoordinateAxis v) {
        String unit = v.getUnitsString();
        if (unit != null && SimpleUnit.isCompatible("m", unit)) {
            return "up";
        }
        return "down";
    }

    private class Grib1 {
        private String grid_name = "Projection";
        private int grid_code;
        private ProjectionCT ct;
        private int nx;
        private int ny;
        private double startx;
        private double starty;
        private double dx;
        private double dy;

        Grib1(int mode) {
            if (this.grid_name.isEmpty()) {
                this.grid_name = "grid_var";
            }
            this.grid_code = mode;
            if (0 == this.grid_code) {
                this.processLatLonProjection();
            } else if (3 == this.grid_code) {
                this.ct = this.makeLCProjection();
            } else if (5 == this.grid_code) {
                this.ct = this.makePSProjection();
            } else {
                throw new IllegalArgumentException("NUWGConvention: unknown grid_code= " + this.grid_code);
            }
        }

        CoordinateAxis makeXCoordAxis(NetcdfDataset ds, String xname) {
            CoordinateAxis1D v = new CoordinateAxis1D(ds, null, xname, DataType.DOUBLE, xname, 0 == this.grid_code ? "degrees_east" : "km", "synthesized X coord");
            v.addAttribute(new Attribute("_CoordinateAxisType", 0 == this.grid_code ? AxisType.Lon.toString() : AxisType.GeoX.toString()));
            v.setValues(this.nx, this.startx, this.dx);
            ds.addCoordinateAxis(v);
            return v;
        }

        CoordinateAxis makeYCoordAxis(NetcdfDataset ds, String yname) {
            CoordinateAxis1D v = new CoordinateAxis1D(ds, null, yname, DataType.DOUBLE, yname, 0 == this.grid_code ? "degrees_north" : "km", "synthesized Y coord");
            v.addAttribute(new Attribute("_CoordinateAxisType", 0 == this.grid_code ? AxisType.Lat.toString() : AxisType.GeoY.toString()));
            v.setValues(this.ny, this.starty, this.dy);
            ds.addCoordinateAxis(v);
            return v;
        }

        private ProjectionCT makeLCProjection() throws NoSuchElementException {
            double latin1 = NUWGConvention.this.navInfo.getDouble("Latin1");
            double latin2 = NUWGConvention.this.navInfo.getDouble("Latin2");
            double lov = NUWGConvention.this.navInfo.getDouble("Lov");
            double la1 = NUWGConvention.this.navInfo.getDouble("La1");
            double lo1 = NUWGConvention.this.navInfo.getDouble("Lo1");
            LambertConformal lc = new LambertConformal(latin1, lov, latin1, latin2);
            ProjectionPoint start = lc.latLonToProj(LatLonPoint.create(la1, lo1));
            if (NUWGConvention.this.debug) {
                System.out.println("start at proj coord " + start);
            }
            this.startx = start.getX();
            this.starty = start.getY();
            this.nx = NUWGConvention.this.navInfo.getInt("Nx");
            this.ny = NUWGConvention.this.navInfo.getInt("Ny");
            this.dx = NUWGConvention.this.navInfo.getDouble("Dx") / 1000.0;
            this.dy = NUWGConvention.this.navInfo.getDouble("Dy") / 1000.0;
            return new ProjectionCT(this.grid_name, "FGDC", lc);
        }

        private ProjectionCT makePSProjection() throws NoSuchElementException {
            double lov = NUWGConvention.this.navInfo.getDouble("Lov");
            double la1 = NUWGConvention.this.navInfo.getDouble("La1");
            double lo1 = NUWGConvention.this.navInfo.getDouble("Lo1");
            Stereographic ps = new Stereographic(90.0, lov, 0.933);
            ProjectionPoint start = ps.latLonToProj(LatLonPoint.create(la1, lo1));
            if (NUWGConvention.this.debug) {
                System.out.println("start at proj coord " + start);
            }
            this.startx = start.getX();
            this.starty = start.getY();
            this.nx = NUWGConvention.this.navInfo.getInt("Nx");
            this.ny = NUWGConvention.this.navInfo.getInt("Ny");
            this.dx = NUWGConvention.this.navInfo.getDouble("Dx") / 1000.0;
            this.dy = NUWGConvention.this.navInfo.getDouble("Dy") / 1000.0;
            return new ProjectionCT(this.grid_name, "FGDC", ps);
        }

        private void processLatLonProjection() throws NoSuchElementException {
            this.starty = NUWGConvention.this.navInfo.getDouble("La1");
            this.startx = NUWGConvention.this.navInfo.getDouble("Lo1");
            this.nx = NUWGConvention.this.navInfo.getInt("Ni");
            this.ny = NUWGConvention.this.navInfo.getInt("Nj");
            this.dx = NUWGConvention.this.navInfo.getDouble("Di");
            this.dy = NUWGConvention.this.navInfo.getDouble("Dj");
        }
    }

    private static class NavInfoList
    extends ArrayList<NavInfo> {
        private NavInfoList() {
        }

        public NavInfo findInfo(String name) {
            for (NavInfo nav : this) {
                if (!name.equalsIgnoreCase(nav.getName())) continue;
                return nav;
            }
            return null;
        }

        public double getDouble(String name) throws NoSuchElementException {
            NavInfo nav = this.findInfo(name);
            if (nav == null) {
                throw new NoSuchElementException("GRIB1 " + name);
            }
            if (nav.valueType == DataType.DOUBLE || nav.valueType == DataType.FLOAT) {
                return nav.dvalue;
            }
            if (nav.valueType == DataType.INT || nav.valueType == DataType.SHORT) {
                return nav.ivalue;
            }
            if (nav.valueType == DataType.BYTE) {
                return nav.bvalue;
            }
            throw new IllegalArgumentException("NUWGConvention.GRIB1.getDouble " + name + " type = " + (Object)((Object)nav.valueType));
        }

        public int getInt(String name) throws NoSuchElementException {
            NavInfo nav = this.findInfo(name);
            if (nav == null) {
                throw new NoSuchElementException("GRIB1 " + name);
            }
            if (nav.valueType == DataType.INT || nav.valueType == DataType.SHORT) {
                return nav.ivalue;
            }
            if (nav.valueType == DataType.DOUBLE || nav.valueType == DataType.FLOAT) {
                return (int)nav.dvalue;
            }
            if (nav.valueType == DataType.BYTE) {
                return nav.bvalue;
            }
            throw new IllegalArgumentException("NUWGConvention.GRIB1.getInt " + name + " type = " + (Object)((Object)nav.valueType));
        }

        public String getString(String name) throws NoSuchElementException {
            NavInfo nav = this.findInfo(name);
            if (nav == null) {
                throw new NoSuchElementException("GRIB1 " + name);
            }
            return nav.svalue;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(2000);
            buf.append("\nNav Info\n");
            buf.append("Name___________Value_____________________Description\n");
            for (NavInfo nava : this) {
                buf.append(nava).append("\n");
            }
            buf.append("\n");
            return buf.toString();
        }
    }

    private class NavInfo {
        Variable ncvar;
        DataType valueType;
        String svalue;
        byte bvalue;
        int ivalue;
        double dvalue;
        private StringBuilder buf = new StringBuilder(200);

        NavInfo(Variable ncvar) throws IOException {
            this.ncvar = ncvar;
            this.valueType = ncvar.getDataType();
            try {
                if (this.valueType == DataType.CHAR || this.valueType == DataType.STRING) {
                    this.svalue = ncvar.readScalarString();
                } else if (this.valueType == DataType.BYTE) {
                    this.bvalue = ncvar.readScalarByte();
                } else if (this.valueType == DataType.INT || this.valueType == DataType.SHORT) {
                    this.ivalue = ncvar.readScalarInt();
                } else {
                    this.dvalue = ncvar.readScalarDouble();
                }
            }
            catch (UnsupportedOperationException e) {
                NUWGConvention.this.parseInfo.format("Nav variable %s  not a scalar%n", this.getName());
            }
        }

        public String getName() {
            return this.ncvar.getShortName();
        }

        public String getDescription() {
            Attribute att = this.ncvar.attributes().findAttributeIgnoreCase("long_name");
            return att == null ? this.getName() : att.getStringValue();
        }

        public DataType getValueType() {
            return this.valueType;
        }

        public String getStringValue() {
            if (this.valueType == DataType.CHAR || this.valueType == DataType.STRING) {
                return this.svalue;
            }
            if (this.valueType == DataType.BYTE) {
                return Byte.toString(this.bvalue);
            }
            if (this.valueType == DataType.INT || this.valueType == DataType.SHORT) {
                return Integer.toString(this.ivalue);
            }
            return Double.toString(this.dvalue);
        }

        public String toString() {
            this.buf.setLength(0);
            this.buf.append(this.getName());
            this.buf.append(" ");
            Format.tab(this.buf, 15, true);
            this.buf.append(this.getStringValue());
            this.buf.append(" ");
            Format.tab(this.buf, 35, true);
            this.buf.append(this.getDescription());
            return this.buf.toString();
        }
    }

    private static class NavComparator
    implements Comparator<NavInfo> {
        private NavComparator() {
        }

        @Override
        public int compare(NavInfo n1, NavInfo n2) {
            return n1.getName().compareTo(n2.getName());
        }
    }
}

